/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.module;

import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.dimension.LevelStem;
import org.violetmoon.quark.content.tweaks.client.item.ClockTimePropertyFunction;
import org.violetmoon.quark.content.tweaks.client.item.CompassAnglePropertyFunction;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.play.entity.player.ZPlayerTick;
import org.violetmoon.zeta.event.play.loading.ZGatherHints;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;
import org.violetmoon.zeta.util.ItemNBTHelper;

@ZetaLoadModule(category="tweaks")
public class CompassesWorkEverywhereModule
extends ZetaModule {
    @Config
    public static boolean enableCompassNerf = true;
    @Config(flag="clock_nerf")
    public static boolean enableClockNerf = true;
    @Config
    public static boolean enableNether = true;
    @Config
    public static boolean enableEnd = true;
    @Hint(value="clock_nerf")
    Item clock = Items.f_42524_;
    public static final String TAG_CLOCK_CALCULATED = "quark:clock_calculated";
    public static final String TAG_COMPASS_CALCULATED = "quark:compass_calculated";
    public static final String TAG_WAS_IN_NETHER = "quark:compass_in_nether";
    public static final String TAG_POSITION_SET = "quark:compass_position_set";
    public static final String TAG_NETHER_TARGET_X = "quark:nether_x";
    public static final String TAG_NETHER_TARGET_Z = "quark:nether_z";

    @PlayEvent
    public void addAdditionalHints(ZGatherHints event) {
        if (!(enableNether || enableEnd || enableCompassNerf)) {
            return;
        }
        MutableComponent comp = Component.m_237113_((String)"");
        String pad = "";
        if (enableNether) {
            comp = comp.m_130946_(pad).m_7220_((Component)Component.m_237115_((String)"quark.jei.hint.compass_nether"));
            pad = " ";
        }
        if (enableEnd) {
            comp = comp.m_130946_(pad).m_7220_((Component)Component.m_237115_((String)"quark.jei.hint.compass_end"));
            pad = " ";
        }
        if (enableCompassNerf) {
            comp = comp.m_130946_(pad).m_7220_((Component)Component.m_237115_((String)"quark.jei.hint.compass_nerf"));
        }
        event.accept((ItemLike)Items.f_42522_, (Component)comp);
    }

    @PlayEvent
    public void onUpdate(ZPlayerTick.Start event) {
        Inventory inventory = event.getPlayer().m_150109_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41720_() == Items.f_42522_) {
                CompassesWorkEverywhereModule.tickCompass(event.getPlayer(), stack);
                continue;
            }
            if (stack.m_41720_() != Items.f_42524_) continue;
            CompassesWorkEverywhereModule.tickClock(stack);
        }
    }

    public static void tickClock(ItemStack stack) {
        boolean calculated = CompassesWorkEverywhereModule.isClockCalculated(stack);
        if (!calculated) {
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_CLOCK_CALCULATED, (boolean)true);
        }
    }

    public static boolean isClockCalculated(ItemStack stack) {
        return stack.m_41782_() && ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_CLOCK_CALCULATED, (boolean)false);
    }

    public static void tickCompass(Player player, ItemStack stack) {
        boolean calculated = CompassesWorkEverywhereModule.isCompassCalculated(stack);
        boolean nether = player.m_9236_().m_46472_().m_135782_().equals((Object)LevelStem.f_63972_.m_135782_());
        if (calculated) {
            boolean isInPortal;
            boolean wasInNether = ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_WAS_IN_NETHER, (boolean)false);
            BlockPos pos = player.m_20183_();
            boolean bl = isInPortal = player.m_9236_().m_8055_(pos).m_60734_() == Blocks.f_50142_;
            if (nether && !wasInNether && isInPortal) {
                ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_NETHER_TARGET_X, (int)pos.m_123341_());
                ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_NETHER_TARGET_Z, (int)pos.m_123343_());
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_WAS_IN_NETHER, (boolean)true);
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_POSITION_SET, (boolean)true);
            } else if (!nether && wasInNether) {
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_WAS_IN_NETHER, (boolean)false);
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_POSITION_SET, (boolean)false);
            }
        } else {
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_COMPASS_CALCULATED, (boolean)true);
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_WAS_IN_NETHER, (boolean)nether);
        }
    }

    public static boolean isCompassCalculated(ItemStack stack) {
        return stack.m_41782_() && ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_COMPASS_CALCULATED, (boolean)false);
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends CompassesWorkEverywhereModule {
        @LoadEvent
        public void clientSetup(ZClientSetup e) {
            e.enqueueWork(() -> {
                if (!this.enabled) {
                    return;
                }
                if (enableCompassNerf || enableNether || enableEnd) {
                    ItemProperties.register((Item)Items.f_42522_, (ResourceLocation)new ResourceLocation("angle"), (ItemPropertyFunction)new CompassAnglePropertyFunction());
                }
                if (enableClockNerf) {
                    ItemProperties.register((Item)Items.f_42524_, (ResourceLocation)new ResourceLocation("time"), (ItemPropertyFunction)new ClockTimePropertyFunction());
                }
            });
        }
    }
}

