/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.module;

import com.google.common.base.Functions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.common.Tags;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.handler.WoodSetHandler;
import org.violetmoon.quark.content.world.block.BlossomLeavesBlock;
import org.violetmoon.quark.content.world.config.BlossomTreeConfig;
import org.violetmoon.quark.content.world.gen.BlossomTreeGenerator;
import org.violetmoon.zeta.block.ZetaSaplingBlock;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.loading.ZGatherHints;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.world.PassthroughTreeGrower;
import org.violetmoon.zeta.world.WorldGenHandler;
import org.violetmoon.zeta.world.generator.Generator;

@ZetaLoadModule(category="world")
public class BlossomTreesModule
extends ZetaModule {
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLUE_BLOSSOM_KEY = BlossomTreesModule.registerKey("blue_blossom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LAVENDER_BLOSSOM_KEY = BlossomTreesModule.registerKey("lavender_blossom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORANGE_BLOSSOM_KEY = BlossomTreesModule.registerKey("orange_blossom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> YELLOW_BLOSSOM_KEY = BlossomTreesModule.registerKey("yellow_blossom");
    public static final ResourceKey<ConfiguredFeature<?, ?>> RED_BLOSSOM_KEY = BlossomTreesModule.registerKey("red_blossom");
    @Config
    public BlossomTreeConfig blue = new BlossomTreeConfig(200, (TagKey<Biome>)Tags.Biomes.IS_SNOWY);
    @Config
    public BlossomTreeConfig lavender = new BlossomTreeConfig(100, (TagKey<Biome>)Tags.Biomes.IS_SWAMP);
    @Config
    public BlossomTreeConfig orange = new BlossomTreeConfig(100, (TagKey<Biome>)BiomeTags.f_215816_);
    @Config
    public BlossomTreeConfig yellow = new BlossomTreeConfig(200, (TagKey<Biome>)Tags.Biomes.IS_PLAINS);
    @Config
    public BlossomTreeConfig red = new BlossomTreeConfig(30, (TagKey<Biome>)BiomeTags.f_207607_);
    @Config
    public static boolean dropLeafParticles = true;
    public static WoodSetHandler.WoodSet woodSet;
    public static final List<BlossomTree> blossomTrees;

    @LoadEvent
    public final void register(ZRegister event) {
        woodSet = WoodSetHandler.addWoodSet(event, this, "blossom", MapColor.f_283913_, MapColor.f_283748_, true);
        blossomTrees.add(this.make(event, "blue_blossom", MapColor.f_283869_, this.blue, BLUE_BLOSSOM_KEY));
        blossomTrees.add(this.make(event, "lavender_blossom", MapColor.f_283765_, this.lavender, LAVENDER_BLOSSOM_KEY));
        blossomTrees.add(this.make(event, "orange_blossom", MapColor.f_283895_, this.orange, ORANGE_BLOSSOM_KEY));
        blossomTrees.add(this.make(event, "yellow_blossom", MapColor.f_283832_, this.yellow, YELLOW_BLOSSOM_KEY));
        blossomTrees.add(this.make(event, "red_blossom", MapColor.f_283913_, this.red, RED_BLOSSOM_KEY));
    }

    private BlossomTree make(ZRegister event, String regname, MapColor color, BlossomTreeConfig quarkConfig, ResourceKey<ConfiguredFeature<?, ?>> configuredFeatureKey) {
        BlossomTree tree = new BlossomTree();
        tree.name = regname;
        tree.quarkConfig = quarkConfig;
        tree.leaves = new BlossomLeavesBlock(regname, this, color);
        tree.configuredFeatureKey = configuredFeatureKey;
        tree.grower = new PassthroughTreeGrower(configuredFeatureKey);
        tree.sapling = new ZetaSaplingBlock(regname, (ZetaModule)this, tree.grower);
        event.getVariantRegistry().addFlowerPot((Block)tree.sapling, this.zeta.registry.getRegistryName((Object)tree.sapling, (Registry)BuiltInRegistries.f_256975_).m_135815_(), (Function)Functions.identity());
        return tree;
    }

    @LoadEvent
    public void setup(ZCommonSetup e) {
        e.enqueueWork(() -> {
            for (BlossomTree tree : blossomTrees) {
                WorldGenHandler.addGenerator((ZetaModule)this, (Generator)new BlossomTreeGenerator(tree.quarkConfig, tree.configuredFeatureKey), (GenerationStep.Decoration)GenerationStep.Decoration.TOP_LAYER_MODIFICATION, (int)2);
                ComposterBlock.f_51914_.put((Object)tree.leaves.m_5456_(), 0.3f);
                ComposterBlock.f_51914_.put((Object)tree.sapling.m_5456_(), 0.3f);
                this.zeta.fuel.addFuel((Block)tree.sapling, 100);
            }
        });
    }

    @PlayEvent
    public void addAdditionalHints(ZGatherHints event) {
        for (BlossomTree tree : blossomTrees) {
            event.hintItem(this.zeta, (ItemLike)tree.sapling, new Object[0]);
        }
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)Quark.asResource(name));
    }

    static {
        blossomTrees = new ArrayList<BlossomTree>(5);
    }

    public static class BlossomTree {
        public String name;
        public BlossomTreeConfig quarkConfig;
        public BlossomLeavesBlock leaves;
        public ResourceKey<ConfiguredFeature<?, ?>> configuredFeatureKey;
        public AbstractTreeGrower grower;
        public ZetaSaplingBlock sapling;
    }
}

