/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.cannon_mount;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.transmission.sequencer.SequencerInstructions;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import rbasamoyai.createbigcannons.cannon_control.cannon_mount.CannonMountBlockEntity;
import rbasamoyai.createbigcannons.cannon_control.cannon_mount.ExtendsCannonMount;

public class YawControllerBlockEntity
extends KineticBlockEntity
implements ExtendsCannonMount {
    public YawControllerBlockEntity(BlockEntityType<? extends YawControllerBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        if (this.getCannonMount() == null) {
            return;
        }
        if (this.sequenceContext != null && this.sequenceContext.instruction() == SequencerInstructions.TURN_ANGLE) {
            this.getCannonMount().setSequencedYawAngleLimit((float)(this.sequenceContext.getEffectiveValue((double)this.getTheoreticalSpeed()) * 0.125));
        } else {
            this.getCannonMount().setSequencedYawAngleLimit(-1.0f);
        }
    }

    public void tick() {
        super.tick();
        CannonMountBlockEntity cmbe = this.getCannonMount();
        if (cmbe != null && cmbe.isRunning()) {
            cmbe.yawSpeed = this.getSpeed();
        }
    }

    public float calculateStressApplied() {
        float f;
        BlockEntity be = this.m_58904_().m_7702_(this.f_58858_.m_7494_());
        if (be instanceof CannonMountBlockEntity) {
            CannonMountBlockEntity cmbe = (CannonMountBlockEntity)be;
            f = cmbe.calculateStressApplied();
        } else {
            f = 0.0f;
        }
        return f;
    }

    @Override
    @Nullable
    public CannonMountBlockEntity getCannonMount() {
        CannonMountBlockEntity mount;
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_7494_());
        return blockEntity instanceof CannonMountBlockEntity ? (mount = (CannonMountBlockEntity)blockEntity) : null;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!super.addToGoggleTooltip(tooltip, isPlayerSneaking)) {
            return false;
        }
        CannonMountBlockEntity mount = this.getCannonMount();
        if (mount != null) {
            ExtendsCannonMount.addCannonInfoToTooltip(tooltip, mount.mountedContraption);
        }
        return true;
    }

    public void remove() {
        super.remove();
        CannonMountBlockEntity mount = this.getCannonMount();
        if (mount != null) {
            mount.yawSpeed = 0.0f;
        }
    }
}

