/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.config;

import com.simibubi.create.content.kinetics.BlockStressDefaults;
import com.simibubi.create.content.kinetics.BlockStressValues;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;
import rbasamoyai.createbigcannons.base.CBCDefaultStress;
import rbasamoyai.createbigcannons.config.CBCConfigBase;

public class CBCCfgStress
extends CBCConfigBase
implements BlockStressValues.IStressValueProvider {
    private final Map<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>> capacities = new HashMap<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>>();
    private final Map<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>> impacts = new HashMap<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>>();

    @Override
    public void registerAll(ForgeConfigSpec.Builder builder) {
        builder.comment(new String[]{"", Comments.su, Comments.impact}).push("impact");
        CBCDefaultStress.DEFAULT_IMPACTS.forEach((r, i) -> {
            if (r.m_135827_().equals("createbigcannons")) {
                this.getImpacts().put((ResourceLocation)r, (ForgeConfigSpec.ConfigValue<Double>)builder.define(r.m_135815_(), i));
            }
        });
        builder.pop();
    }

    public double getImpact(Block block) {
        block = this.redirectValues(block);
        ResourceLocation key = RegisteredObjects.getKeyOrThrow((Block)block);
        ForgeConfigSpec.ConfigValue<Double> value = this.getImpacts().get(key);
        if (value != null) {
            return (Double)value.get();
        }
        return 0.0;
    }

    public double getCapacity(Block block) {
        block = this.redirectValues(block);
        ResourceLocation key = RegisteredObjects.getKeyOrThrow((Block)block);
        ForgeConfigSpec.ConfigValue<Double> value = this.getCapacities().get(key);
        if (value != null) {
            return (Double)value.get();
        }
        return 0.0;
    }

    public Couple<Integer> getGeneratedRPM(Block block) {
        ResourceLocation key = RegisteredObjects.getKeyOrThrow((Block)(block = this.redirectValues(block)));
        Supplier supplier = (Supplier)BlockStressDefaults.GENERATOR_SPEEDS.get(key);
        if (supplier == null) {
            return null;
        }
        return (Couple)supplier.get();
    }

    public boolean hasImpact(Block block) {
        block = this.redirectValues(block);
        ResourceLocation key = RegisteredObjects.getKeyOrThrow((Block)block);
        return this.getImpacts().containsKey(key);
    }

    public boolean hasCapacity(Block block) {
        block = this.redirectValues(block);
        ResourceLocation key = RegisteredObjects.getKeyOrThrow((Block)block);
        return this.getCapacities().containsKey(key);
    }

    protected Block redirectValues(Block block) {
        return block;
    }

    public String getName() {
        return "stressValues.v2";
    }

    public Map<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>> getImpacts() {
        return this.impacts;
    }

    public Map<ResourceLocation, ForgeConfigSpec.ConfigValue<Double>> getCapacities() {
        return this.capacities;
    }

    private static class Comments {
        static String su = "[in Stress Units]";
        static String impact = "Configure the individual stress impact of mechanical blocks. Note that this cost is doubled for every speed increase it receives.";
        static String capacity = "Configure how much stress a source can accommodate for.";

        private Comments() {
        }
    }
}

