/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Random;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.RegistrationHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SCCreativeModeTabs;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.blocks.AbstractKeypadFurnaceBlock;
import net.geforcemods.securitycraft.blocks.InventoryScannerBlock;
import net.geforcemods.securitycraft.blocks.KeypadBarrelBlock;
import net.geforcemods.securitycraft.blocks.KeypadBlock;
import net.geforcemods.securitycraft.blocks.KeypadChestBlock;
import net.geforcemods.securitycraft.blocks.KeypadTrapDoorBlock;
import net.geforcemods.securitycraft.blocks.SecureRedstoneInterfaceBlock;
import net.geforcemods.securitycraft.blocks.mines.IMSBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedCauldronBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedHopperBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedPressurePlateBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedRedstoneBlock;
import net.geforcemods.securitycraft.commands.SCCommand;
import net.geforcemods.securitycraft.compat.hudmods.TOPDataProvider;
import net.geforcemods.securitycraft.items.SCManualItem;
import net.geforcemods.securitycraft.misc.CommonDoorActivator;
import net.geforcemods.securitycraft.misc.ConfigAttackTargetCheck;
import net.geforcemods.securitycraft.misc.PageGroup;
import net.geforcemods.securitycraft.misc.SCManualPage;
import net.geforcemods.securitycraft.util.HasManualPage;
import net.geforcemods.securitycraft.util.Reinforced;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="securitycraft")
@Mod.EventBusSubscriber(modid="securitycraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SecurityCraft {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String MODID = "securitycraft";
    public static final GameRules.Key<GameRules.BooleanValue> RULE_FAKE_WATER_SOURCE_CONVERSION = GameRules.m_46189_((String)"fakeWaterSourceConversion", (GameRules.Category)GameRules.Category.UPDATES, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)true));
    public static final GameRules.Key<GameRules.BooleanValue> RULE_FAKE_LAVA_SOURCE_CONVERSION = GameRules.m_46189_((String)"fakeLavaSourceConversion", (GameRules.Category)GameRules.Category.UPDATES, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)false));
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("securitycraft", "securitycraft"), () -> SecurityCraft.getVersion(), SecurityCraft.getVersion()::equals, SecurityCraft.getVersion()::equals);
    public static final Random RANDOM = new Random();
    public static final boolean IS_A_SODIUM_MOD_INSTALLED = (Boolean)Util.m_137537_(() -> {
        ModList modList = ModList.get();
        return modList.isLoaded("embeddium") || modList.isLoaded("rubidium") || modList.isLoaded("sodium");
    });

    public SecurityCraft() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigHandler.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ConfigHandler.SERVER_SPEC);
        SCContent.BLOCKS.register(modEventBus);
        SCContent.BLOCK_ENTITY_TYPES.register(modEventBus);
        SCContent.COMMAND_ARGUMENT_TYPES.register(modEventBus);
        SCContent.DATA_SERIALIZERS.register(modEventBus);
        SCContent.ENTITY_TYPES.register(modEventBus);
        SCContent.FLUIDS.register(modEventBus);
        SCContent.ITEMS.register(modEventBus);
        SCContent.LOOT_ITEM_CONDITION_TYPES.register(modEventBus);
        SCContent.MENU_TYPES.register(modEventBus);
        SCContent.PARTICLE_TYPES.register(modEventBus);
        SCContent.RECIPE_SERIALIZERS.register(modEventBus);
        SCCreativeModeTabs.CREATIVE_MODE_TABS.register(modEventBus);
    }

    @SubscribeEvent
    public static void onFMLCommonSetup(FMLCommonSetupEvent event) {
        RegistrationHandler.registerPackets();
        RegistrationHandler.registerFakeLiquidRecipes();
    }

    @SubscribeEvent
    public static void onInterModEnqueue(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)MODID, (String)"registerExtractionBlock", ReinforcedHopperBlock.ExtractionBlock::new);
        InterModComms.sendTo((String)MODID, (String)"registerExtractionBlock", IMSBlock.ExtractionBlock::new);
        InterModComms.sendTo((String)MODID, (String)"registerPasscodeConvertible", KeypadBlock.Convertible::new);
        InterModComms.sendTo((String)MODID, (String)"registerPasscodeConvertible", KeypadBarrelBlock.Convertible::new);
        InterModComms.sendTo((String)MODID, (String)"registerPasscodeConvertible", KeypadChestBlock.Convertible::new);
        InterModComms.sendTo((String)MODID, (String)"registerPasscodeConvertible", KeypadTrapDoorBlock.Convertible::new);
        InterModComms.sendTo((String)MODID, (String)"registerPasscodeConvertible", () -> new AbstractKeypadFurnaceBlock.Convertible(Blocks.f_50094_, (Block)SCContent.KEYPAD_FURNACE.get()));
        InterModComms.sendTo((String)MODID, (String)"registerPasscodeConvertible", () -> new AbstractKeypadFurnaceBlock.Convertible(Blocks.f_50619_, (Block)SCContent.KEYPAD_SMOKER.get()));
        InterModComms.sendTo((String)MODID, (String)"registerPasscodeConvertible", () -> new AbstractKeypadFurnaceBlock.Convertible(Blocks.f_50620_, (Block)SCContent.KEYPAD_BLAST_FURNACE.get()));
        InterModComms.sendTo((String)MODID, (String)"registerSentryAttackTargetCheck", ConfigAttackTargetCheck::new);
        InterModComms.sendTo((String)MODID, (String)"registerDoorActivator", CommonDoorActivator::new);
        InterModComms.sendTo((String)MODID, (String)"registerDoorActivator", InventoryScannerBlock.DoorActivator::new);
        InterModComms.sendTo((String)MODID, (String)"registerDoorActivator", ReinforcedPressurePlateBlock.DoorActivator::new);
        InterModComms.sendTo((String)MODID, (String)"registerDoorActivator", ReinforcedRedstoneBlock.DoorActivator::new);
        InterModComms.sendTo((String)MODID, (String)"registerDoorActivator", SecureRedstoneInterfaceBlock.DoorActivator::new);
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TOPDataProvider::new);
        }
    }

    @SubscribeEvent
    public static void onInterModProcess(InterModProcessEvent event) {
        SecurityCraft.collectSCContentData();
        ForgeChunkManager.setForcedChunkLoadingCallback((String)MODID, (level, ticketHelper) -> ticketHelper.getEntityTickets().forEach((uuid, chunk) -> {
            if (level.m_8791_(uuid) == null) {
                ticketHelper.removeAllTickets(uuid);
            }
        }));
        ReinforcedCauldronBlock.IReinforcedCauldronInteraction.bootStrap();
    }

    public static void collectSCContentData() {
        EnumMap<PageGroup, List> groupStacks = new EnumMap<PageGroup, List>(PageGroup.class);
        for (Field field : SCContent.class.getFields()) {
            try {
                if (field.isAnnotationPresent(Reinforced.class)) {
                    Block block = (Block)((RegistryObject)field.get(null)).get();
                    IReinforcedBlock rb = (IReinforcedBlock)block;
                    IReinforcedBlock.VANILLA_TO_SECURITYCRAFT.put(rb.getVanillaBlock(), block);
                    IReinforcedBlock.SECURITYCRAFT_TO_VANILLA.put(block, rb.getVanillaBlock());
                }
                if (!field.isAnnotationPresent(HasManualPage.class)) continue;
                Object o = ((RegistryObject)field.get(null)).get();
                HasManualPage hmp = field.getAnnotation(HasManualPage.class);
                Item item = ((ItemLike)o).m_5456_();
                PageGroup group2 = hmp.value();
                boolean wasNotAdded = false;
                MutableComponent title = Component.m_237115_((String)"");
                Object key = "help.";
                if (group2 != PageGroup.NONE) {
                    if (!groupStacks.containsKey((Object)group2)) {
                        groupStacks.put(group2, new ArrayList());
                        title = Utils.localize(group2.getTitle(), new Object[0]);
                        key = (String)key + group2.getSpecialInfoKey();
                        wasNotAdded = true;
                    }
                    ((List)groupStacks.get((Object)group2)).add(new ItemStack((ItemLike)item));
                } else {
                    title = Utils.localize(item.m_5524_(), new Object[0]);
                    key = (String)key + item.m_5524_().substring(5) + ".info";
                }
                if (group2 != PageGroup.NONE && !wasNotAdded) continue;
                SCManualItem.PAGES.add(new SCManualPage(item, group2, (Component)title, (Component)Component.m_237115_((String)((String)key).replace("..", ".")), hmp.designedBy(), hmp.hasRecipeDescription()));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        groupStacks.forEach((group, list) -> group.setItems(Ingredient.m_43921_(list.stream())));
    }

    public void registerCommands(RegisterCommandsEvent event) {
        SCCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static String getVersion() {
        return "v" + ((ModContainer)ModList.get().getModContainerById(MODID).get()).getModInfo().getVersion().toString();
    }
}

