/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.PortableRadarBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.TeamUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class PortableRadarBlockEntity
extends CustomizableBlockEntity
implements ITickingBlockEntity {
    private Option.IntOption searchRadiusOption = new Option.IntOption("searchRadius", 25, 1, 50, 1);
    private Option.IntOption searchDelayOption = new Option.IntOption("searchDelay", 4, 4, 10, 1);
    private Option.BooleanOption repeatMessageOption = new Option.BooleanOption("repeatMessage", true);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private Option.RespectInvisibilityOption respectInvisibility = new Option.RespectInvisibilityOption();
    private Set<Owner> seenPlayers = new HashSet<Owner>();
    private int ticksUntilNextSearch = this.getSearchDelay();

    public PortableRadarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.PORTABLE_RADAR_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!((Boolean)this.disabled.get()).booleanValue() && this.ticksUntilNextSearch-- <= 0) {
            this.ticksUntilNextSearch = this.getSearchDelay();
            AABB area = new AABB(pos).m_82400_(this.getSearchRadius());
            List closebyPlayers = level.m_6443_(Player.class, area, e -> (!this.isOwnedBy((Entity)e) || !this.ignoresOwner()) && (!this.isModuleEnabled(ModuleType.DENYLIST) && !this.isAllowed((Entity)e) || this.isDenied((Entity)e)) && e.m_142065_() && !this.respectInvisibility.isConsideredInvisible((LivingEntity)e));
            List<Owner> closebyOwners = closebyPlayers.stream().map(Owner::new).toList();
            if (this.isModuleEnabled(ModuleType.REDSTONE)) {
                PortableRadarBlock.togglePowerOutput(level, pos, !closebyPlayers.isEmpty());
            }
            if (!closebyPlayers.isEmpty()) {
                Collection<ServerPlayer> onlineTeamPlayers = TeamUtils.getOnlinePlayersFromOwner(level.m_7654_(), this.getOwner());
                for (Player closebyPlayer : closebyPlayers) {
                    if (!this.shouldSendMessage(closebyPlayer)) continue;
                    MutableComponent attackedName = closebyPlayer.m_7755_().m_6879_().m_130940_(ChatFormatting.ITALIC);
                    Component coords = Utils.getFormattedCoordinates(pos);
                    MutableComponent text = this.m_8077_() ? Utils.localize("messages.securitycraft:portableRadar.withName", attackedName, this.m_7770_().m_6879_().m_130940_(ChatFormatting.ITALIC), coords) : Utils.localize("messages.securitycraft:portableRadar.withoutName", attackedName, coords);
                    if (onlineTeamPlayers.isEmpty()) continue;
                    onlineTeamPlayers.forEach(player -> PlayerUtils.sendMessageToPlayer((Player)player, Utils.localize(((Block)SCContent.PORTABLE_RADAR.get()).m_7705_(), new Object[0]), text, ChatFormatting.BLUE));
                }
            }
            this.seenPlayers.removeIf(owner -> !closebyOwners.contains(owner));
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.REDSTONE) {
            PortableRadarBlock.togglePowerOutput(this.f_58857_, this.f_58858_, false);
        }
    }

    @Override
    public void readOptions(CompoundTag tag) {
        if (tag.m_128441_("enabled")) {
            tag.m_128379_("disabled", !tag.m_128471_("enabled"));
        }
        for (Option<?> option : this.customOptions()) {
            option.load(tag);
        }
    }

    public boolean shouldSendMessage(Player player) {
        return this.seenPlayers.add(new Owner(player)) || (Boolean)this.repeatMessageOption.get() != false;
    }

    public double getSearchRadius() {
        return ((Integer)this.searchRadiusOption.get()).intValue();
    }

    public int getSearchDelay() {
        return (Integer)this.searchDelayOption.get() * 20;
    }

    @Override
    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.REDSTONE, ModuleType.ALLOWLIST, ModuleType.DENYLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.searchRadiusOption, this.searchDelayOption, this.repeatMessageOption, this.disabled, this.ignoreOwner, this.respectInvisibility};
    }
}

