/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class SaltData
extends SavedData {
    private static final Object DUMMY = new Object();
    private static SaltData instance;
    private final Map<UUID, byte[]> saltMap = new ConcurrentHashMap<UUID, byte[]>();
    private final Map<UUID, Object> saltKeysInUse = new ConcurrentHashMap<UUID, Object>();

    private SaltData() {
    }

    public static void refreshLevel(ServerLevel level) {
        instance = (SaltData)level.m_8895_().m_164861_(SaltData::load, SaltData::new, "securitycraft-salts");
    }

    public static void invalidate() {
        instance = null;
    }

    public static boolean containsKey(UUID saltKey) {
        if (saltKey == null) {
            return false;
        }
        return SaltData.instance.saltMap.containsKey(saltKey);
    }

    public static void setKeyInUse(UUID saltKey) {
        if (saltKey != null) {
            SaltData.instance.saltKeysInUse.put(saltKey, DUMMY);
        }
    }

    public static boolean isKeyInUse(UUID saltKey) {
        if (saltKey == null) {
            return false;
        }
        return SaltData.instance.saltKeysInUse.containsKey(saltKey);
    }

    public static byte[] getSalt(UUID saltKey) {
        if (saltKey == null) {
            return null;
        }
        byte[] salt = SaltData.instance.saltMap.get(saltKey);
        return salt == null || salt.length == 0 ? null : salt;
    }

    public static UUID putSalt(byte[] salt) {
        UUID saltKey = UUID.randomUUID();
        SaltData.instance.saltMap.put(saltKey, salt);
        SaltData.setKeyInUse(saltKey);
        instance.m_77762_();
        return saltKey;
    }

    public static void removeSalt(UUID saltKey) {
        if (saltKey != null) {
            SaltData.instance.saltMap.remove(saltKey);
            SaltData.instance.saltKeysInUse.remove(saltKey);
            instance.m_77762_();
        }
    }

    public static UUID copySaltToNewKey(UUID oldKey) {
        if (oldKey != null) {
            return SaltData.putSalt(SaltData.getSalt(oldKey));
        }
        return null;
    }

    public static SaltData load(CompoundTag tag) {
        SaltData saltData = new SaltData();
        ListTag listtag = tag.m_128437_("Salts", 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag saltTag = listtag.m_128728_(i);
            saltData.saltMap.put(UUID.fromString(saltTag.m_128461_("key")), saltTag.m_128463_("salt"));
        }
        return saltData;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag saltTable = new ListTag();
        for (Map.Entry<UUID, byte[]> saltMapping : this.saltMap.entrySet()) {
            CompoundTag saltTag = new CompoundTag();
            saltTag.m_128359_("key", saltMapping.getKey().toString());
            saltTag.m_128382_("salt", saltMapping.getValue());
            saltTable.add((Object)saltTag);
        }
        tag.m_128365_("Salts", (Tag)saltTable);
        return tag;
    }
}

