/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.NetworkEvent;

public class SetSentryMode {
    private List<Info> sentriesToUpdate;

    public SetSentryMode() {
    }

    public SetSentryMode(List<Info> sentriesToUpdate) {
        sentriesToUpdate.removeIf(Objects::isNull);
        this.sentriesToUpdate = sentriesToUpdate;
    }

    public SetSentryMode(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        this.sentriesToUpdate = new ArrayList<Info>();
        for (int i = 0; i < size; ++i) {
            this.sentriesToUpdate.add(Info.read(buf));
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.sentriesToUpdate.size());
        this.sentriesToUpdate.forEach(info -> info.write(buf));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        Level level = player.m_9236_();
        for (Info info : this.sentriesToUpdate) {
            List sentries;
            if (!level.m_46749_(info.pos) || (sentries = level.m_45976_(Sentry.class, new AABB(info.pos))).isEmpty() || !((Sentry)sentries.get(0)).isOwnedBy((Entity)player)) continue;
            ((Sentry)sentries.get(0)).toggleMode((Player)player, info.mode, false);
        }
    }

    public record Info(BlockPos pos, int mode) {
        public static Info read(FriendlyByteBuf buf) {
            return new Info(buf.m_130135_(), buf.m_130242_());
        }

        public void write(FriendlyByteBuf buf) {
            buf.m_130064_(this.pos);
            buf.m_130130_(this.mode);
        }
    }
}

