/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.BlockPocketManagerBlockEntity;
import net.geforcemods.securitycraft.network.client.BlockPocketManagerFailedActivation;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ToggleBlockPocketManager {
    private BlockPos pos;
    private int size;
    private boolean enabling;

    public ToggleBlockPocketManager() {
    }

    public ToggleBlockPocketManager(BlockPocketManagerBlockEntity be, boolean enabling) {
        this.pos = be.m_58899_();
        this.size = be.getSize();
        this.enabling = enabling;
    }

    public ToggleBlockPocketManager(FriendlyByteBuf buf) {
        this.pos = BlockPos.m_122022_((long)buf.readLong());
        this.size = buf.readInt();
        this.enabling = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeLong(this.pos.m_121878_());
        buf.writeInt(this.size);
        buf.writeBoolean(this.enabling);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        BlockPocketManagerBlockEntity be;
        ServerPlayer player = ctx.get().getSender();
        BlockEntity blockEntity = player.m_9236_().m_7702_(this.pos);
        if (blockEntity instanceof BlockPocketManagerBlockEntity && (be = (BlockPocketManagerBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            be.setSize(this.size);
            MutableComponent feedback = this.enabling ? be.enableMultiblock() : be.disableMultiblock();
            if (feedback != null) {
                if (this.enabling && !be.isEnabled()) {
                    SecurityCraft.CHANNEL.reply((Object)new BlockPocketManagerFailedActivation(this.pos), ctx.get());
                }
                PlayerUtils.sendMessageToPlayer((Player)player, Utils.localize(((Block)SCContent.BLOCK_POCKET_MANAGER.get()).m_7705_(), new Object[0]), feedback, ChatFormatting.DARK_AQUA, false);
            }
            be.m_6596_();
        }
    }
}

