/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.core.util;

import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class PathUtil {
    private static final String unsafeFileChars = "[^\\w-]";
    private static boolean atomicMoveSupported = true;

    public static String sanitizePathName(String filename) {
        return String.join((CharSequence)"_", filename.split(unsafeFileChars));
    }

    public static void writeUsingTempFile(Path path, Iterable<? extends CharSequence> lines) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Path tempFile = Files.createTempFile(path.getParent(), null, null, new FileAttribute[0]);
        try {
            Files.write(tempFile, lines, new OpenOption[0]);
            PathUtil.moveAtomicReplace(tempFile, path);
        }
        finally {
            if (Files.exists(tempFile, new LinkOption[0])) {
                Files.delete(tempFile);
            }
        }
    }

    private static void moveAtomicReplace(Path source, Path target) throws IOException {
        if (atomicMoveSupported) {
            try {
                Files.move(source, target, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                return;
            }
            catch (AtomicMoveNotSupportedException ignored) {
                atomicMoveSupported = false;
            }
        }
        Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
    }
}

