/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.model.turtle;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class ModelTransformer {
    private static final int[] INVERSE_ORDER = new int[]{3, 2, 1, 0};
    private static final int STRIDE = DefaultVertexFormat.f_85811_.m_86017_();
    private static final int POS_OFFSET = ModelTransformer.findOffset(DefaultVertexFormat.f_85811_, DefaultVertexFormat.f_85804_);
    protected final Matrix4f transformation;
    protected final boolean invert;
    @Nullable
    private TransformedQuads cache;

    public ModelTransformer(Transformation transformation) {
        this.transformation = transformation.m_252783_();
        this.invert = transformation.m_252783_().determinant() < 0.0f;
    }

    public List<BakedQuad> transform(List<BakedQuad> quads) {
        if (quads.isEmpty()) {
            return List.of();
        }
        TransformedQuads cache = this.cache;
        if (cache != null && quads.equals(cache.original())) {
            return cache.transformed();
        }
        ArrayList<BakedQuad> transformed = new ArrayList<BakedQuad>(quads.size());
        for (BakedQuad quad : quads) {
            transformed.add(this.transformQuad(quad));
        }
        this.cache = new TransformedQuads(quads, transformed);
        return transformed;
    }

    private BakedQuad transformQuad(BakedQuad quad) {
        int[] inputData = quad.m_111303_();
        int[] outputData = new int[inputData.length];
        for (int i = 0; i < 4; ++i) {
            int inStart = STRIDE * i;
            int outStart = ModelTransformer.getVertexOffset(i, this.invert);
            System.arraycopy(inputData, inStart, outputData, outStart, STRIDE);
            int inPosStart = inStart + POS_OFFSET;
            int outPosStart = outStart + POS_OFFSET;
            float x = Float.intBitsToFloat(inputData[inPosStart]);
            float y = Float.intBitsToFloat(inputData[inPosStart + 1]);
            float z = Float.intBitsToFloat(inputData[inPosStart + 2]);
            Vector4f pos = new Vector4f(x, y, z, 1.0f);
            this.transformation.transformProject(pos);
            outputData[outPosStart] = Float.floatToRawIntBits(pos.x());
            outputData[outPosStart + 1] = Float.floatToRawIntBits(pos.y());
            outputData[outPosStart + 2] = Float.floatToRawIntBits(pos.z());
        }
        Direction direction = Direction.m_252919_((Matrix4f)this.transformation, (Direction)quad.m_111306_());
        return new BakedQuad(outputData, quad.m_111305_(), direction, quad.m_173410_(), quad.m_111307_());
    }

    public static int getVertexOffset(int vertex, boolean invert) {
        return (invert ? INVERSE_ORDER[vertex] : vertex) * STRIDE;
    }

    private static int findOffset(VertexFormat format, VertexFormatElement element) {
        int offset = 0;
        for (VertexFormatElement other : format.m_86023_()) {
            if (other == element) {
                return offset / 4;
            }
            offset += element.m_86050_();
        }
        throw new IllegalArgumentException("Cannot find " + element + " in " + format);
    }

    private record TransformedQuads(List<BakedQuad> original, List<BakedQuad> transformed) {
    }
}

