/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.core.util.Nullability;
import dan200.computercraft.shared.computer.upload.UploadResult;
import dan200.computercraft.shared.network.MessageType;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.NetworkMessages;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class UploadResultMessage
implements NetworkMessage<ClientNetworkContext> {
    private final int containerId;
    private final UploadResult result;
    @Nullable
    private final Component errorMessage;

    private UploadResultMessage(AbstractContainerMenu container, UploadResult result, @Nullable Component errorMessage) {
        this.containerId = container.f_38840_;
        this.result = result;
        this.errorMessage = errorMessage;
    }

    public static UploadResultMessage queued(AbstractContainerMenu container) {
        return new UploadResultMessage(container, UploadResult.QUEUED, null);
    }

    public static UploadResultMessage consumed(AbstractContainerMenu container) {
        return new UploadResultMessage(container, UploadResult.CONSUMED, null);
    }

    public static UploadResultMessage error(AbstractContainerMenu container, Component errorMessage) {
        return new UploadResultMessage(container, UploadResult.ERROR, errorMessage);
    }

    public UploadResultMessage(FriendlyByteBuf buf) {
        this.containerId = buf.m_130242_();
        this.result = (UploadResult)buf.m_130066_(UploadResult.class);
        this.errorMessage = this.result == UploadResult.ERROR ? buf.m_130238_() : null;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.containerId);
        buf.m_130068_((Enum)this.result);
        if (this.result == UploadResult.ERROR) {
            buf.m_130083_(Nullability.assertNonNull(this.errorMessage));
        }
    }

    @Override
    public void handle(ClientNetworkContext context) {
        context.handleUploadResult(this.containerId, this.result, this.errorMessage);
    }

    @Override
    public MessageType<UploadResultMessage> type() {
        return NetworkMessages.UPLOAD_RESULT;
    }
}

