/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj;

import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderLayer;
import java.util.ArrayList;
import malte0811.modelsplitter.model.MaterialLibrary;
import malte0811.modelsplitter.model.Polygon;
import malte0811.modelsplitter.model.UVCoords;
import malte0811.modelsplitter.model.Vertex;

public class TextureCoordinateRemapper {
    private final ShaderCase shaderCase;
    private ShaderLayer shaderLayer;

    public TextureCoordinateRemapper(ShaderCase shaderCase) {
        this.shaderCase = shaderCase;
    }

    public void setRenderPass(int pass) {
        if (this.shaderCase != null) {
            this.shaderLayer = this.shaderCase.getLayers()[pass];
        }
    }

    public Polygon<MaterialLibrary.OBJMaterial> remapCoord(Polygon<MaterialLibrary.OBJMaterial> face) {
        if (this.shaderCase == null) {
            return face;
        }
        double[] texBounds = this.shaderLayer.getTextureBounds();
        double[] cutBounds = this.shaderLayer.getCutoutBounds();
        if (texBounds == null && cutBounds == null) {
            return face;
        }
        ArrayList<Vertex> newPoints = new ArrayList<Vertex>();
        for (Vertex vertex : face.getPoints()) {
            double dV;
            double dU;
            UVCoords texCoord = vertex.uv();
            if (texBounds != null) {
                if (texBounds[0] > texCoord.u() || texCoord.u() > texBounds[2] || texBounds[1] > texCoord.v() || texCoord.v() > texBounds[3]) {
                    return null;
                }
                dU = texBounds[2] - texBounds[0];
                dV = texBounds[3] - texBounds[1];
                texCoord = new UVCoords((texCoord.u() - texBounds[0]) / dU, (texCoord.v() - texBounds[1]) / dV);
            }
            if (cutBounds != null) {
                dU = cutBounds[2] - cutBounds[0];
                dV = cutBounds[3] - cutBounds[1];
                texCoord = new UVCoords(cutBounds[0] + dU * texCoord.u(), cutBounds[1] + dV * texCoord.v());
            }
            if (texCoord != vertex.uv()) {
                newPoints.add(new Vertex(vertex.position(), vertex.position(), texCoord));
                continue;
            }
            newPoints.add(vertex);
        }
        return new Polygon<MaterialLibrary.OBJMaterial>(newPoints, face.getTexture());
    }
}

