/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.IEEntityBlock;
import blusunrize.immersiveengineering.common.blocks.metal.FloodlightBlockEntity;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.SpawnInterdictionHandler;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FakeLightBlock
extends IEEntityBlock<FakeLightBlockEntity> {
    public static final Supplier<BlockBehaviour.Properties> PROPERTIES = () -> BlockBehaviour.Properties.m_284310_().m_280170_().m_60996_().m_60955_().m_278166_(PushReaction.DESTROY).m_60953_(b -> 15);

    public FakeLightBlock(BlockBehaviour.Properties props) {
        super(IEBlockEntities.FAKE_LIGHT, props);
    }

    public boolean isAir(BlockState state) {
        return true;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    @Override
    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return true;
    }

    public static class FakeLightBlockEntity
    extends IEBaseBlockEntity
    implements IEServerTickableBE,
    IEBlockInterfaces.ISpawnInterdiction {
        public BlockPos floodlightCoords = null;

        public FakeLightBlockEntity(BlockPos pos, BlockState state) {
            super((BlockEntityType)IEBlockEntities.FAKE_LIGHT.get(), pos, state);
        }

        @Override
        public void tickServer() {
            BlockEntity tile;
            if (this.floodlightCoords == null) {
                this.f_58857_.m_7471_(this.m_58899_(), false);
                return;
            }
            if (!(this.f_58857_.m_46467_() % 256L != (long)((this.m_58899_().m_123341_() ^ this.m_58899_().m_123343_()) & 0xFF) || (tile = Utils.getExistingTileEntity(this.f_58857_, this.floodlightCoords)) instanceof FloodlightBlockEntity && ((FloodlightBlockEntity)tile).getIsActive())) {
                this.f_58857_.m_7471_(this.m_58899_(), false);
            }
        }

        @Override
        public double getInterdictionRangeSquared() {
            return 1024.0;
        }

        @Override
        public void setRemovedIE() {
            SpawnInterdictionHandler.removeFromInterdictionTiles(this);
            super.setRemovedIE();
        }

        @Override
        public void onChunkUnloaded() {
            SpawnInterdictionHandler.removeFromInterdictionTiles(this);
            super.onChunkUnloaded();
        }

        @Override
        public void onLoad() {
            super.onLoad();
            SpawnInterdictionHandler.addInterdictionTile(this);
        }

        @Override
        public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
            this.floodlightCoords = nbt.m_128425_("floodlightCoords", 10) ? NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("floodlightCoords")) : null;
        }

        @Override
        public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
            if (this.floodlightCoords != null) {
                nbt.m_128365_("floodlightCoords", (Tag)NbtUtils.m_129224_((BlockPos)this.floodlightCoords));
            }
        }
    }
}

