/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.network.IMessage;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageBlockEntitySync
implements IMessage {
    private final BlockPos pos;
    private final CompoundTag nbt;

    public MessageBlockEntitySync(IEBaseBlockEntity tile, CompoundTag nbt) {
        this.pos = tile.m_58899_();
        this.nbt = nbt;
    }

    public MessageBlockEntitySync(FriendlyByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.nbt = buf.m_130260_();
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.pos.m_123341_()).writeInt(this.pos.m_123342_()).writeInt(this.pos.m_123343_());
        buf.m_130079_(this.nbt);
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        if (ctx.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            ctx.enqueueWork(() -> {
                BlockEntity tile;
                ServerLevel world = Objects.requireNonNull(ctx.getSender()).m_284548_();
                if (world.isAreaLoaded(this.pos, 1) && (tile = world.m_7702_(this.pos)) instanceof IEBaseBlockEntity) {
                    ((IEBaseBlockEntity)tile).receiveMessageFromClient(this.nbt);
                }
            });
        } else {
            ctx.enqueueWork(() -> {
                BlockEntity tile;
                Level world = ImmersiveEngineering.proxy.getClientWorld();
                if (world != null && (tile = world.m_7702_(this.pos)) instanceof IEBaseBlockEntity) {
                    ((IEBaseBlockEntity)tile).receiveMessageFromServer(this.nbt);
                }
            });
        }
    }
}

