/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker.managers;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CrTIngredientUtil;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.actions.AbstractActionGenericRemoveRecipe;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.actions.ActionAddRecipeCustomOutput;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.tag.MCTag;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="mods/immersiveengineering/Mixer")
@ZenCodeType.Name(value="mods.immersiveengineering.Mixer")
public class MixerRecipeManager
implements IRecipeManager<MixerRecipe> {
    public RecipeType<MixerRecipe> getRecipeType() {
        return IERecipeTypes.MIXER.get();
    }

    public void remove(IIngredient output) {
        throw new UnsupportedOperationException("Cannot remove a Mixer recipe by Item output because Mixer Recipes have no Item output!");
    }

    @ZenCodeType.Method
    public void removeRecipe(final IFluidStack fluidStack) {
        CraftTweakerAPI.apply((IAction)new AbstractActionGenericRemoveRecipe<MixerRecipe>((IRecipeManager)this, (CommandStringDisplayable)fluidStack){

            @Override
            public boolean shouldRemove(MixerRecipe recipe) {
                return recipe.fluidOutput.isFluidStackIdentical((FluidStack)fluidStack.getInternal());
            }
        });
    }

    @ZenCodeType.Method
    public void removeRecipe(final Fluid fluid) {
        CraftTweakerAPI.apply((IAction)new AbstractActionGenericRemoveRecipe<MixerRecipe>((IRecipeManager)this, fluid){

            @Override
            public boolean shouldRemove(MixerRecipe recipe) {
                return fluid.m_6212_(recipe.fluidOutput.getFluid());
            }
        });
    }

    @ZenCodeType.Method
    public void addRecipe(String recipePath, MCTag fluidInput, IIngredientWithAmount[] inputItems, int energy, Fluid output, int amount) {
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", recipePath);
        FluidTagInput fluidTagInput = CrTIngredientUtil.getFluidTagInput(fluidInput, amount);
        IngredientWithSize[] ingredientsWithSize = CrTIngredientUtil.getIngredientsWithSize(inputItems);
        FluidStack outputFluidStack = new FluidStack(output, amount);
        MixerRecipe recipe = IEServerConfig.MACHINES.mixerConfig.apply(new MixerRecipe(resourceLocation, outputFluidStack, fluidTagInput, ingredientsWithSize, energy));
        CraftTweakerAPI.apply(new ActionAddRecipeCustomOutput<MixerRecipe>(this, recipe, outputFluidStack));
    }
}

