/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.minimap.components;

import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.api.client.minimap.MinimapContext;
import dev.ftb.mods.ftbchunks.api.client.minimap.MinimapInfoComponent;
import dev.ftb.mods.ftbchunks.api.client.minimap.TranslatedOption;
import dev.ftb.mods.ftbchunks.client.map.MapRegionData;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftbteams.api.Team;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ZoneInfoComponent
implements MinimapInfoComponent {
    public static final ResourceLocation ID = FTBChunksAPI.rl("zone");
    public static final Component WILDNESS = Component.m_237115_((String)"wilderness").m_130938_(s -> s.m_131140_(ChatFormatting.DARK_GREEN).m_131155_(Boolean.valueOf(true)));
    private Team team;

    @Override
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void render(MinimapContext context, GuiGraphics graphics, Font font) {
        String setting = context.getSetting(this);
        if (this.team != null) {
            this.drawCenteredText(context.minecraft().f_91062_, graphics, this.team.getColoredName(), 0);
        } else if (setting.equals(ShowWilderness.SHOW_WILDERNESS.name())) {
            this.drawCenteredText(context.minecraft().f_91062_, graphics, WILDNESS, 0);
        }
    }

    @Override
    public boolean shouldRender(MinimapContext context) {
        Optional<Team> foundTeam;
        MapRegionData data = context.mapDimension().getRegion(XZ.regionFromChunk((int)context.mapChunksPos().x(), (int)context.mapChunksPos().z())).getData();
        this.team = null;
        if (data != null && (foundTeam = data.getChunk(XZ.of((int)context.mapChunksPos().x(), (int)context.mapChunksPos().z())).getTeam()).isPresent()) {
            this.team = foundTeam.get();
            return true;
        }
        String setting = context.getSetting(this);
        return !setting.isEmpty() && !setting.equals(ShowWilderness.JUST_CLAIMED.name());
    }

    @Override
    public Set<TranslatedOption> getConfigComponents() {
        return Arrays.stream(ShowWilderness.values()).map(value -> new TranslatedOption(value.name(), "ftbchunks.show_wilderness." + ShowWilderness.NAME_MAP.getName((Object)value))).collect(Collectors.toSet());
    }

    public static enum ShowWilderness {
        JUST_CLAIMED,
        SHOW_WILDERNESS;

        public static final NameMap<ShowWilderness> NAME_MAP;

        static {
            NAME_MAP = NameMap.of((Object)((Object)SHOW_WILDERNESS), (Object[])ShowWilderness.values()).baseNameKey("ftbchunks.show_wilderness").create();
        }
    }
}

