/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.clipboard;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.equipment.clipboard.ClipboardCloneable;
import com.simibubi.create.content.equipment.clipboard.ClipboardOverrides;
import com.simibubi.create.content.trains.track.TrackBlockOutline;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ClipboardValueSettingsHandler {
    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void drawCustomBlockSelection(RenderHighlightEvent.Block event) {
        Minecraft mc = Minecraft.m_91087_();
        BlockHitResult target = event.getTarget();
        BlockPos pos = target.m_82425_();
        BlockState blockstate = mc.f_91073_.m_8055_(pos);
        if (mc.f_91074_ == null || mc.f_91074_.m_5833_()) {
            return;
        }
        if (!mc.f_91073_.m_6857_().m_61937_(pos)) {
            return;
        }
        if (!AllBlocks.CLIPBOARD.isIn(mc.f_91074_.m_21205_())) {
            return;
        }
        BlockEntity blockEntity = mc.f_91073_.m_7702_(pos);
        if (!(blockEntity instanceof SmartBlockEntity)) {
            return;
        }
        SmartBlockEntity smartBE = (SmartBlockEntity)blockEntity;
        if (!smartBE.getAllBehaviours().stream().anyMatch(b -> {
            ClipboardCloneable cc;
            return b instanceof ClipboardCloneable && (cc = (ClipboardCloneable)((Object)b)).writeToClipboard(new CompoundTag(), target.m_82434_());
        }) && !(smartBE instanceof ClipboardCloneable)) {
            return;
        }
        VoxelShape shape = blockstate.m_60808_((BlockGetter)mc.f_91073_, pos);
        if (shape.m_83281_()) {
            return;
        }
        VertexConsumer vb = event.getMultiBufferSource().m_6299_(RenderType.m_110504_());
        Vec3 camPos = event.getCamera().m_90583_();
        PoseStack ms = event.getPoseStack();
        ms.m_85836_();
        ms.m_85837_((double)pos.m_123341_() - camPos.f_82479_, (double)pos.m_123342_() - camPos.f_82480_, (double)pos.m_123343_() - camPos.f_82481_);
        TrackBlockOutline.renderShape(shape, ms, vb, true);
        event.setCanceled(true);
        ms.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientTick() {
        ClipboardCloneable ccbe;
        boolean canPaste;
        ClipboardCloneable ccbe2;
        Minecraft mc = Minecraft.m_91087_();
        HitResult hitResult = mc.f_91077_;
        if (!(hitResult instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult target = (BlockHitResult)hitResult;
        if (!AllBlocks.CLIPBOARD.isIn(mc.f_91074_.m_21205_())) {
            return;
        }
        BlockPos pos = target.m_82425_();
        BlockEntity blockEntity = mc.f_91073_.m_7702_(pos);
        if (!(blockEntity instanceof SmartBlockEntity)) {
            return;
        }
        SmartBlockEntity smartBE = (SmartBlockEntity)blockEntity;
        CompoundTag tagElement = mc.f_91074_.m_21205_().m_41737_("CopiedValues");
        boolean canCopy = smartBE.getAllBehaviours().stream().anyMatch(b -> {
            ClipboardCloneable cc;
            return b instanceof ClipboardCloneable && (cc = (ClipboardCloneable)((Object)b)).writeToClipboard(new CompoundTag(), target.m_82434_());
        }) || smartBE instanceof ClipboardCloneable && (ccbe2 = (ClipboardCloneable)((Object)smartBE)).writeToClipboard(new CompoundTag(), target.m_82434_());
        boolean bl = canPaste = tagElement != null && (smartBE.getAllBehaviours().stream().anyMatch(b -> {
            ClipboardCloneable cc;
            return b instanceof ClipboardCloneable && (cc = (ClipboardCloneable)((Object)b)).readFromClipboard(tagElement.m_128469_(cc.getClipboardKey()), (Player)mc.f_91074_, target.m_82434_(), true);
        }) || smartBE instanceof ClipboardCloneable && (ccbe = (ClipboardCloneable)((Object)smartBE)).readFromClipboard(tagElement.m_128469_(ccbe.getClipboardKey()), (Player)mc.f_91074_, target.m_82434_(), true));
        if (!canCopy && !canPaste) {
            return;
        }
        ArrayList<MutableComponent> tip = new ArrayList<MutableComponent>();
        tip.add(Lang.translateDirect("clipboard.actions", new Object[0]));
        if (canCopy) {
            tip.add(Lang.translateDirect("clipboard.to_copy", Components.keybind("key.use")));
        }
        if (canPaste) {
            tip.add(Lang.translateDirect("clipboard.to_paste", Components.keybind("key.attack")));
        }
        CreateClient.VALUE_SETTINGS_HANDLER.showHoverTip(tip);
    }

    @SubscribeEvent
    public static void rightClickToCopy(PlayerInteractEvent.RightClickBlock event) {
        ClipboardValueSettingsHandler.interact((PlayerInteractEvent)event, false);
    }

    @SubscribeEvent
    public static void leftClickToPaste(PlayerInteractEvent.LeftClickBlock event) {
        ClipboardValueSettingsHandler.interact((PlayerInteractEvent)event, true);
    }

    private static void interact(PlayerInteractEvent event, boolean paste) {
        ItemStack itemStack = event.getItemStack();
        if (!AllBlocks.CLIPBOARD.isIn(itemStack)) {
            return;
        }
        BlockPos pos = event.getPos();
        Level world = event.getLevel();
        Player player = event.getEntity();
        if (player != null && player.m_5833_()) {
            return;
        }
        if (player.m_6144_()) {
            return;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof SmartBlockEntity)) {
            return;
        }
        SmartBlockEntity smartBE = (SmartBlockEntity)blockEntity;
        CompoundTag tag = itemStack.m_41737_("CopiedValues");
        if (paste && tag == null) {
            return;
        }
        if (!paste) {
            tag = new CompoundTag();
        }
        boolean anySuccess = false;
        boolean anyValid = false;
        for (BlockEntityBehaviour behaviour : smartBE.getAllBehaviours()) {
            if (!(behaviour instanceof ClipboardCloneable)) continue;
            ClipboardCloneable cc = (ClipboardCloneable)((Object)behaviour);
            anyValid = true;
            String clipboardKey = cc.getClipboardKey();
            if (paste) {
                anySuccess |= cc.readFromClipboard(tag.m_128469_(clipboardKey), player, event.getFace(), world.m_5776_());
                continue;
            }
            CompoundTag compoundTag = new CompoundTag();
            boolean success = cc.writeToClipboard(compoundTag, event.getFace());
            anySuccess |= success;
            if (!success) continue;
            tag.m_128365_(clipboardKey, (Tag)compoundTag);
        }
        if (smartBE instanceof ClipboardCloneable) {
            ClipboardCloneable ccbe = (ClipboardCloneable)((Object)smartBE);
            anyValid = true;
            String clipboardKey = ccbe.getClipboardKey();
            if (paste) {
                anySuccess |= ccbe.readFromClipboard(tag.m_128469_(clipboardKey), player, event.getFace(), world.m_5776_());
            } else {
                CompoundTag compoundTag = new CompoundTag();
                boolean success = ccbe.writeToClipboard(compoundTag, event.getFace());
                anySuccess |= success;
                if (success) {
                    tag.m_128365_(clipboardKey, (Tag)compoundTag);
                }
            }
        }
        if (!anyValid) {
            return;
        }
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.SUCCESS);
        if (world.m_5776_()) {
            return;
        }
        if (!anySuccess) {
            return;
        }
        player.m_5661_((Component)Lang.translate(paste ? "clipboard.pasted_to" : "clipboard.copied_from", world.m_8055_(pos).m_60734_().m_49954_().m_130940_(ChatFormatting.WHITE)).style(ChatFormatting.GREEN).component(), true);
        if (!paste) {
            ClipboardOverrides.switchTo(ClipboardOverrides.ClipboardType.WRITTEN, itemStack);
            itemStack.m_41784_().m_128365_("CopiedValues", (Tag)tag);
        }
    }
}

