/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.graph;

import com.simibubi.create.Create;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackGraphLocation;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.foundation.utility.Couple;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TrackGraphHelper {
    @Nullable
    public static TrackGraphLocation getGraphLocationAt(Level level, BlockPos pos, Direction.AxisDirection targetDirection, Vec3 targetAxis) {
        TrackNode node;
        BlockState trackBlockState = level.m_8055_(pos);
        Block block = trackBlockState.m_60734_();
        if (!(block instanceof ITrackBlock)) {
            return null;
        }
        ITrackBlock track = (ITrackBlock)block;
        Vec3 axis = targetAxis.m_82490_((double)targetDirection.m_122540_());
        double length = axis.m_82553_();
        TrackGraph graph = null;
        TrackNodeLocation location = new TrackNodeLocation(Vec3.m_82539_((Vec3i)pos).m_82520_(0.0, track.getElevationAtCenter((BlockGetter)level, pos, trackBlockState), 0.0)).in(level);
        graph = Create.RAILWAYS.sided((LevelAccessor)level).getGraph((LevelAccessor)level, location);
        if (graph != null && (node = graph.locateNode(location)) != null) {
            Map<TrackNode, TrackEdge> connectionsFrom = graph.getConnectionsFrom(node);
            for (Map.Entry<TrackNode, TrackEdge> entry : connectionsFrom.entrySet()) {
                TrackNode backNode = entry.getKey();
                Vec3 direction = entry.getValue().getDirection(true);
                if (direction.m_82490_(length).m_82557_(axis.m_82490_(-1.0)) > 2.44140625E-4) continue;
                TrackGraphLocation graphLocation = new TrackGraphLocation();
                graphLocation.edge = Couple.create(node.getLocation(), backNode.getLocation());
                graphLocation.position = 0.0;
                graphLocation.graph = graph;
                return graphLocation;
            }
        }
        Collection<TrackNodeLocation.DiscoveredLocation> ends = track.getConnected((BlockGetter)level, pos, trackBlockState, true, null);
        Vec3 start = Vec3.m_82539_((Vec3i)pos).m_82520_(0.0, track.getElevationAtCenter((BlockGetter)level, pos, trackBlockState), 0.0);
        TrackNode frontNode = null;
        TrackNode backNode = null;
        double position = 0.0;
        boolean singleTrackPiece = true;
        block1: for (TrackNodeLocation.DiscoveredLocation current : ends) {
            boolean backwards;
            Vec3 offset = current.getLocation().m_82546_(start).m_82541_().m_82490_(length);
            Vec3 compareOffset = offset.m_82542_(1.0, 0.0, 1.0).m_82541_();
            boolean forward = compareOffset.m_82557_(axis.m_82542_(-1.0, 0.0, -1.0).m_82541_()) < 2.44140625E-4;
            boolean bl = backwards = compareOffset.m_82557_(axis.m_82542_(1.0, 0.0, 1.0).m_82541_()) < 2.44140625E-4;
            if (!forward && !backwards) continue;
            TrackNodeLocation.DiscoveredLocation previous = null;
            double distance = 0.0;
            block2: for (int i = 0; i < 100 && distance < 32.0; ++i) {
                TrackNodeLocation.DiscoveredLocation loc = current;
                if (graph == null) {
                    graph = Create.RAILWAYS.sided((LevelAccessor)level).getGraph((LevelAccessor)level, loc);
                }
                if (graph == null || graph.locateNode(loc) == null) {
                    singleTrackPiece = false;
                    Collection<TrackNodeLocation.DiscoveredLocation> list = ITrackBlock.walkConnectedTracks((BlockGetter)level, loc, true);
                    for (TrackNodeLocation.DiscoveredLocation discoveredLocation : list) {
                        if (discoveredLocation == previous) continue;
                        Vec3 diff = discoveredLocation.getLocation().m_82546_(loc.getLocation());
                        if ((forward ? axis.m_82490_(-1.0) : axis).m_82557_(diff.m_82541_().m_82490_(length)) > 2.44140625E-4) continue;
                        previous = current;
                        current = discoveredLocation;
                        distance += diff.m_82553_();
                        continue block2;
                    }
                    continue;
                }
                TrackNode node2 = graph.locateNode(loc);
                if (forward) {
                    frontNode = node2;
                }
                if (!backwards) continue block1;
                backNode = node2;
                position = distance + axis.m_82553_() / 2.0;
                continue block1;
            }
        }
        if (frontNode == null || backNode == null) {
            return null;
        }
        if (singleTrackPiece) {
            position = frontNode.getLocation().getLocation().m_82554_(backNode.getLocation().getLocation()) / 2.0;
        }
        TrackGraphLocation graphLocation = new TrackGraphLocation();
        graphLocation.edge = Couple.create(backNode.getLocation(), frontNode.getLocation());
        graphLocation.position = position;
        graphLocation.graph = graph;
        return graphLocation;
    }

    @Nullable
    public static TrackGraphLocation getBezierGraphLocationAt(Level level, BlockPos pos, Direction.AxisDirection targetDirection, BezierTrackPointLocation targetBezier) {
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (!(block instanceof ITrackBlock)) {
            return null;
        }
        ITrackBlock track = (ITrackBlock)block;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof TrackBlockEntity)) {
            return null;
        }
        TrackBlockEntity trackBE = (TrackBlockEntity)blockEntity;
        BezierConnection bc = trackBE.getConnections().get(targetBezier.curveTarget());
        if (bc == null || !bc.isPrimary()) {
            return null;
        }
        TrackNodeLocation targetLoc = new TrackNodeLocation((Vec3)bc.starts.getSecond()).in(level);
        if (bc.smoothing != null) {
            targetLoc.yOffsetPixels = (Integer)bc.smoothing.getSecond();
        }
        for (TrackNodeLocation.DiscoveredLocation location : track.getConnected((BlockGetter)level, pos, state, true, null)) {
            TrackNode node;
            TrackEdge edge;
            TrackNode targetNode;
            TrackGraph graph = Create.RAILWAYS.sided((LevelAccessor)level).getGraph((LevelAccessor)level, location);
            if (graph == null || (targetNode = graph.locateNode(targetLoc)) == null || (edge = graph.getConnectionsFrom(node = graph.locateNode(location)).get(targetNode)) == null) continue;
            TrackGraphLocation graphLocation = new TrackGraphLocation();
            graphLocation.graph = graph;
            graphLocation.edge = Couple.create(location, targetLoc);
            graphLocation.position = (float)(targetBezier.segment() + 1) / 2.0f;
            if (targetDirection == Direction.AxisDirection.POSITIVE) {
                graphLocation.edge = graphLocation.edge.swap();
                graphLocation.position = edge.getLength() - graphLocation.position;
            }
            return graphLocation;
        }
        return null;
    }
}

