/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.traffic_light;

import com.drmangotea.tfmg.blocks.electricity.base.ElectricBlockEntity;
import com.drmangotea.tfmg.blocks.electricity.traffic_light.TimerScrollBehaviour;
import com.drmangotea.tfmg.blocks.electricity.traffic_light.TrafficLightScrollSlot;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TrafficLightBlockEntity
extends ElectricBlockEntity {
    protected ScrollValueBehaviour timerLength;
    public LerpedFloat glow = LerpedFloat.linear();
    int light = 0;
    public int timer = 180;

    public TrafficLightBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.timerLength = new TimerScrollBehaviour((Component)Lang.translateDirect((String)"traffic_light.timer", (Object[])new Object[0]), this, new TrafficLightScrollSlot()).between(180, 72000);
        this.timerLength.withFormatter(this::format);
        this.timerLength.withCallback(value -> {
            this.timer = value;
        });
        this.timerLength.setValue(2);
        behaviours.add((BlockEntityBehaviour)this.timerLength);
    }

    private String format(int value) {
        if (value < 60) {
            return value + "t";
        }
        if (value < 1200) {
            return value / 20 + "s";
        }
        return value / 20 / 60 + "m";
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return true;
    }

    @Override
    public int FECapacity() {
        return 1500;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.useEnergy(20);
        this.getOrCreateElectricNetwork().requestEnergy(this);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.f_58857_.f_46443_) {
            return;
        }
        if (this.timer > 0) {
            --this.timer;
        }
        this.glow.chase(200.0, 0.4, LerpedFloat.Chaser.EXP);
        int halfTimer = this.timerLength.getValue() / 2;
        if (this.timer < halfTimer - 30 && this.timer > 60) {
            this.light = 0;
            Create.LOGGER.debug("green");
        } else if (this.timer > halfTimer + 30) {
            Create.LOGGER.debug("red");
            this.light = 2;
        } else {
            this.light = 1;
            Create.LOGGER.debug("orang(e)");
        }
        if (this.timer == 0) {
            this.glow.setValue(0.0);
            this.timer = this.timerLength.getValue();
        }
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.timer = compound.m_128451_("Timer");
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("Timer", this.timer);
    }
}

