/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter;

import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createenchantmentindustry.EnchantmentIndustry;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.EnchantingGuideItem;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.EnchantmentEntry;
import plus.dragons.createenchantmentindustry.entry.CeiItems;

public class Enchanting {
    public static final TagKey<Item> UNENCHANTABLE = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)EnchantmentIndustry.genRL("unenchantable"));
    public static final List<Predicate<ItemStack>> UNENCHANTABLE_CONDITIONS = new ArrayList<Predicate<ItemStack>>();

    @Nullable
    public static EnchantmentEntry getTargetEnchantment(ItemStack itemStack, boolean hyper) {
        if (itemStack.m_150930_((Item)CeiItems.ENCHANTING_GUIDE.get())) {
            EnchantmentEntry result = EnchantingGuideItem.getEnchantment(itemStack);
            if (!hyper || result == null) {
                return result;
            }
            Enchantment enchantment = (Enchantment)result.getFirst();
            int level = (Integer)result.getSecond() + 1;
            return EnchantmentEntry.of(enchantment, level);
        }
        throw new RuntimeException("TargetItem is not an enchanting guide for blaze!");
    }

    @Nullable
    public static EnchantmentEntry getValidEnchantment(ItemStack itemStack, ItemStack targetItem, boolean hyper) {
        if (itemStack.m_204117_(UNENCHANTABLE)) {
            return null;
        }
        if (!UNENCHANTABLE_CONDITIONS.isEmpty() && UNENCHANTABLE_CONDITIONS.stream().map(itemStackPredicate -> itemStackPredicate.test(itemStack)).reduce((b1, b2) -> b1 != false || b2 != false).get().booleanValue()) {
            return null;
        }
        EnchantmentEntry entry = Enchanting.getTargetEnchantment(targetItem, hyper);
        if (entry == null || !entry.valid()) {
            return null;
        }
        Enchantment enchantment = (Enchantment)entry.getFirst();
        ItemStack toCheck = itemStack.m_41777_();
        Map modified = EnchantmentHelper.m_44831_((ItemStack)toCheck);
        if (modified.containsKey(enchantment) && (Integer)modified.get(enchantment) >= (Integer)entry.getSecond()) {
            return null;
        }
        modified.remove(enchantment);
        EnchantmentHelper.m_44865_((Map)modified, (ItemStack)toCheck);
        if (!enchantment.m_6081_(toCheck)) {
            return null;
        }
        for (Map.Entry e : modified.entrySet()) {
            if (((Enchantment)e.getKey()).m_44695_(enchantment)) continue;
            return null;
        }
        return entry;
    }

    public static void enchantItem(ItemStack itemStack, Pair<Enchantment, Integer> enchantment) {
        Map map = EnchantmentHelper.m_44831_((ItemStack)itemStack);
        map.put((Enchantment)enchantment.getFirst(), (Integer)enchantment.getSecond());
        EnchantmentHelper.m_44865_((Map)map, (ItemStack)itemStack);
    }

    public static int expPointFromLevel(int level) {
        if (level > 31) {
            return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
        }
        return level > 16 ? (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0) : level * level + 6 * level;
    }

    public static int expPointForNextLevel(int level) {
        if (level > 30) {
            return 9 * level - 158;
        }
        return level > 15 ? 5 * level - 38 : 2 * level + 7;
    }

    public static int rarityLevel(Enchantment.Rarity rarity) {
        return switch (rarity) {
            default -> throw new IncompatibleClassChangeError();
            case Enchantment.Rarity.COMMON -> 1;
            case Enchantment.Rarity.UNCOMMON -> 2;
            case Enchantment.Rarity.RARE -> 3;
            case Enchantment.Rarity.VERY_RARE -> 4;
        };
    }

    public static int getExperienceConsumption(Enchantment enchantment, int level) {
        int xpLevel = enchantment.m_6183_(level) + level * Enchanting.rarityLevel(enchantment.m_44699_());
        return Enchanting.expPointForNextLevel(xpLevel);
    }
}

