/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.contraptions.phys.bearing;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.IDisplayAssemblyExceptions;
import com.simibubi.create.content.contraptions.bearing.BearingBlock;
import com.simibubi.create.content.contraptions.bearing.IBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4d;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.ClockworkSounds;
import org.valkyrienskies.clockwork.content.contraptions.phys.bearing.data.PhysBearingCreateData;
import org.valkyrienskies.clockwork.content.contraptions.phys.bearing.data.PhysBearingData;
import org.valkyrienskies.clockwork.content.contraptions.phys.bearing.data.PhysBearingUpdateData;
import org.valkyrienskies.clockwork.content.forces.contraption.BearingController;
import org.valkyrienskies.clockwork.platform.api.ContraptionController;
import org.valkyrienskies.clockwork.util.ClockworkConstants;
import org.valkyrienskies.clockwork.util.GlueAssembler;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.apigame.constraints.VSAttachmentConstraint;
import org.valkyrienskies.core.apigame.constraints.VSConstraint;
import org.valkyrienskies.core.apigame.constraints.VSConstraintAndId;
import org.valkyrienskies.core.apigame.constraints.VSHingeOrientationConstraint;
import org.valkyrienskies.core.impl.game.ships.ShipDataCommon;
import org.valkyrienskies.core.impl.game.ships.ShipTransformImpl;
import org.valkyrienskies.core.util.datastructures.DenseBlockPosSet;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.assembly.ShipAssemblyKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u0090\u00012\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0002\u0090\u0001B0\u0012\u000e\u0010\u008a\u0001\u001a\t\u0012\u0002\b\u0003\u0018\u00010\u0089\u0001\u0012\t\u0010\u008b\u0001\u001a\u0004\u0018\u00010\u001e\u0012\n\u0010\u008d\u0001\u001a\u0005\u0018\u00010\u008c\u0001\u00a2\u0006\u0006\b\u008e\u0001\u0010\u008f\u0001J\u001d\u0010\t\u001a\u00020\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\u0010\u001a\u00020\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u0017\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u0013J\r\u0010\u001a\u001a\u00020\b\u00a2\u0006\u0004\b\u001a\u0010\u0013J\r\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\"\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\"\u0010#J\u0015\u0010$\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u001b\u00a2\u0006\u0004\b$\u0010#J\u0011\u0010&\u001a\u0004\u0018\u00010%H\u0016\u00a2\u0006\u0004\b&\u0010'J\r\u0010(\u001a\u00020\u001b\u00a2\u0006\u0004\b(\u0010\u001dJ\r\u0010)\u001a\u00020\u001b\u00a2\u0006\u0004\b)\u0010\u001dJ\u0017\u0010+\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020*H\u0016\u00a2\u0006\u0004\b+\u0010,J\u000f\u0010-\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b-\u0010.J\u000f\u0010/\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b/\u0010.J\u000f\u00100\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b0\u0010\u0013J\u0017\u00102\u001a\u00020\b2\u0006\u00101\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b2\u00103J\u000f\u00104\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b4\u0010\u0013J\u001f\u00108\u001a\u00020\b2\u0006\u00106\u001a\u0002052\u0006\u00107\u001a\u00020\u000eH\u0014\u00a2\u0006\u0004\b8\u00109J\u000f\u0010:\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b:\u0010\u0013J\u0017\u0010<\u001a\u00020\b2\u0006\u0010;\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b<\u00103J\u000f\u0010=\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b=\u0010\u0013J\u000f\u0010>\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b>\u0010\u0013J\u001f\u0010?\u001a\u00020\b2\u0006\u00106\u001a\u0002052\u0006\u00107\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b?\u00109R\u0011\u0010A\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010\u001dR\"\u0010B\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bB\u0010C\u001a\u0004\bD\u0010.\"\u0004\bE\u0010FR\"\u0010G\u001a\u00020\u001b8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\bG\u0010H\u001a\u0004\bI\u0010\u001d\"\u0004\bJ\u00103R\u0018\u0010L\u001a\u0004\u0018\u00010K8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bL\u0010MR\"\u0010N\u001a\u00020\u001b8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\bN\u0010H\u001a\u0004\bO\u0010\u001d\"\u0004\bP\u00103R\u0014\u0010Q\u001a\u00020\u001b8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\bQ\u0010HR\"\u0010R\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bR\u0010C\u001a\u0004\bS\u0010.\"\u0004\bT\u0010FR\u0016\u0010X\u001a\u0004\u0018\u00010U8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bV\u0010WR\"\u0010Y\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bY\u0010H\u001a\u0004\bZ\u0010\u001d\"\u0004\b[\u00103R\u0016\u0010\\\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\\\u0010CR\"\u0010]\u001a\u00020\u000e8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b]\u0010C\u001a\u0004\b^\u0010.\"\u0004\b_\u0010FR\u0016\u0010`\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b`\u0010HR\u0011\u0010a\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\ba\u0010.R*\u0010c\u001a\u00020\u000e2\u0006\u0010b\u001a\u00020\u000e8\u0006@DX\u0086\u000e\u00a2\u0006\u0012\n\u0004\bc\u0010C\u001a\u0004\bc\u0010.\"\u0004\bd\u0010FR\u0014\u0010e\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\be\u0010.R\u0014\u0010f\u001a\u00020\u000e8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bf\u0010.R$\u0010g\u001a\u0004\u0018\u00010%8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\bg\u0010h\u001a\u0004\bi\u0010'\"\u0004\bj\u0010kR*\u0010n\u001a\n\u0012\u0004\u0012\u00020m\u0018\u00010l8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bn\u0010o\u001a\u0004\bp\u0010q\"\u0004\br\u0010sR\"\u0010t\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bt\u0010C\u001a\u0004\bu\u0010.\"\u0004\bv\u0010FR\u0016\u0010w\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bw\u0010HR\u0016\u0010x\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bx\u0010HR\"\u0010y\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\by\u0010C\u001a\u0004\bz\u0010.\"\u0004\b{\u0010FR\u0016\u0010|\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b|\u0010HR\"\u0010}\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b}\u0010H\u001a\u0004\b~\u0010\u001d\"\u0004\b\u007f\u00103R\u001a\u0010\u0081\u0001\u001a\u00030\u0080\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0081\u0001\u0010\u0082\u0001R&\u0010\u0083\u0001\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u0083\u0001\u0010C\u001a\u0005\b\u0084\u0001\u0010.\"\u0005\b\u0085\u0001\u0010FR&\u0010\u0086\u0001\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u0086\u0001\u0010H\u001a\u0005\b\u0087\u0001\u0010\u001d\"\u0005\b\u0088\u0001\u00103\u00a8\u0006\u0091\u0001"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/PhysBearingBlockEntity;", "Lcom/simibubi/create/content/kinetics/base/GeneratingKineticBlockEntity;", "Lcom/simibubi/create/content/contraptions/bearing/IBearingBlockEntity;", "Lcom/simibubi/create/content/contraptions/IDisplayAssemblyExceptions;", "Lorg/valkyrienskies/clockwork/platform/api/ContraptionController;", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "", "addBehaviours", "(Ljava/util/List;)V", "", "Lnet/minecraft/network/chat/Component;", "tooltip", "", "isPlayerSneaking", "addToTooltip", "(Ljava/util/List;Z)Z", "applyRotation", "()V", "assemble", "Lcom/simibubi/create/content/contraptions/ControlledContraptionEntity;", "contraption", "attach", "(Lcom/simibubi/create/content/contraptions/ControlledContraptionEntity;)V", "destroy", "disassemble", "", "getAngle", "()F", "Lnet/minecraft/core/BlockPos;", "getBlockPosition", "()Lnet/minecraft/core/BlockPos;", "partialTicks", "getInterpolatedAngle", "(F)F", "getInterpolatedCoreAngle", "Lcom/simibubi/create/content/contraptions/AssemblyException;", "getLastAssemblyException", "()Lcom/simibubi/create/content/contraptions/AssemblyException;", "getOpeningProgress", "getWingRotOffset", "Lcom/simibubi/create/content/contraptions/AbstractContraptionEntity;", "isAttachedTo", "(Lcom/simibubi/create/content/contraptions/AbstractContraptionEntity;)Z", "isValid", "()Z", "isWoodenTop", "lazyTick", "prevSpeed", "onSpeedChanged", "(F)V", "onStall", "Lnet/minecraft/nbt/CompoundTag;", "compound", "clientPacket", "read", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "remove", "forcedAngle", "setAngle", "shipDisassemble", "tick", "write", "getAngularSpeed", "angularSpeed", "assembleNextTick", "Z", "getAssembleNextTick", "setAssembleNextTick", "(Z)V", "bearingAngle", "F", "getBearingAngle", "setBearingAngle", "", "bearingID", "Ljava/lang/Integer;", "clientAngleDiff", "getClientAngleDiff", "setClientAngleDiff", "closeProgress", "closing", "getClosing", "setClosing", "Lorg/valkyrienskies/core/api/ships/Ship;", "getConnectedShip", "()Lorg/valkyrienskies/core/api/ships/Ship;", "connectedShip", "coreAngle", "getCoreAngle", "setCoreAngle", "cornerShrinking", "disassembleWhenPossible", "getDisassembleWhenPossible", "setDisassembleWhenPossible", "inOutCorner", "isNearInitialAngle", "<set-?>", "isRunning", "setRunning", "isShipContraptionController", "isWindmill", "lastException", "Lcom/simibubi/create/content/contraptions/AssemblyException;", "getLastException", "setLastException", "(Lcom/simibubi/create/content/contraptions/AssemblyException;)V", "Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/ScrollOptionBehaviour;", "Lorg/valkyrienskies/clockwork/platform/api/ContraptionController$LockedMode;", "movementMode", "Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/ScrollOptionBehaviour;", "getMovementMode", "()Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/ScrollOptionBehaviour;", "setMovementMode", "(Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/ScrollOptionBehaviour;)V", "open", "getOpen", "setOpen", "openProgress", "openProgressMax", "opening", "getOpening", "setOpening", "prevAngle", "previousCoreAngle", "getPreviousCoreAngle", "setPreviousCoreAngle", "", "shiptraptionID", "J", "shouldRefresh", "getShouldRefresh", "setShouldRefresh", "wingAngle", "getWingAngle", "setWingAngle", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Companion", "clockwork"})
public final class PhysBearingBlockEntity
extends GeneratingKineticBlockEntity
implements IBearingBlockEntity,
IDisplayAssemblyExceptions,
ContraptionController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ScrollOptionBehaviour<ContraptionController.LockedMode> movementMode;
    private boolean shouldRefresh;
    private float bearingAngle;
    private boolean isRunning;
    private boolean assembleNextTick;
    private float clientAngleDiff;
    @Nullable
    private AssemblyException lastException;
    private boolean disassembleWhenPossible;
    private float prevAngle;
    private long shiptraptionID = -1L;
    @Nullable
    private Integer bearingID;
    private float coreAngle;
    private float wingAngle;
    private float previousCoreAngle;
    private boolean opening;
    private boolean open;
    private boolean closing;
    private float openProgress;
    private float openProgressMax = 70.0f;
    private final float closeProgress;
    private float inOutCorner;
    private boolean cornerShrinking;
    public static final long NO_SHIPTRAPTION_ID = -1L;

    public PhysBearingBlockEntity(@Nullable BlockEntityType<?> type, @Nullable BlockPos pos, @Nullable BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(3);
    }

    @Nullable
    public final ScrollOptionBehaviour<ContraptionController.LockedMode> getMovementMode() {
        return this.movementMode;
    }

    public final void setMovementMode(@Nullable ScrollOptionBehaviour<ContraptionController.LockedMode> scrollOptionBehaviour) {
        this.movementMode = scrollOptionBehaviour;
    }

    public final boolean getShouldRefresh() {
        return this.shouldRefresh;
    }

    public final void setShouldRefresh(boolean bl) {
        this.shouldRefresh = bl;
    }

    protected final float getBearingAngle() {
        return this.bearingAngle;
    }

    protected final void setBearingAngle(float f) {
        this.bearingAngle = f;
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    protected final void setRunning(boolean bl) {
        this.isRunning = bl;
    }

    public final boolean getAssembleNextTick() {
        return this.assembleNextTick;
    }

    public final void setAssembleNextTick(boolean bl) {
        this.assembleNextTick = bl;
    }

    protected final float getClientAngleDiff() {
        return this.clientAngleDiff;
    }

    protected final void setClientAngleDiff(float f) {
        this.clientAngleDiff = f;
    }

    @Nullable
    protected final AssemblyException getLastException() {
        return this.lastException;
    }

    protected final void setLastException(@Nullable AssemblyException assemblyException) {
        this.lastException = assemblyException;
    }

    protected final boolean getDisassembleWhenPossible() {
        return this.disassembleWhenPossible;
    }

    protected final void setDisassembleWhenPossible(boolean bl) {
        this.disassembleWhenPossible = bl;
    }

    public final float getCoreAngle() {
        return this.coreAngle;
    }

    public final void setCoreAngle(float f) {
        this.coreAngle = f;
    }

    public final float getWingAngle() {
        return this.wingAngle;
    }

    public final void setWingAngle(float f) {
        this.wingAngle = f;
    }

    public final float getPreviousCoreAngle() {
        return this.previousCoreAngle;
    }

    public final void setPreviousCoreAngle(float f) {
        this.previousCoreAngle = f;
    }

    public final boolean getOpening() {
        return this.opening;
    }

    public final void setOpening(boolean bl) {
        this.opening = bl;
    }

    public final boolean getOpen() {
        return this.open;
    }

    public final void setOpen(boolean bl) {
        this.open = bl;
    }

    public final boolean getClosing() {
        return this.closing;
    }

    public final void setClosing(boolean bl) {
        this.closing = bl;
    }

    public boolean isWoodenTop() {
        return false;
    }

    public void addBehaviours(@NotNull List<BlockEntityBehaviour> behaviours) {
        Intrinsics.checkNotNullParameter(behaviours, (String)"behaviours");
        super.addBehaviours(behaviours);
        this.movementMode = new ScrollOptionBehaviour(ContraptionController.LockedMode.class, (Component)Component.m_237113_((String)"Locked or Unlocked"), (SmartBlockEntity)this, this.getMovementModeSlot());
        ScrollOptionBehaviour<ContraptionController.LockedMode> scrollOptionBehaviour = this.movementMode;
        Intrinsics.checkNotNull(scrollOptionBehaviour);
        scrollOptionBehaviour.requiresWrench();
        ScrollOptionBehaviour<ContraptionController.LockedMode> scrollOptionBehaviour2 = this.movementMode;
        Intrinsics.checkNotNull(scrollOptionBehaviour2);
        behaviours.add((BlockEntityBehaviour)scrollOptionBehaviour2);
    }

    public void remove() {
        super.remove();
    }

    public void write(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        compound.m_128379_(ClockworkConstants.Nbt.INSTANCE.getRUNNING(), this.isRunning);
        compound.m_128350_(ClockworkConstants.Nbt.INSTANCE.getANGLE(), this.bearingAngle);
        if (this.bearingID != null) {
            String string = ClockworkConstants.Nbt.INSTANCE.getBEARING_ID();
            Integer n = this.bearingID;
            Intrinsics.checkNotNull((Object)n);
            compound.m_128405_(string, n.intValue());
        }
        if (this.shiptraptionID != -1L) {
            compound.m_128356_(ClockworkConstants.Nbt.INSTANCE.getSHIPTRAPTION_ID(), this.shiptraptionID);
        }
        AssemblyException.write((CompoundTag)compound, (AssemblyException)this.lastException);
        compound.m_128379_(ClockworkConstants.Nbt.INSTANCE.getOPEN(), this.open);
        super.write(compound, clientPacket);
    }

    protected void read(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        if (this.wasMoved) {
            super.read(compound, clientPacket);
            return;
        }
        float angleBefore = this.bearingAngle;
        this.open = compound.m_128471_(ClockworkConstants.Nbt.INSTANCE.getOPEN());
        this.isRunning = compound.m_128471_(ClockworkConstants.Nbt.INSTANCE.getRUNNING());
        this.bearingAngle = compound.m_128457_(ClockworkConstants.Nbt.INSTANCE.getANGLE());
        this.lastException = AssemblyException.read((CompoundTag)compound);
        if (compound.m_128441_(ClockworkConstants.Nbt.INSTANCE.getBEARING_ID())) {
            this.bearingID = compound.m_128451_(ClockworkConstants.Nbt.INSTANCE.getBEARING_ID());
        }
        if (compound.m_128441_(ClockworkConstants.Nbt.INSTANCE.getSHIPTRAPTION_ID())) {
            this.shiptraptionID = compound.m_128454_(ClockworkConstants.Nbt.INSTANCE.getSHIPTRAPTION_ID());
        }
        if (this.isRunning) {
            if (this.shiptraptionID == -1L) {
                this.clientAngleDiff = AngleHelper.getShortestAngleDiff((double)angleBefore, (double)this.bearingAngle);
                this.bearingAngle = angleBefore;
            }
        } else {
            this.shiptraptionID = -1L;
        }
        this.shouldRefresh = true;
        super.read(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
    }

    public float getInterpolatedAngle(float partialTicks) {
        float partialTicks2 = partialTicks;
        if (this.isVirtual()) {
            return Mth.m_14179_((float)(partialTicks2 + 0.5f), (float)this.prevAngle, (float)this.bearingAngle);
        }
        if (this.shiptraptionID == -1L || !this.isRunning) {
            partialTicks2 = 0.0f;
        }
        return Mth.m_14179_((float)partialTicks2, (float)this.bearingAngle, (float)(this.bearingAngle + this.getAngularSpeed()));
    }

    public final float getOpeningProgress() {
        return this.openProgress;
    }

    public final float getWingRotOffset() {
        return this.open ? (float)((double)this.openProgressMax) : (this.isRunning ? (float)Mth.m_14139_((double)this.openProgress, (double)0.0, (double)this.openProgressMax) : 0.0f);
    }

    public final float getInterpolatedCoreAngle(float partialTicks) {
        this.previousCoreAngle = this.coreAngle;
        float f = this.coreAngle;
        this.coreAngle = f + 1.0f;
        if (this.coreAngle == 360.0f) {
            this.coreAngle = 0.0f;
        }
        return this.isVirtual() ? Mth.m_14179_((float)(partialTicks + 0.5f), (float)this.previousCoreAngle, (float)this.coreAngle) : Mth.m_14179_((float)partialTicks, (float)this.coreAngle, (float)(this.coreAngle + 4.0f));
    }

    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        if (this.shiptraptionID == -1L || Math.signum(prevSpeed) == Math.signum(this.getSpeed()) || !(prevSpeed == 0.0f)) {
            // empty if block
        }
    }

    public final float getAngularSpeed() {
        float speed = GeneratingKineticBlockEntity.convertToAngular((float)(this.isWindmill() ? this.getGeneratedSpeed() : this.getSpeed()));
        if (this.getSpeed() == 0.0f) {
            speed = 0.0f;
        }
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            speed *= ServerSpeedProvider.get();
            speed += this.clientAngleDiff / 3.0f;
        }
        return speed;
    }

    @Nullable
    public AssemblyException getLastAssemblyException() {
        return this.lastException;
    }

    protected final boolean isWindmill() {
        return false;
    }

    @NotNull
    public BlockPos getBlockPosition() {
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        return blockPos;
    }

    private final void assemble() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (!(level.m_8055_(this.f_58858_).m_60734_() instanceof BearingBlock)) {
            return;
        }
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)BearingBlock.FACING);
        BlockPos center = this.f_58858_.m_121945_(direction);
        DenseBlockPosSet selection = null;
        try {
            Level level2 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level2);
            Intrinsics.checkNotNull((Object)center);
            selection = GlueAssembler.INSTANCE.collectGlued(level2, center);
            this.lastException = null;
        }
        catch (AssemblyException e) {
            this.lastException = e;
            this.sendData();
            return;
        }
        if (selection == null) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)this.f_58857_;
        Intrinsics.checkNotNull((Object)serverLevel);
        ServerShip shiptraption = ShipAssemblyKt.createNewShipWithBlocks((BlockPos)center, (DenseBlockPosSet)selection, (ServerLevel)serverLevel);
        ClockworkSounds.SoundEntry soundEntry = ClockworkSounds.INSTANCE.getPHYSICS_INFUSER_LIGHTNING();
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        ClockworkSounds.SoundEntry.playOnServer$default(soundEntry, this.f_58857_, (Vec3i)blockPos, 0.0f, 0.0f, 12, null);
        this.shiptraptionID = shiptraption.getId();
        Level level3 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level3);
        if (level3.f_46443_) {
            return;
        }
        BlockPos blockPos2 = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"worldPosition");
        Vector3dc pos = (Vector3dc)VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)blockPos2));
        Vec3i vec3i = direction.m_122436_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3i, (String)"getNormal(...)");
        Vector3dc axis = (Vector3dc)VectorConversionsMCKt.toJOMLD((Vec3i)vec3i);
        BlockPos blockPos3 = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos3, (String)"worldPosition");
        Ship shipOn = (Ship)VSGameUtilsKt.getShipObjectManagingPos((Level)this.f_58857_, (Vec3i)((Vec3i)blockPos3));
        Level level4 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level4, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        Map map = VSGameUtilsKt.getShipObjectWorld((ServerLevel)((ServerLevel)level4)).getDimensionToGroundBodyIdImmutable();
        Level level5 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level5);
        Object v = map.get(VSGameUtilsKt.getDimensionId((Level)level5));
        Intrinsics.checkNotNull(v);
        long otherShipID = ((Number)v).longValue();
        if (shipOn != null) {
            otherShipID = shipOn.getId();
        }
        int veryUncoolFix = 1;
        Direction direction2 = direction;
        Quaterniond rotationQuaternion = switch (direction2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction2.ordinal()]) {
            case 1 -> new Quaterniond(new AxisAngle4d(Math.PI, (Vector3dc)new Vector3d(1.0, 0.0, 0.0)));
            case 2 -> {
                Quaterniond var14_11 = new Quaterniond(new AxisAngle4d(Math.PI, (Vector3dc)new Vector3d(0.0, 1.0, 0.0))).mul((Quaterniondc)new Quaterniond(new AxisAngle4d(1.5707963267948966, (Vector3dc)new Vector3d(1.0, 0.0, 0.0)))).normalize();
                Intrinsics.checkNotNull((Object)var14_11);
                yield var14_11;
            }
            case 3 -> {
                Quaterniond var14_11 = new Quaterniond(new AxisAngle4d(1.5707963267948966, (Vector3dc)new Vector3d(0.0, 1.0, 0.0))).mul((Quaterniondc)new Quaterniond(new AxisAngle4d(1.5707963267948966, (Vector3dc)new Vector3d(1.0, 0.0, 0.0)))).normalize();
                Intrinsics.checkNotNull((Object)var14_11);
                yield var14_11;
            }
            case 4 -> {
                Quaterniond var14_11 = new Quaterniond(new AxisAngle4d(1.5707963267948966, (Vector3dc)new Vector3d(1.0, 0.0, 0.0))).normalize();
                Intrinsics.checkNotNull((Object)var14_11);
                yield var14_11;
            }
            case 5 -> {
                veryUncoolFix = -veryUncoolFix;
                Quaterniond var14_11 = new Quaterniond(new AxisAngle4d(4.71238898038469, (Vector3dc)new Vector3d(0.0, 1.0, 0.0))).mul((Quaterniondc)new Quaterniond(new AxisAngle4d(1.5707963267948966, (Vector3dc)new Vector3d(1.0, 0.0, 0.0)))).normalize();
                Intrinsics.checkNotNull((Object)var14_11);
                yield var14_11;
            }
            default -> new Quaterniond();
        };
        BlockPos blockPos4 = this.f_58858_.m_5484_((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_), 1);
        Intrinsics.checkNotNullExpressionValue((Object)blockPos4, (String)"relative(...)");
        Vector3d vector3d = VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)blockPos4)).add(0.5, 0.5, 0.5);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"add(...)");
        Vector3dc posInOwnerShip = (Vector3dc)vector3d;
        Vector3dc posInWorld = shiptraption.getTransform().getPositionInWorld();
        Quaterniondc rotInWorld = (Quaterniondc)new Quaterniond();
        Vector3dc scaling = (Vector3dc)new Vector3d(1.0, 1.0, 1.0);
        int shipChunkX = shiptraption.getChunkClaim().getXMiddle();
        int shipChunkZ = shiptraption.getChunkClaim().getZMiddle();
        Vector3dc centerInShip = (Vector3dc)new Vector3d((double)((shipChunkX << 4) + (center.m_123341_() & 0xF)), (double)center.m_123342_(), (double)((shipChunkZ << 4) + (center.m_123343_() & 0xF)));
        if (shipOn != null) {
            scaling = shipOn.getTransform().getShipToWorldScaling();
            Vector3d vector3d2 = shiptraption.getInertiaData().getCenterOfMassInShip().sub(centerInShip, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"sub(...)");
            Vector3dc offset = (Vector3dc)vector3d2;
            posInWorld = (Vector3dc)shipOn.getTransform().getShipToWorld().transformPosition((Vector3dc)posInOwnerShip.add(offset, new Vector3d()), new Vector3d());
            rotInWorld = shipOn.getTransform().getShipToWorldRotation();
        }
        Intrinsics.checkNotNull((Object)shiptraption, (String)"null cannot be cast to non-null type org.valkyrienskies.core.impl.game.ships.ShipDataCommon");
        ShipDataCommon shipDataCommon = (ShipDataCommon)shiptraption;
        Vector3dc vector3dc = posInWorld;
        Intrinsics.checkNotNull((Object)vector3dc);
        shipDataCommon.setTransform(ShipTransformImpl.Companion.create(vector3dc, shiptraption.getInertiaData().getCenterOfMassInShip(), rotInWorld, scaling));
        Vector3d vector3d3 = centerInShip.add(0.5, 0.5, 0.5, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d3, (String)"add(...)");
        Vector3dc bearingPos = (Vector3dc)vector3d3;
        Quaterniond quaterniond = rotationQuaternion.mul((Quaterniondc)new Quaterniond(new AxisAngle4d(Math.toRadians(90.0), 0.0, 0.0, 1.0)), new Quaterniond()).normalize();
        Intrinsics.checkNotNullExpressionValue((Object)quaterniond, (String)"normalize(...)");
        Quaterniondc hingeOrientation = (Quaterniondc)quaterniond;
        if (direction == Direction.WEST) {
            // empty if block
        }
        VSHingeOrientationConstraint hingeConstraint = new VSHingeOrientationConstraint(this.shiptraptionID, otherShipID, 1.0E-10, hingeOrientation, hingeOrientation, 1.0E10);
        double extraDist = 1.0;
        Vector3d vector3d4 = bearingPos.fma(-extraDist, axis, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d4, (String)"fma(...)");
        Vector3dc vector3dc2 = (Vector3dc)vector3d4;
        Vector3d vector3d5 = posInOwnerShip.fma(-extraDist, axis, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d5, (String)"fma(...)");
        VSAttachmentConstraint firstAttachment = new VSAttachmentConstraint(this.shiptraptionID, otherShipID, 1.0E-10, vector3dc2, (Vector3dc)vector3d5, 1.0E10, 0.0);
        Vector3d vector3d6 = bearingPos.fma(extraDist, axis, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d6, (String)"fma(...)");
        Vector3dc vector3dc3 = (Vector3dc)vector3d6;
        Vector3d vector3d7 = posInOwnerShip.fma(extraDist, axis, new Vector3d());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d7, (String)"fma(...)");
        VSAttachmentConstraint secondAttachment = new VSAttachmentConstraint(this.shiptraptionID, otherShipID, 1.0E-10, vector3dc3, (Vector3dc)vector3d7, 1.0E10, 0.0);
        Level level6 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level6, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        Integer n = VSGameUtilsKt.getShipObjectWorld((ServerLevel)((ServerLevel)level6)).createNewConstraint((VSConstraint)firstAttachment);
        if (n == null) {
            return;
        }
        int firstAttachmentId = n;
        Level level7 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level7, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        Integer n2 = VSGameUtilsKt.getShipObjectWorld((ServerLevel)((ServerLevel)level7)).createNewConstraint((VSConstraint)hingeConstraint);
        if (n2 == null) {
            return;
        }
        int hingeID = n2;
        Level level8 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level8, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        Integer n3 = VSGameUtilsKt.getShipObjectWorld((ServerLevel)((ServerLevel)level8)).createNewConstraint((VSConstraint)secondAttachment);
        if (n3 == null) {
            return;
        }
        int secondAttachmentID = n3;
        VSConstraintAndId firstAttachmentConstraint = new VSConstraintAndId(firstAttachmentId, (VSConstraint)firstAttachment);
        VSConstraintAndId hingeContraptionConstraint = new VSConstraintAndId(hingeID, (VSConstraint)hingeConstraint);
        VSConstraintAndId secondAttachmentConstraint = new VSConstraintAndId(secondAttachmentID, (VSConstraint)secondAttachment);
        double d = this.bearingAngle;
        float f = (float)veryUncoolFix * this.getSpeed();
        ScrollOptionBehaviour<ContraptionController.LockedMode> scrollOptionBehaviour = this.movementMode;
        Intrinsics.checkNotNull(scrollOptionBehaviour);
        PhysBearingCreateData data = new PhysBearingCreateData(pos, axis, d, f, scrollOptionBehaviour.get() == ContraptionController.LockedMode.LOCKED, this.shiptraptionID, firstAttachmentConstraint, hingeContraptionConstraint, null, null, secondAttachmentConstraint);
        Level level9 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level9);
        if (!level9.f_46443_) {
            BearingController bearingController = BearingController.Companion.getOrCreate(shiptraption);
            Intrinsics.checkNotNull((Object)bearingController);
            this.bearingID = bearingController.addPhysBearing(data);
        }
        this.isRunning = true;
        this.bearingAngle = 0.0f;
        this.sendData();
        this.updateGeneratedRotation();
    }

    public void destroy() {
        if (this.f_58857_ != null && this.bearingID != null) {
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            if (!level.f_46443_) {
                Level level2 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level2, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ServerShip ship = (ServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)((ServerLevel)level2)).getAllShips().getById(this.shiptraptionID);
                if (ship != null) {
                    BearingController bearingController = BearingController.Companion.getOrCreate(ship);
                    Intrinsics.checkNotNull((Object)bearingController);
                    BearingController controller = bearingController;
                    Object v = ((Map)controller.getBearingData()).get(this.bearingID);
                    Intrinsics.checkNotNull(v);
                    Integer n = ((PhysBearingData)v).getAttachID();
                    if (n == null) {
                        return;
                    }
                    int attachID = n;
                    Level level3 = this.f_58857_;
                    Intrinsics.checkNotNull((Object)level3, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                    VSGameUtilsKt.getShipObjectWorld((ServerLevel)((ServerLevel)level3)).removeConstraint(attachID);
                    Object v2 = ((Map)controller.getBearingData()).get(this.bearingID);
                    Intrinsics.checkNotNull(v2);
                    Integer n2 = ((PhysBearingData)v2).getHingeID();
                    if (n2 == null) {
                        return;
                    }
                    int hingeID = n2;
                    Level level4 = this.f_58857_;
                    Intrinsics.checkNotNull((Object)level4, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                    VSGameUtilsKt.getShipObjectWorld((ServerLevel)((ServerLevel)level4)).removeConstraint(hingeID);
                    Object v3 = ((Map)controller.getBearingData()).get(this.bearingID);
                    Intrinsics.checkNotNull(v3);
                    Integer secondAttachId = ((PhysBearingData)v3).getSecondAttachId();
                    if (secondAttachId != null) {
                        Level level5 = this.f_58857_;
                        Intrinsics.checkNotNull((Object)level5, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                        VSGameUtilsKt.getShipObjectWorld((ServerLevel)((ServerLevel)level5)).removeConstraint(secondAttachId.intValue());
                    }
                    Integer n3 = this.bearingID;
                    Intrinsics.checkNotNull((Object)n3);
                    controller.removePhysBearing(n3);
                }
            }
        }
    }

    public final void disassemble() {
        if (!this.isRunning && this.shiptraptionID == -1L) {
            return;
        }
        this.bearingAngle = 0.0f;
        if (this.shiptraptionID != -1L) {
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            ServerShip ship = (ServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)((ServerLevel)level)).getAllShips().getById(this.shiptraptionID);
            if (ship != null) {
                // empty if block
            }
            AllSoundEvents.CONTRAPTION_DISASSEMBLE.playOnServer(this.f_58857_, (Vec3i)this.f_58858_);
            return;
        }
        this.shiptraptionID = -1L;
        this.isRunning = false;
        this.updateGeneratedRotation();
        this.assembleNextTick = false;
        this.sendData();
    }

    private final void shipDisassemble() {
        if (this.shiptraptionID == -1L) {
            return;
        }
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            return;
        }
        Level level2 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level2, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerShip serverShip = (ServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)((ServerLevel)level2)).getAllShips().getById(this.shiptraptionID);
        if (serverShip == null) {
            return;
        }
        ServerShip ship = serverShip;
        if (this.bearingID != null) {
            BearingController bearingController = BearingController.Companion.getOrCreate(ship);
            Intrinsics.checkNotNull((Object)bearingController);
            BearingController controller = bearingController;
            Direction direction = (Direction)this.m_58900_().m_61143_((Property)BearingBlock.FACING);
            BlockPos blockPos = this.f_58858_.m_5484_(direction, 1);
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"relative(...)");
            Vector3dc inWorld = (Vector3dc)VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)blockPos));
            if (!controller.canDisassemble()) {
                return;
            }
        }
    }

    public void tick() {
        ServerShip ship;
        super.tick();
        this.prevAngle = this.bearingAngle;
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            this.clientAngleDiff /= 2.0f;
        }
        Level level2 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level2);
        if (!level2.f_46443_ && this.assembleNextTick) {
            this.assembleNextTick = false;
            if (!this.isRunning) {
                this.assemble();
            }
        }
        if (this.shouldRefresh) {
            Level level3 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level3);
            if (!level3.f_46443_) {
                Level level4 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level4, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ship = (ServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)((ServerLevel)level4)).getAllShips().getById(this.shiptraptionID);
                if (ship != null && this.bearingID != null) {
                    BearingController bearingController = BearingController.Companion.getOrCreate(ship);
                    Intrinsics.checkNotNull((Object)bearingController);
                    PhysBearingData bearingData = (PhysBearingData)((Map)bearingController.getBearingData()).get(this.bearingID);
                    if (bearingData != null) {
                        VSAttachmentConstraint vSAttachmentConstraint = bearingData.getAttachConstraint();
                        Intrinsics.checkNotNull((Object)vSAttachmentConstraint);
                        VSAttachmentConstraint vSAttachmentConstraint2 = vSAttachmentConstraint;
                        long shipId0 = vSAttachmentConstraint2.component1();
                        double compliance = vSAttachmentConstraint2.component3();
                        Vector3dc localPos0 = vSAttachmentConstraint2.component4();
                        Vector3dc localPos1 = vSAttachmentConstraint2.component5();
                        double maxForce = vSAttachmentConstraint2.component6();
                        double fixedDistance = vSAttachmentConstraint2.component7();
                        VSHingeOrientationConstraint vSHingeOrientationConstraint = bearingData.getHingeConstraint();
                        Intrinsics.checkNotNull((Object)vSHingeOrientationConstraint);
                        VSHingeOrientationConstraint vSHingeOrientationConstraint2 = vSHingeOrientationConstraint;
                        long shipId01 = vSHingeOrientationConstraint2.component1();
                        double compliance1 = vSHingeOrientationConstraint2.component3();
                        Quaterniondc localRot0 = vSHingeOrientationConstraint2.component4();
                        Quaterniondc localRot1 = vSHingeOrientationConstraint2.component5();
                        double maxTorque = vSHingeOrientationConstraint2.component6();
                        Level level5 = this.f_58857_;
                        Intrinsics.checkNotNull((Object)level5, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                        ServerLevel serverLevel = (ServerLevel)level5;
                        BlockPos blockPos = this.f_58858_;
                        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
                        Ship shipOn = (Ship)VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)((Vec3i)blockPos));
                        Level level6 = this.f_58857_;
                        Intrinsics.checkNotNull((Object)level6, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                        Map map = VSGameUtilsKt.getShipObjectWorld((ServerLevel)((ServerLevel)level6)).getDimensionToGroundBodyIdImmutable();
                        Level level7 = this.f_58857_;
                        Intrinsics.checkNotNull((Object)level7);
                        Object v = map.get(VSGameUtilsKt.getDimensionId((Level)level7));
                        Intrinsics.checkNotNull(v);
                        long shipOnID = ((Number)v).longValue();
                        if (shipOn != null) {
                            shipOnID = shipOn.getId();
                        } else {
                            Level level8 = this.f_58857_;
                            Intrinsics.checkNotNull((Object)level8);
                            BlockPos blockPos2 = this.f_58858_;
                            Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"worldPosition");
                            if (VSGameUtilsKt.isBlockInShipyard((Level)level8, (BlockPos)blockPos2)) {
                                this.isRunning = false;
                                this.assembleNextTick = false;
                                this.shouldRefresh = false;
                                return;
                            }
                        }
                        VSAttachmentConstraint attachConstraint = new VSAttachmentConstraint(shipId0, shipOnID, compliance, localPos0, localPos1, maxForce, fixedDistance);
                        VSHingeOrientationConstraint hingeConstraint = new VSHingeOrientationConstraint(shipId01, shipOnID, compliance1, localRot0, localRot1, maxTorque);
                        VSAttachmentConstraint secondAttachConstraint = null;
                        if (bearingData.getSecondAttachConstraint() != null) {
                            VSAttachmentConstraint vSAttachmentConstraint3 = bearingData.getSecondAttachConstraint();
                            Intrinsics.checkNotNull((Object)vSAttachmentConstraint3);
                            VSAttachmentConstraint vSAttachmentConstraint4 = vSAttachmentConstraint3;
                            long shipId02 = vSAttachmentConstraint4.component1();
                            double compliance2 = vSAttachmentConstraint4.component3();
                            Vector3dc localPos02 = vSAttachmentConstraint4.component4();
                            Vector3dc localPos12 = vSAttachmentConstraint4.component5();
                            double maxForce2 = vSAttachmentConstraint4.component6();
                            double fixedDistance2 = vSAttachmentConstraint4.component7();
                            secondAttachConstraint = new VSAttachmentConstraint(shipId02, shipOnID, compliance2, localPos02, localPos12, maxForce2, fixedDistance2);
                        }
                        boolean createdAttachment = false;
                        boolean createdHinge = false;
                        Level level9 = this.f_58857_;
                        Intrinsics.checkNotNull((Object)level9, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                        Integer attachID = VSGameUtilsKt.getShipObjectWorld((ServerLevel)((ServerLevel)level9)).createNewConstraint((VSConstraint)attachConstraint);
                        if (attachID != null) {
                            BearingController bearingController2 = BearingController.Companion.getOrCreate(ship);
                            Intrinsics.checkNotNull((Object)bearingController2);
                            Object v2 = ((Map)bearingController2.getBearingData()).get(this.bearingID);
                            Intrinsics.checkNotNull(v2);
                            ((PhysBearingData)v2).setAttachConstraint(attachConstraint);
                            BearingController bearingController3 = BearingController.Companion.getOrCreate(ship);
                            Intrinsics.checkNotNull((Object)bearingController3);
                            Object v3 = ((Map)bearingController3.getBearingData()).get(this.bearingID);
                            Intrinsics.checkNotNull(v3);
                            ((PhysBearingData)v3).setAttachID(attachID);
                            createdAttachment = true;
                        }
                        Level level10 = this.f_58857_;
                        Intrinsics.checkNotNull((Object)level10, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                        Integer hingeID = VSGameUtilsKt.getShipObjectWorld((ServerLevel)((ServerLevel)level10)).createNewConstraint((VSConstraint)hingeConstraint);
                        if (hingeID != null) {
                            BearingController bearingController4 = BearingController.Companion.getOrCreate(ship);
                            Intrinsics.checkNotNull((Object)bearingController4);
                            Object v4 = ((Map)bearingController4.getBearingData()).get(this.bearingID);
                            Intrinsics.checkNotNull(v4);
                            ((PhysBearingData)v4).setHingeConstraint(hingeConstraint);
                            BearingController bearingController5 = BearingController.Companion.getOrCreate(ship);
                            Intrinsics.checkNotNull((Object)bearingController5);
                            Object v5 = ((Map)bearingController5.getBearingData()).get(this.bearingID);
                            Intrinsics.checkNotNull(v5);
                            ((PhysBearingData)v5).setHingeID(hingeID);
                            createdHinge = true;
                        }
                        if (secondAttachConstraint != null) {
                            Level level11 = this.f_58857_;
                            Intrinsics.checkNotNull((Object)level11, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                            Integer secondAttachId = VSGameUtilsKt.getShipObjectWorld((ServerLevel)((ServerLevel)level11)).createNewConstraint((VSConstraint)secondAttachConstraint);
                            if (secondAttachId != null) {
                                BearingController bearingController6 = BearingController.Companion.getOrCreate(ship);
                                Intrinsics.checkNotNull((Object)bearingController6);
                                Object v6 = ((Map)bearingController6.getBearingData()).get(this.bearingID);
                                Intrinsics.checkNotNull(v6);
                                ((PhysBearingData)v6).setSecondAttachConstraint(secondAttachConstraint);
                                BearingController bearingController7 = BearingController.Companion.getOrCreate(ship);
                                Intrinsics.checkNotNull((Object)bearingController7);
                                Object v7 = ((Map)bearingController7.getBearingData()).get(this.bearingID);
                                Intrinsics.checkNotNull(v7);
                                ((PhysBearingData)v7).setSecondAttachId(secondAttachId);
                                createdAttachment = true;
                            }
                        }
                        if (createdHinge && createdAttachment) {
                            this.shouldRefresh = false;
                        }
                    }
                }
            }
        }
        if (this.inOutCorner < 1.0f && !this.cornerShrinking) {
            this.inOutCorner += 0.0075f;
        } else if (this.inOutCorner >= 1.0f) {
            this.cornerShrinking = true;
        }
        if (this.inOutCorner > 0.0f && this.cornerShrinking) {
            this.inOutCorner -= 0.0075f;
        } else if (this.inOutCorner <= 0.0f) {
            this.cornerShrinking = false;
        }
        if (this.isRunning && !this.open && !this.opening) {
            this.opening = true;
        }
        if (this.opening && this.isRunning && this.openProgress < 1.0f) {
            this.openProgress += 0.05f;
        } else if (this.openProgress >= 1.0f) {
            this.opening = false;
            this.open = true;
            this.openProgress = 1.0f;
        }
        if (!this.isRunning) {
            return;
        }
        if (this.shiptraptionID != -1L) {
            float angularSpeed = this.getAngularSpeed();
            float newAngle = this.bearingAngle + angularSpeed;
            this.bearingAngle = newAngle % (float)360;
        }
        if (this.isRunning) {
            Level level12 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level12);
            if (!level12.f_46443_ && this.shiptraptionID != -1L) {
                Level level13 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level13, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ship = (ServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)((ServerLevel)level13)).getAllShips().getById(this.shiptraptionID);
                if (ship != null) {
                    BearingController bearingController = BearingController.Companion.getOrCreate(ship);
                    Intrinsics.checkNotNull((Object)bearingController);
                    if (((Map)bearingController.getBearingData()).get(this.bearingID) == null) {
                        return;
                    }
                    int dumbFix = 1;
                    Direction direction = (Direction)this.m_58900_().m_61143_((Property)BearingBlock.FACING);
                    if (direction == Direction.WEST || direction == Direction.NORTH || direction == Direction.DOWN) {
                        dumbFix = -dumbFix;
                    }
                    double d = this.bearingAngle;
                    float f = (float)dumbFix * this.getSpeed();
                    ScrollOptionBehaviour<ContraptionController.LockedMode> scrollOptionBehaviour = this.movementMode;
                    Intrinsics.checkNotNull(scrollOptionBehaviour);
                    PhysBearingUpdateData data = new PhysBearingUpdateData(d, f, scrollOptionBehaviour.get() == ContraptionController.LockedMode.LOCKED, null, null);
                    BearingController bearingController8 = BearingController.Companion.getOrCreate(ship);
                    Intrinsics.checkNotNull((Object)bearingController8);
                    Integer n = this.bearingID;
                    Intrinsics.checkNotNull((Object)n);
                    bearingController8.updatePhysBearing(n, data);
                }
            }
        }
        if (this.disassembleWhenPossible) {
            this.shipDisassemble();
        }
        this.applyRotation();
    }

    public final boolean isNearInitialAngle() {
        return Math.abs(this.bearingAngle) < 45.0f || Math.abs(this.bearingAngle) > 315.0f;
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.shiptraptionID != -1L) {
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            if (!level.f_46443_) {
                this.sendData();
            }
        }
    }

    private final void applyRotation() {
    }

    public void attach(@NotNull ControlledContraptionEntity contraption) {
        Intrinsics.checkNotNullParameter((Object)contraption, (String)"contraption");
    }

    public void onStall() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (!level.f_46443_) {
            this.sendData();
        }
    }

    public boolean isValid() {
        return !this.m_58901_();
    }

    public boolean isAttachedTo(@NotNull AbstractContraptionEntity contraption) {
        Intrinsics.checkNotNullParameter((Object)contraption, (String)"contraption");
        return false;
    }

    public boolean addToTooltip(@NotNull List<? extends Component> tooltip, boolean isPlayerSneaking) {
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        if (super.addToTooltip(tooltip, isPlayerSneaking)) {
            return true;
        }
        if (isPlayerSneaking) {
            return false;
        }
        if (!this.isWindmill() && this.getSpeed() == 0.0f) {
            return false;
        }
        if (this.isRunning) {
            return false;
        }
        BlockState state = this.m_58900_();
        if (!(state.m_60734_() instanceof BearingBlock)) {
            return false;
        }
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        BlockState attachedState = level.m_8055_(this.f_58858_.m_121945_((Direction)state.m_61143_((Property)BearingBlock.FACING)));
        if (attachedState.m_247087_()) {
            return false;
        }
        TooltipHelper.addHint(tooltip, (String)"hint.empty_bearing", (Object[])new Object[0]);
        return true;
    }

    public void setAngle(float forcedAngle) {
        this.bearingAngle = forcedAngle;
    }

    @Override
    public boolean isShipContraptionController() {
        return true;
    }

    @Override
    @Nullable
    public Ship getConnectedShip() {
        return null;
    }

    public final float getAngle() {
        return this.bearingAngle;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\t\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/phys/bearing/PhysBearingBlockEntity$Companion;", "", "", "NO_SHIPTRAPTION_ID", "J", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.DOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.NORTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

