/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.contraptions.propeller.contraption;

import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ContraptionType;
import com.simibubi.create.content.contraptions.bearing.AnchoredLighter;
import com.simibubi.create.content.contraptions.render.ContraptionLighter;
import java.util.Queue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.ClockworkContraptions;
import org.valkyrienskies.clockwork.util.ClockworkConstants;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\r\u0018\u0000 @2\u00020\u0001:\u0001@B\t\b\u0016\u00a2\u0006\u0004\b>\u0010?B\u0013\b\u0016\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b>\u00103J+\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0013\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0017\u00a2\u0006\u0004\b\u001b\u0010\u001cJ=\u0010\"\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00102\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\u001e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020 H\u0014\u00a2\u0006\u0004\b\"\u0010#J'\u0010'\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b'\u0010(J)\u0010)\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u001d\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010,\u001a\u00020$2\u0006\u0010+\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b,\u0010-R.\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010.\u001a\u0004\u0018\u00010\u00108\u0006@DX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010/\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\"\u00105\u001a\u0002048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b5\u00106\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R*\u0010;\u001a\u0002042\u0006\u0010.\u001a\u0002048\u0006@DX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b;\u00106\u001a\u0004\b<\u00108\"\u0004\b=\u0010:\u00a8\u0006A"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/propeller/contraption/PropellerContraption;", "Lcom/simibubi/create/content/contraptions/Contraption;", "Lnet/minecraft/core/BlockPos;", "pos", "Lorg/apache/commons/lang3/tuple/Pair;", "Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate$StructureBlockInfo;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "capture", "", "addBlock", "(Lnet/minecraft/core/BlockPos;Lorg/apache/commons/lang3/tuple/Pair;)V", "Lnet/minecraft/world/level/Level;", "world", "", "assemble", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Z", "Lnet/minecraft/core/Direction;", "facing", "localPos", "canBeStabilized", "(Lnet/minecraft/core/Direction;Lnet/minecraft/core/BlockPos;)Z", "Lcom/simibubi/create/content/contraptions/ContraptionType;", "getType", "()Lcom/simibubi/create/content/contraptions/ContraptionType;", "isAnchoringBlockAt", "(Lnet/minecraft/core/BlockPos;)Z", "Lcom/simibubi/create/content/contraptions/render/ContraptionLighter;", "makeLighter", "()Lcom/simibubi/create/content/contraptions/render/ContraptionLighter;", "direction", "Ljava/util/Queue;", "frontier", "", "visited", "moveBlock", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/Direction;Ljava/util/Queue;Ljava/util/Set;)Z", "Lnet/minecraft/nbt/CompoundTag;", "tag", "spawnData", "readNBT", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/nbt/CompoundTag;Z)V", "searchMovedStructure", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Z", "spawnPacket", "writeNBT", "(Z)Lnet/minecraft/nbt/CompoundTag;", "<set-?>", "Lnet/minecraft/core/Direction;", "getFacing", "()Lnet/minecraft/core/Direction;", "setFacing", "(Lnet/minecraft/core/Direction;)V", "", "offset", "I", "getOffset", "()I", "setOffset", "(I)V", "sailBlocks", "getSailBlocks", "setSailBlocks", "<init>", "()V", "Companion", "clockwork"})
public final class PropellerContraption
extends Contraption {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int offset;
    private int sailBlocks;
    @Nullable
    private Direction facing;

    public final int getOffset() {
        return this.offset;
    }

    public final void setOffset(int n) {
        this.offset = n;
    }

    public final int getSailBlocks() {
        return this.sailBlocks;
    }

    protected final void setSailBlocks(int n) {
        this.sailBlocks = n;
    }

    @Nullable
    public final Direction getFacing() {
        return this.facing;
    }

    protected final void setFacing(@Nullable Direction direction) {
        this.facing = direction;
    }

    public PropellerContraption() {
    }

    public PropellerContraption(@Nullable Direction facing) {
        this.facing = facing;
    }

    public boolean assemble(@NotNull Level world, @NotNull BlockPos pos) throws AssemblyException {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.searchMovedStructure(world, pos, this.facing);
    }

    protected boolean moveBlock(@NotNull Level world, @Nullable Direction direction, @NotNull Queue<BlockPos> frontier, @NotNull Set<? extends BlockPos> visited) throws AssemblyException {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter(frontier, (String)"frontier");
        Intrinsics.checkNotNullParameter(visited, (String)"visited");
        return super.moveBlock(world, direction, frontier, visited);
    }

    public boolean searchMovedStructure(@NotNull Level world, @NotNull BlockPos pos, @Nullable Direction direction) throws AssemblyException {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return super.searchMovedStructure(world, pos.m_5484_(direction, this.offset + 1), null);
    }

    @NotNull
    public ContraptionType getType() {
        ContraptionType contraptionType = ClockworkContraptions.INSTANCE.getPROPELLOR();
        Intrinsics.checkNotNullExpressionValue((Object)contraptionType, (String)"<get-PROPELLOR>(...)");
        return contraptionType;
    }

    protected boolean isAnchoringBlockAt(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Direction direction = this.facing;
        Intrinsics.checkNotNull((Object)direction);
        return Intrinsics.areEqual((Object)pos, (Object)this.anchor.m_5484_(direction.m_122424_(), this.offset + 1));
    }

    public void addBlock(@NotNull BlockPos pos, @NotNull Pair<StructureTemplate.StructureBlockInfo, BlockEntity> capture) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter(capture, (String)"capture");
        BlockPos localPos = pos.m_121996_((Vec3i)this.anchor);
        if (!this.getBlocks().containsKey(localPos) && AllTags.AllBlockTags.WINDMILL_SAILS.matches(((StructureTemplate.StructureBlockInfo)capture.getKey()).f_74676_())) {
            int n = this.sailBlocks;
            this.sailBlocks = n + 1;
        }
        super.addBlock(pos, capture);
    }

    @NotNull
    public CompoundTag writeNBT(boolean spawnPacket) {
        CompoundTag tag = super.writeNBT(spawnPacket);
        tag.m_128405_(ClockworkConstants.Nbt.INSTANCE.getSAILS(), this.sailBlocks);
        String string = ClockworkConstants.Nbt.INSTANCE.getFACING();
        Direction direction = this.facing;
        Intrinsics.checkNotNull((Object)direction);
        tag.m_128405_(string, direction.m_122411_());
        tag.m_128405_(ClockworkConstants.Nbt.INSTANCE.getOFFSET(), this.offset);
        Intrinsics.checkNotNull((Object)tag);
        return tag;
    }

    public void readNBT(@NotNull Level world, @NotNull CompoundTag tag, boolean spawnData) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.sailBlocks = tag.m_128451_(ClockworkConstants.Nbt.INSTANCE.getSAILS());
        this.facing = Direction.m_122376_((int)tag.m_128451_(ClockworkConstants.Nbt.INSTANCE.getFACING()));
        this.offset = tag.m_128451_(ClockworkConstants.Nbt.INSTANCE.getOFFSET());
        super.readNBT(world, tag, spawnData);
    }

    public boolean canBeStabilized(@NotNull Direction facing, @NotNull BlockPos localPos) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
        Intrinsics.checkNotNullParameter((Object)localPos, (String)"localPos");
        if (facing.m_122424_() == this.facing && Intrinsics.areEqual((Object)BlockPos.f_121853_, (Object)localPos)) {
            bl = false;
        } else {
            Direction.Axis axis = facing.m_122434_();
            Direction direction = this.facing;
            Intrinsics.checkNotNull((Object)direction);
            bl = axis == direction.m_122434_();
        }
        return bl;
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public ContraptionLighter<?> makeLighter() {
        return (ContraptionLighter)new AnchoredLighter((Contraption)this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lorg/valkyrienskies/clockwork/content/contraptions/propeller/contraption/PropellerContraption$Companion;", "", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/core/Direction;", "direction", "Lorg/valkyrienskies/clockwork/content/contraptions/propeller/contraption/PropellerContraption;", "assembleProp", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Lorg/valkyrienskies/clockwork/content/contraptions/propeller/contraption/PropellerContraption;", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PropellerContraption assembleProp(@NotNull Level world, @NotNull BlockPos pos, @NotNull Direction direction) throws AssemblyException {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            PropellerContraption contraption = new PropellerContraption();
            boolean flapBlocks = false;
            contraption.setFacing(direction);
            if (!contraption.assemble(world, pos)) {
                return null;
            }
            for (int i = 0; i < 16; ++i) {
                BlockPos offsetPos = BlockPos.f_121853_.m_5484_(direction, i);
                if (!contraption.getBlocks().containsKey(offsetPos)) continue;
            }
            contraption.startMoving(world);
            contraption.expandBoundsAroundAxis(direction.m_122434_());
            return contraption;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

