/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.solid.delivery.chute;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.logistics.depot.EjectorBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.ClockworkPackets;
import org.valkyrienskies.clockwork.content.logistics.solid.delivery.ActiveChutes;
import org.valkyrienskies.clockwork.util.blocktype.ISyncableStorage;
import org.valkyrienskies.clockwork.util.blocktype.SyncableStoragePacket;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002:\u0001OB%\u0012\f\u0010I\u001a\b\u0012\u0002\b\u0003\u0018\u00010H\u0012\u0006\u0010J\u001a\u00020\u0016\u0012\u0006\u0010L\u001a\u00020K\u00a2\u0006\u0004\bM\u0010NJ\u001d\u0010\u0007\u001a\u00020\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ)\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0011J\u000f\u0010\u0014\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\r\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010#\u001a\u00020\"2\u0006\u0010!\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b#\u0010$J\u0015\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000b0%H\u0016\u00a2\u0006\u0004\b&\u0010'J\u000f\u0010(\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b(\u0010\u001aJ\u000f\u0010)\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b)\u0010*J\u000f\u0010+\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b+\u0010*J\u0015\u0010,\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b,\u0010-J\u000f\u0010.\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b.\u0010\u0015J\u001f\u00100\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010/\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b0\u00101J\u0017\u00102\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b2\u0010\u001dJ\u001f\u00103\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b3\u00104J\u0017\u00107\u001a\u00020\u000f2\u0006\u00106\u001a\u000205H\u0016\u00a2\u0006\u0004\b7\u00108J\u001d\u0010:\u001a\u00020\u00062\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u000b0%H\u0016\u00a2\u0006\u0004\b:\u0010;J\u000f\u0010<\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b<\u0010\u0015R\"\u0010=\u001a\u00020\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b=\u0010>\u001a\u0004\b?\u0010\u001a\"\u0004\b@\u0010AR\u0016\u0010C\u001a\u00020B8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\bC\u0010DR\u001c\u0010E\u001a\b\u0012\u0004\u0012\u00020\u000b0%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bE\u0010FR\u001c\u0010G\u001a\b\u0012\u0004\u0012\u00020\u000b0%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bG\u0010F\u00a8\u0006P"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/chute/DeliveryChuteBlockEntity;", "Lcom/simibubi/create/content/kinetics/base/KineticBlockEntity;", "Lorg/valkyrienskies/clockwork/util/blocktype/ISyncableStorage;", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "", "addBehaviours", "(Ljava/util/List;)V", "", "index", "Lnet/minecraft/world/item/ItemStack;", "itemStack", "Lnet/minecraft/core/Direction;", "direction", "", "canPlaceItemThroughFace", "(ILnet/minecraft/world/item/ItemStack;Lnet/minecraft/core/Direction;)Z", "stack", "canTakeItemThroughFace", "clearContent", "()V", "Lnet/minecraft/core/BlockPos;", "getBlockPositionFromISS", "()Lnet/minecraft/core/BlockPos;", "getContainerSize", "()I", "slot", "getItem", "(I)Lnet/minecraft/world/item/ItemStack;", "Lorg/joml/Vector3dc;", "getRealPos", "()Lorg/joml/Vector3dc;", "side", "", "getSlotsForFace", "(Lnet/minecraft/core/Direction;)[I", "Lnet/minecraft/core/NonNullList;", "getStorageInventory", "()Lnet/minecraft/core/NonNullList;", "getStorageInventorySize", "isEmpty", "()Z", "isOnShip", "receiveItem", "(Lnet/minecraft/world/item/ItemStack;)Z", "remove", "amount", "removeItem", "(II)Lnet/minecraft/world/item/ItemStack;", "removeItemNoUpdate", "setItem", "(ILnet/minecraft/world/item/ItemStack;)V", "Lnet/minecraft/world/entity/player/Player;", "player", "stillValid", "(Lnet/minecraft/world/entity/player/Player;)Z", "storage", "sync", "(Lnet/minecraft/core/NonNullList;)V", "tick", "id", "I", "getId", "setId", "(I)V", "Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/ScrollValueBehaviour;", "idBehavior", "Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/ScrollValueBehaviour;", "inventory", "Lnet/minecraft/core/NonNullList;", "previousInventory", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "typeIn", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "ChuteSlot", "clockwork"})
public final class DeliveryChuteBlockEntity
extends KineticBlockEntity
implements ISyncableStorage {
    @NotNull
    private NonNullList<ItemStack> inventory;
    @NotNull
    private NonNullList<ItemStack> previousInventory;
    private int id;
    private ScrollValueBehaviour idBehavior;

    public DeliveryChuteBlockEntity(@Nullable BlockEntityType<?> typeIn, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(typeIn, pos, state);
        NonNullList nonNullList = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"withSize(...)");
        this.inventory = nonNullList;
        this.previousInventory = this.inventory;
    }

    public final int getId() {
        return this.id;
    }

    public final void setId(int n) {
        this.id = n;
    }

    public void addBehaviours(@NotNull List<BlockEntityBehaviour> behaviours) {
        Intrinsics.checkNotNullParameter(behaviours, (String)"behaviours");
        ScrollValueBehaviour scrollValueBehaviour = new ScrollValueBehaviour((Component)Lang.translateDirect((String)"delivery.identifier", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new ChuteSlot()).between(1, 99).requiresWrench().withFormatter(DeliveryChuteBlockEntity::addBehaviours$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)scrollValueBehaviour, (String)"withFormatter(...)");
        this.idBehavior = scrollValueBehaviour;
        ScrollValueBehaviour scrollValueBehaviour2 = this.idBehavior;
        if (scrollValueBehaviour2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"idBehavior");
            scrollValueBehaviour2 = null;
        }
        behaviours.add((BlockEntityBehaviour)scrollValueBehaviour2);
        super.addBehaviours(behaviours);
    }

    public void tick() {
        ScrollValueBehaviour scrollValueBehaviour;
        if (this.f_58857_ == null) {
            return;
        }
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            return;
        }
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        if (!ActiveChutes.INSTANCE.hasChute(blockPos)) {
            BlockPos blockPos2 = this.f_58858_;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"worldPosition");
            ActiveChutes.INSTANCE.addChute(blockPos2, this);
        }
        if ((scrollValueBehaviour = this.idBehavior) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"idBehavior");
            scrollValueBehaviour = null;
        }
        this.id = scrollValueBehaviour.value;
        if (!Intrinsics.areEqual(this.previousInventory, this.inventory)) {
            Level level2 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level2);
            ClockworkPackets.Companion.sendToNear((Level)((ServerLevel)level2), this.f_58858_, 64, new SyncableStoragePacket(this));
        }
        this.previousInventory = this.inventory;
    }

    public void remove() {
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        ActiveChutes.INSTANCE.removeChute(blockPos);
        super.remove();
    }

    @Override
    public void sync(@NotNull NonNullList<ItemStack> storage) {
        Intrinsics.checkNotNullParameter(storage, (String)"storage");
        this.inventory = storage;
    }

    @Override
    @NotNull
    public NonNullList<ItemStack> getStorageInventory() {
        return this.inventory;
    }

    @Override
    public int getStorageInventorySize() {
        return 1;
    }

    private final boolean isOnShip() {
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            return false;
        }
        Level level2 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level2);
        ServerLevel serverLevel = (ServerLevel)level2;
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        return VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)((Vec3i)blockPos)) != null;
    }

    @NotNull
    public final Vector3dc getRealPos() {
        Vector3dc vector3dc;
        if (this.isOnShip()) {
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos blockPos = this.f_58858_;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
            LoadedServerShip loadedServerShip = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)((Vec3i)blockPos));
            Intrinsics.checkNotNull((Object)loadedServerShip);
            Matrix4dc matrix4dc = loadedServerShip.getTransform().getShipToWorld();
            BlockPos blockPos2 = this.f_58858_;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"worldPosition");
            Vector3d vector3d = matrix4dc.transformPosition(VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)blockPos2)));
            Intrinsics.checkNotNull((Object)vector3d);
            vector3dc = (Vector3dc)vector3d;
        } else {
            BlockPos blockPos = this.f_58858_;
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
            vector3dc = (Vector3dc)VectorConversionsMCKt.toJOMLD((Vec3i)((Vec3i)blockPos));
        }
        return vector3dc;
    }

    public final boolean receiveItem(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        if (((ItemStack)this.inventory.get(0)).m_41619_()) {
            this.inventory.set(0, (Object)itemStack);
            return true;
        }
        if (((ItemStack)this.inventory.get(0)).m_150930_(itemStack.m_41720_()) && ((ItemStack)this.inventory.get(0)).m_41613_() + itemStack.m_41613_() <= ((ItemStack)this.inventory.get(0)).m_41741_()) {
            ItemStack itemStack2 = (ItemStack)this.inventory.get(0);
            itemStack2.m_41764_(itemStack2.m_41613_() + itemStack.m_41613_());
            return true;
        }
        return false;
    }

    public void m_6211_() {
        this.inventory.set(0, (Object)ItemStack.f_41583_);
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        return ((ItemStack)this.inventory.get(0)).m_41619_();
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        Object object = this.inventory.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ItemStack)object;
    }

    @NotNull
    public ItemStack m_7407_(int slot, int amount) {
        ItemStack itemStack = ((ItemStack)this.inventory.get(0)).m_41620_(amount);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"split(...)");
        return itemStack;
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        Object object = this.inventory.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        ItemStack stack = (ItemStack)object;
        this.inventory.set(0, (Object)ItemStack.f_41583_);
        return stack;
    }

    public void m_6836_(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.inventory.set(0, (Object)stack);
    }

    public boolean m_6542_(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return true;
    }

    @NotNull
    public int[] m_7071_(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return new int[0];
    }

    public boolean m_7155_(int index, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        return false;
    }

    public boolean m_7157_(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return true;
    }

    @Override
    @NotNull
    public BlockPos getBlockPositionFromISS() {
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        return blockPos;
    }

    private static final String addBehaviours$lambda$0(int i) {
        return i == 0 ? "*" : String.valueOf(i);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0007H\u0014\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/chute/DeliveryChuteBlockEntity$ChuteSlot;", "Lcom/simibubi/create/foundation/blockEntity/behaviour/ValueBoxTransform$Sided;", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "", "angle", "(Lnet/minecraft/world/level/block/state/BlockState;)F", "Lnet/minecraft/world/phys/Vec3;", "getLocalOffset", "(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/phys/Vec3;", "getSouthLocation", "()Lnet/minecraft/world/phys/Vec3;", "Lnet/minecraft/core/Direction;", "direction", "", "isSideActive", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;)Z", "Lcom/mojang/blaze3d/vertex/PoseStack;", "ms", "", "rotate", "(Lnet/minecraft/world/level/block/state/BlockState;Lcom/mojang/blaze3d/vertex/PoseStack;)V", "<init>", "()V", "clockwork"})
    private static final class ChuteSlot
    extends ValueBoxTransform.Sided {
        @NotNull
        public Vec3 getLocalOffset(@NotNull BlockState state) {
            Vec3 vec3;
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            if (this.direction != Direction.UP) {
                Vec3 vec32 = super.getLocalOffset(state);
                vec3 = vec32;
                Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getLocalOffset(...)");
            } else {
                Vec3 vec33 = new Vec3(0.5, 0.65625, 0.5).m_82549_(VecHelper.rotate((Vec3)VecHelper.voxelSpace((double)0.0, (double)0.0, (double)-5.0), (double)this.angle(state), (Direction.Axis)Direction.Axis.Y));
                vec3 = vec33;
                Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"add(...)");
            }
            return vec3;
        }

        public void rotate(@NotNull BlockState state, @NotNull PoseStack ms) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
            if (this.direction != Direction.UP) {
                super.rotate(state, ms);
                return;
            }
            ((TransformStack)TransformStack.cast((PoseStack)ms).rotateY((double)this.angle(state))).rotateX(90.0);
        }

        private final float angle(BlockState state) {
            return AllBlocks.WEIGHTED_EJECTOR.has(state) ? AngleHelper.horizontalAngle((Direction)((Direction)state.m_61143_(EjectorBlock.HORIZONTAL_FACING))) : 0.0f;
        }

        protected boolean isSideActive(@NotNull BlockState state, @NotNull Direction direction) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            return direction.m_122434_() == ((Direction)state.m_61143_(EjectorBlock.HORIZONTAL_FACING)).m_122434_() || direction == Direction.UP;
        }

        @NotNull
        protected Vec3 getSouthLocation() {
            Vec3 vec3;
            if (this.direction == Direction.UP) {
                Vec3 vec32 = Vec3.f_82478_;
                vec3 = vec32;
                Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"ZERO");
            } else {
                Vec3 vec33 = VecHelper.voxelSpace((double)8.0, (double)6.0, (double)15.5);
                vec3 = vec33;
                Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"voxelSpace(...)");
            }
            return vec3;
        }
    }
}

