/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.forge.content.contraptions.sticker;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.contraptions.TranslatingContraption;
import com.simibubi.create.content.contraptions.bearing.BearingContraption;
import com.simibubi.create.content.contraptions.bearing.StabilizedContraption;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.gantry.GantryContraption;
import com.simibubi.create.content.contraptions.piston.LinearActuatorBlockEntity;
import com.simibubi.create.content.contraptions.piston.PistonContraption;
import com.simibubi.create.content.contraptions.pulley.PulleyContraption;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4fc;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Unique;
import org.valkyrienskies.clockwork.forge.content.contraptions.sticker.StickerParticleUtil;
import org.valkyrienskies.clockwork.mixin.accessors.IMixinPistonContraption;
import org.valkyrienskies.clockwork.util.ClockworkUtils;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.apigame.constraints.VSAttachmentOrientationConstraint;
import org.valkyrienskies.core.apigame.constraints.VSConstraint;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.mixin.mod_compat.create.blockentity.IMixinMechanicalBearingTileEntity;
import org.valkyrienskies.mod.mixinducks.mod_compat.create.IMixinControlledContraptionEntity;
import org.valkyrienskies.mod.mixinducks.mod_compat.create.MixinAbstractContraptionEntityDuck;

public class StickerMovementBehaviour
implements MovementBehaviour {
    private static final double DISTANCE_BUFFER = 1.05;
    public boolean isStopped = true;
    private static final Logger LOGGER = LogManager.getLogger((String)"Clockwork.StickerMovementBehaviour");

    public boolean renderAsNormalBlockEntity() {
        return true;
    }

    public void tick(MovementContext context) {
        if (context.world == null || context.world.f_46443_) {
            return;
        }
        CompoundTag extraData = context.blockEntityData.m_128469_("ForgeData");
        if (!extraData.m_128456_() && extraData.m_128441_("ShipStickerConstraint")) {
            if (!this.isStopped) {
                StickerMovementBehaviour.doUpdateConstraint(context, null, null);
            }
        } else if (((Boolean)context.state.m_61143_((Property)BlockStateProperties.f_61432_)).booleanValue()) {
            context.blockEntityData.m_128365_("ForgeData", (Tag)new CompoundTag());
            StickerMovementBehaviour.isAttachedToShipOrWorld(true, context.world, VectorConversionsMCKt.toJOML((Vec3)context.position), VectorConversionsMCKt.toJOML((Vec3)((Vec3)context.rotation.apply(Vec3.m_82528_((Vec3i)((Direction)context.state.m_61143_((Property)DirectionalBlock.f_52588_)).m_122436_())))), context.blockEntityData.m_128469_("ForgeData"));
        }
    }

    @Unique
    @Nullable
    Direction.Axis getFacingAxis(MovementContext context) {
        Direction.Axis axis = null;
        Contraption contraption = context.contraption;
        if (contraption instanceof PistonContraption) {
            PistonContraption pistonContraption = (PistonContraption)contraption;
            axis = ((IMixinPistonContraption)pistonContraption).getOrientation().m_122434_();
        }
        if ((contraption = context.contraption) instanceof PulleyContraption) {
            PulleyContraption pulleyContraption = (PulleyContraption)contraption;
            axis = Direction.Axis.Y;
        }
        if ((contraption = context.contraption) instanceof GantryContraption) {
            GantryContraption gantryContraption = (GantryContraption)contraption;
            axis = gantryContraption.getFacing().m_122434_();
        }
        return axis;
    }

    public void onSpeedChanged(MovementContext context, Vec3 oldMotion, Vec3 motion) {
        float axisMotion;
        Direction.Axis axis = this.getFacingAxis(context);
        this.isStopped = axis != null ? (double)(axisMotion = Math.abs(VecHelper.getCoordinate((Vec3)motion, (Direction.Axis)axis))) < 0.001 : motion.equals((Object)Vec3.f_82478_);
        Vector3d a = new Vector3d(1.0, 45.0, 1.0);
    }

    @Unique
    private boolean getAssembleNextTick(MovementContext context) {
        boolean result = false;
        if (context.contraption.entity instanceof ControlledContraptionEntity) {
            if (context.contraption instanceof TranslatingContraption) {
                result = ((LinearActuatorBlockEntity)((IMixinControlledContraptionEntity)context.contraption.entity).grabController()).assembleNextTick;
            }
            if (context.contraption instanceof BearingContraption || context.contraption instanceof StabilizedContraption) {
                result = ((IMixinMechanicalBearingTileEntity)((IMixinControlledContraptionEntity)context.contraption.entity).grabController()).isAssembleNextTick();
            }
        }
        return result;
    }

    public void startMoving(MovementContext context) {
        this.isStopped = false;
    }

    public void stopMoving(MovementContext context) {
        this.isStopped = true;
        Vector3d position = null;
        Quaterniond quaterniond = null;
        CompoundTag extraData = context.blockEntityData.m_128469_("ForgeData");
        double distance = 1.05;
        if (extraData.m_128441_("ShipStickerDistance")) {
            distance = extraData.m_128459_("ShipStickerDistance");
        }
        Direction myDir = (Direction)context.state.m_61143_((Property)DirectionalBlock.f_52588_);
        Vec3 myDirNormal = Vec3.m_82528_((Vec3i)myDir.m_122436_()).m_82490_(0.5);
        if (!this.getAssembleNextTick(context)) {
            if (((Boolean)context.state.m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue()) {
                extraData.m_128379_("ShipStickerAlreadyPowered", true);
            }
            StructureTransform structureTransform = ((MixinAbstractContraptionEntityDuck)context.contraption.entity).getStructureTransform();
            position = VectorConversionsMCKt.toJOML((Vec3)Vec3.m_82512_((Vec3i)structureTransform.apply(context.localPos)).m_82549_(structureTransform.applyWithoutOffsetUncentered(myDirNormal)));
            if (distance < 1.05) {
                position.add((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)structureTransform.applyWithoutOffsetUncentered(Vec3.m_82528_((Vec3i)myDir.m_122436_()).m_82490_(distance / -1.0 + 1.05))));
            }
            extraData.m_128365_("ShipStickerShip1Vec", (Tag)StickerMovementBehaviour.writeVector3D(position));
            Contraption contraption = context.contraption;
            if (contraption instanceof BearingContraption) {
                BearingContraption bearingContraption = (BearingContraption)contraption;
                Quaterniond tempQuat = VectorConversionsMCKt.toJOML((Vec3)Vec3.m_82528_((Vec3i)structureTransform.applyWithoutOffset(context.localPos))).rotationTo((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)Vec3.m_82528_((Vec3i)context.localPos)), new Quaterniond());
                quaterniond = new Quaterniond();
                tempQuat.mul((Quaterniondc)StickerMovementBehaviour.readQuatd(extraData.m_128469_("ShipStickerShip1Quat")), quaterniond);
                extraData.m_128365_("ShipStickerShip1Quat", (Tag)StickerMovementBehaviour.writeQuatd(quaterniond));
            }
        } else {
            Vector3d tempShip1Pos = VectorConversionsMCKt.toJOML((Vec3)context.position.m_82549_((Vec3)context.rotation.apply(myDirNormal)));
            extraData.m_128365_("ShipStickerShip1Vec", (Tag)StickerMovementBehaviour.writeVector3D(tempShip1Pos));
        }
        if (!extraData.m_128456_() && extraData.m_128441_("ShipStickerConstraint")) {
            StickerMovementBehaviour.doUpdateConstraint(context, position, quaterniond);
        }
    }

    static void doUpdateConstraint(MovementContext context, @Nullable Vector3d ship1Pos, @Nullable Quaterniond ship1Rot) {
        if (context.world.f_46443_) {
            return;
        }
        Ship ship1 = null;
        Ship ship2 = null;
        double distance = 1.05;
        CompoundTag compoundTag = context.blockEntityData.m_128469_("ForgeData");
        if (compoundTag.m_128441_("ShipStickerConstraint")) {
            Vector3d ship2Pos = null;
            Quaterniond ship2Rot = null;
            if (compoundTag.m_128441_("ShipStickerDistance")) {
                distance = compoundTag.m_128459_("ShipStickerDistance");
            }
            if (compoundTag.m_128441_("ShipStickerShip1Id")) {
                ship1 = VSGameUtilsKt.getShipObjectWorld((Level)context.world).getAllShips().getById(compoundTag.m_128454_("ShipStickerShip1Id"));
            }
            if (compoundTag.m_128441_("ShipStickerShip2Id")) {
                ship2 = VSGameUtilsKt.getShipObjectWorld((Level)context.world).getAllShips().getById(compoundTag.m_128454_("ShipStickerShip2Id"));
            }
            if (compoundTag.m_128441_("ShipStickerShip2Vec")) {
                ship2Pos = new Vector3d((Vector3dc)StickerMovementBehaviour.readVector3D(compoundTag.m_128469_("ShipStickerShip2Vec")));
            }
            if (compoundTag.m_128441_("ShipStickerShip2Quat")) {
                ship2Rot = new Quaterniond((Quaterniondc)StickerMovementBehaviour.readQuatd(compoundTag.m_128469_("ShipStickerShip2Quat")));
            }
            if (ship1 == null && ship2 == null) {
                return;
            }
            Direction myDir = (Direction)context.state.m_61143_((Property)DirectionalBlock.f_52588_);
            Vec3 myDirNormal = ship1 != null && ship2 != null ? Vec3.m_82528_((Vec3i)myDir.m_122436_()).m_82490_(0.5) : Vec3.m_82528_((Vec3i)myDir.m_122436_()).m_82490_(0.5);
            if (ship1Pos == null) {
                if (compoundTag.m_128441_("ShipStickerShip1Vec")) {
                    ship1Pos = new Vector3d((Vector3dc)StickerMovementBehaviour.readVector3D(compoundTag.m_128469_("ShipStickerShip1Vec")));
                }
                ship1Pos = VectorConversionsMCKt.toJOML((Vec3)context.position.m_82549_((Vec3)context.rotation.apply(myDirNormal)));
                Contraption contraption = context.contraption;
                if (contraption instanceof StabilizedContraption) {
                    StabilizedContraption stabilizedContraption = (StabilizedContraption)contraption;
                    ship1Pos.add((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)Vec3.m_82528_((Vec3i)stabilizedContraption.getFacing().m_122436_())).mul(0.125));
                }
                ship1Pos.add((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)context.motion));
                if (distance < 1.05) {
                    ship1Pos.add((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)((Vec3)context.rotation.apply(Vec3.m_82528_((Vec3i)myDir.m_122436_())))).mul(distance / -1.0 + 1.05));
                }
            } else {
                compoundTag.m_128365_("ShipStickerShip1Vec", (Tag)StickerMovementBehaviour.writeVector3D(ship1Pos));
            }
            if (ship1Rot == null && compoundTag.m_128441_("ShipStickerShip1Quat")) {
                ship1Rot = new Quaterniond((Quaterniondc)StickerMovementBehaviour.readQuatd(compoundTag.m_128469_("ShipStickerShip1Quat")));
                AbstractContraptionEntity.ContraptionRotationState rotState = context.contraption.entity.getRotationState();
                ship1Rot = new Quaterniond().setFromNormalized((Matrix4fc)rotState.asMatrix().getAsMatrix4f()).mul((Quaterniondc)ship1Rot);
            }
            VSAttachmentOrientationConstraint constraint = StickerMovementBehaviour.makeConstraint(ship1Pos, new Vector3d((Vector3dc)ship1Pos), ship1, ship2, (ServerLevel)context.world, ship1Rot, ship2Rot, ship2Pos);
            ServerShipWorldCore shipWorld = VSGameUtilsKt.getShipObjectWorld((ServerLevel)((ServerLevel)context.world));
            shipWorld.removeConstraint(compoundTag.m_128451_("ShipStickerConstraint"));
            Integer constraintId = shipWorld.createNewConstraint((VSConstraint)constraint);
            compoundTag.m_128405_("ShipStickerConstraint", constraintId.intValue());
        }
    }

    @Unique
    private static VSAttachmentOrientationConstraint makeConstraint(Vector3d ship1ConstraintPos, Vector3d ship2ConstraintPos, Ship ship1, Ship ship2, ServerLevel level, @Nullable Quaterniond ship1Rot, @Nullable Quaterniond ship2Rot, @Nullable Vector3d ship2Pos) {
        long ship2Id;
        long ship1Id;
        if (ship1 == null && ship2 == null) {
            return null;
        }
        long groundId = (Long)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getDimensionToGroundBodyIdImmutable().get(VSGameUtilsKt.getDimensionId((Level)level));
        if (ship1Rot == null && ship1 == null) {
            ship1Rot = new Quaterniond();
        }
        if (ship2Rot == null && ship2 == null) {
            ship2Rot = new Quaterniond();
        }
        double mass = 100.0;
        if (ship1 != null) {
            ship1.getShipToWorld().transformPosition(ship2ConstraintPos);
            ship1Id = ship1.getId();
            if (ship1Rot == null) {
                ship1Rot = (Quaterniond)ship1.getTransform().getShipToWorldRotation();
            }
            mass = ((ServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(ship1Id)).getInertiaData().getMass();
        } else {
            ship1Id = groundId;
        }
        if (ship2 != null) {
            ship2.getWorldToShip().transformPosition(ship2ConstraintPos);
            ship2Id = ship2.getId();
            if (ship2Rot == null) {
                ship2Rot = (Quaterniond)ship2.getTransform().getShipToWorldRotation();
            }
            mass = ((ServerShip)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(ship2Id)).getInertiaData().getMass();
        } else {
            ship2Id = groundId;
        }
        if (ship2Pos != null) {
            ship2ConstraintPos = ship2Pos;
        }
        Quaterniond ship1Rotation = ship1Rot;
        Quaterniond ship2Rotation = ship2Rot;
        VSAttachmentOrientationConstraint constraint = new VSAttachmentOrientationConstraint(ship1Id, ship2Id, 1.0E-9 / mass, (Vector3dc)ship1ConstraintPos, (Vector3dc)ship2ConstraintPos, 1.0E10, (Quaterniondc)ship1Rotation, (Quaterniondc)ship2Rotation, 1.0E10);
        return constraint;
    }

    static Vector3d readVector3D(CompoundTag compoundTag) {
        return new Vector3d(compoundTag.m_128459_("x"), compoundTag.m_128459_("y"), compoundTag.m_128459_("z"));
    }

    static CompoundTag writeVector3D(Vector3d vector3d) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128347_("x", vector3d.x);
        compoundTag.m_128347_("y", vector3d.y);
        compoundTag.m_128347_("z", vector3d.z);
        return compoundTag;
    }

    static Quaterniond readQuatd(CompoundTag compoundTag) {
        return new Quaterniond(compoundTag.m_128459_("x"), compoundTag.m_128459_("y"), compoundTag.m_128459_("z"), compoundTag.m_128459_("w"));
    }

    static CompoundTag writeQuatd(Quaterniond quaterniond) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128347_("x", quaterniond.x);
        compoundTag.m_128347_("y", quaterniond.y);
        compoundTag.m_128347_("z", quaterniond.z);
        compoundTag.m_128347_("w", quaterniond.w);
        return compoundTag;
    }

    public static boolean isAttachedToShipOrWorld(boolean attach, Level level, Vector3d myPosCentered, Vector3d myDirNormal, CompoundTag compoundTag) {
        boolean result = false;
        if (level == null) {
            return false;
        }
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)level, (Vector3dc)myPosCentered);
        Ship ship2 = null;
        Vector3d tempDirNormal = new Vector3d((Vector3dc)myDirNormal).mul(0.75);
        Vector3d searchPos = new Vector3d((Vector3dc)myPosCentered).add((Vector3dc)tempDirNormal);
        if (ship != null) {
            ship.getShipToWorld().transformPosition((Vector3dc)searchPos, searchPos);
        }
        BlockPos searchBlockPos = BlockPos.m_274561_((double)searchPos.x, (double)searchPos.y, (double)searchPos.z);
        BlockState worldBlockState = level.m_8055_(searchBlockPos);
        double distance = 0.0;
        if (!worldBlockState.m_60795_()) {
            distance = Vector3d.distance((double)myPosCentered.x, (double)myPosCentered.y, (double)myPosCentered.z, (double)searchBlockPos.m_123341_(), (double)searchBlockPos.m_123342_(), (double)searchBlockPos.m_123343_());
            result = true;
        } else {
            double bounds = 0.5;
            AABB searchAABB = new AABB(searchPos.x - bounds, searchPos.y - bounds, searchPos.z - bounds, searchPos.x + bounds, searchPos.y + bounds, searchPos.z + bounds);
            Iterator ships = VSGameUtilsKt.getShipsIntersecting((Level)level, (AABB)searchAABB).iterator();
            Vector3d transformedSearchPos = new Vector3d((Vector3dc)searchPos);
            if (ships.hasNext()) {
                do {
                    BlockState blockState;
                    Ship shipItr;
                    if ((shipItr = (Ship)ships.next()) == ship) continue;
                    shipItr.getWorldToShip().transformPosition(transformedSearchPos);
                    BlockPos blockPos = BlockPos.m_274446_((Position)VectorConversionsMCKt.toMinecraft((Vector3dc)transformedSearchPos));
                    if (!VSGameUtilsKt.isBlockInShipyard((Level)level, (BlockPos)blockPos) || (blockState = level.m_8055_(blockPos)).m_60795_() || !blockState.m_60659_((BlockGetter)level, blockPos, Direction.UP, SupportType.RIGID)) continue;
                    searchBlockPos = BlockPos.m_274446_((Position)VectorConversionsMCKt.toMinecraft((Vector3dc)shipItr.getShipToWorld().transformPosition((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), new Vector3d())));
                    distance = Vector3d.distance((double)myPosCentered.x, (double)myPosCentered.y, (double)myPosCentered.z, (double)searchBlockPos.m_123341_(), (double)searchBlockPos.m_123342_(), (double)searchBlockPos.m_123343_());
                    result = true;
                    ship2 = shipItr;
                } while (ships.hasNext() && !result);
            }
        }
        if (result && !level.f_46443_ && attach) {
            StickerMovementBehaviour.doAttach((ServerLevel)level, ship, ship2, myPosCentered, myDirNormal, compoundTag, distance);
        }
        return result;
    }

    public static void doAttach(ServerLevel level, Ship ship1, Ship ship2, Vector3d myPos, Vector3d myDirNormal, CompoundTag compoundTag, double distance) {
        VSAttachmentOrientationConstraint constraint;
        if (ship1 == null && ship2 == null) {
            return;
        }
        StickerMovementBehaviour.removeConstraint(level, false, compoundTag);
        Vector3d adjustedDirNormal = new Vector3d((Vector3dc)myDirNormal).mul(0.5);
        Vector3d ship1Pos = new Vector3d((Vector3dc)myPos).add((Vector3dc)adjustedDirNormal);
        Vector3d ship2ConstraintPos = new Vector3d((Vector3dc)ship1Pos);
        if (distance < 1.05) {
            ship1Pos.add((Vector3dc)new Vector3d((Vector3dc)myDirNormal).mul(distance / -1.0 + 1.05));
        }
        Vector3d ship2Pos = null;
        Quaterniond ship1Rot = null;
        Quaterniond ship2Rot = null;
        if (compoundTag.m_128441_("ShipStickerConstraint")) {
            if (compoundTag.m_128441_("ShipStickerDistance")) {
                distance = compoundTag.m_128459_("ShipStickerDistance");
            }
            if (compoundTag.m_128441_("ShipStickerShip1Id")) {
                ship1 = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(compoundTag.m_128454_("ShipStickerShip1Id"));
            }
            if (compoundTag.m_128441_("ShipStickerShip1Vec")) {
                ship1Pos = new Vector3d((Vector3dc)StickerMovementBehaviour.readVector3D(compoundTag.m_128469_("ShipStickerShip1Vec")));
            }
            if (compoundTag.m_128441_("ShipStickerShip1Quat")) {
                ship1Rot = new Quaterniond((Quaterniondc)StickerMovementBehaviour.readQuatd(compoundTag.m_128469_("ShipStickerShip1Quat")));
            }
            if (compoundTag.m_128441_("ShipStickerShip2Id")) {
                ship2 = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getAllShips().getById(compoundTag.m_128454_("ShipStickerShip2Id"));
            }
            if (compoundTag.m_128441_("ShipStickerShip2Vec")) {
                ship2Pos = new Vector3d((Vector3dc)StickerMovementBehaviour.readVector3D(compoundTag.m_128469_("ShipStickerShip2Vec")));
            }
            if (compoundTag.m_128441_("ShipStickerShip2Quat")) {
                ship2Rot = new Quaterniond((Quaterniondc)StickerMovementBehaviour.readQuatd(compoundTag.m_128469_("ShipStickerShip2Quat")));
            }
        }
        if ((constraint = StickerMovementBehaviour.makeConstraint(ship1Pos, ship2ConstraintPos, ship1, ship2, level, ship1Rot, ship2Rot, ship2Pos)) != null) {
            long groundId = (Long)VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).getDimensionToGroundBodyIdImmutable().get(VSGameUtilsKt.getDimensionId((Level)level));
            if (constraint.getShipId0() != groundId) {
                compoundTag.m_128356_("ShipStickerShip1Id", constraint.getShipId0());
            }
            if (constraint.getShipId1() != groundId) {
                compoundTag.m_128356_("ShipStickerShip2Id", constraint.getShipId1());
            }
            compoundTag.m_128365_("ShipStickerShip1Vec", (Tag)StickerMovementBehaviour.writeVector3D((Vector3d)constraint.getLocalPos0()));
            compoundTag.m_128365_("ShipStickerShip1Quat", (Tag)StickerMovementBehaviour.writeQuatd((Quaterniond)constraint.getLocalRot0()));
            compoundTag.m_128365_("ShipStickerShip2Vec", (Tag)StickerMovementBehaviour.writeVector3D((Vector3d)constraint.getLocalPos1()));
            compoundTag.m_128365_("ShipStickerShip2Quat", (Tag)StickerMovementBehaviour.writeQuatd((Quaterniond)constraint.getLocalRot1()));
            compoundTag.m_128347_("ShipStickerDistance", distance);
            Integer constraintID = VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).createNewConstraint((VSConstraint)constraint);
            compoundTag.m_128405_("ShipStickerConstraint", constraintID.intValue());
            new StickerParticleUtil().doBluperParticle((Level)level, BlockPos.m_274446_((Position)VectorConversionsMCKt.toMinecraft((Vector3dc)myPos)), ClockworkUtils.INSTANCE.fromNormal((int)adjustedDirNormal.x, (int)adjustedDirNormal.y, (int)adjustedDirNormal.z));
        }
    }

    public static void removeConstraint(@Nullable ServerLevel level, boolean removeTags, CompoundTag compoundTag) {
        if (compoundTag.m_128441_("ShipStickerConstraint")) {
            if (level != null) {
                VSGameUtilsKt.getShipObjectWorld((ServerLevel)level).removeConstraint(compoundTag.m_128451_("ShipStickerConstraint"));
            }
            if (removeTags) {
                compoundTag.m_128473_("ShipStickerConstraint");
                compoundTag.m_128473_("ShipStickerShip1Id");
                compoundTag.m_128473_("ShipStickerShip1Vec");
                compoundTag.m_128473_("ShipStickerShip1Quat");
                compoundTag.m_128473_("ShipStickerShip2Id");
                compoundTag.m_128473_("ShipStickerShip2Vec");
                compoundTag.m_128473_("ShipStickerShip2Quat");
            }
        }
    }
}

