/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.world;

import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.violetmoon.zeta.config.ZetaGeneralConfig;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.mod.ZetaMod;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.world.DeferredFeature;
import org.violetmoon.zeta.world.WeightedGenerator;
import org.violetmoon.zeta.world.generator.Generator;

public class WorldGenHandler {
    public static final Map<GenerationStep.Decoration, Holder<PlacedFeature>> defers = new EnumMap<GenerationStep.Decoration, Holder<PlacedFeature>>(GenerationStep.Decoration.class);
    public static final Map<GenerationStep.Decoration, SortedSet<WeightedGenerator>> generators = new EnumMap<GenerationStep.Decoration, SortedSet<WeightedGenerator>>(GenerationStep.Decoration.class);

    @LoadEvent
    public static void register(ZRegister event) {
        for (GenerationStep.Decoration stage : GenerationStep.Decoration.values()) {
            DeferredFeature deferredFeature = new DeferredFeature(stage);
            String name = "deferred_feature_" + stage.name().toLowerCase(Locale.ROOT);
            ZetaMod.ZETA.registry.register(deferredFeature, name, Registries.f_256833_);
            ConfiguredFeature feature = new ConfiguredFeature((Feature)deferredFeature, (FeatureConfiguration)FeatureConfiguration.f_67737_);
            Holder featureHolder = Holder.m_205709_((Object)feature);
            PlacedFeature placed = new PlacedFeature(featureHolder, List.of());
            Holder placedHolder = Holder.m_205709_((Object)placed);
            defers.put(stage, (Holder<PlacedFeature>)placedHolder);
        }
    }

    public static void addGenerator(ZetaModule module, Generator generator, GenerationStep.Decoration stage, int weight) {
        WeightedGenerator weighted = new WeightedGenerator(module, generator, weight);
        if (!generators.containsKey(stage)) {
            generators.put(stage, new TreeSet());
        }
        generators.get(stage).add(weighted);
    }

    public static void generateChunk(FeaturePlaceContext<NoneFeatureConfiguration> context, GenerationStep.Decoration stage) {
        WorldGenLevel level = context.m_159774_();
        if (!(level instanceof WorldGenRegion)) {
            return;
        }
        WorldGenRegion region = (WorldGenRegion)level;
        ChunkGenerator generator = context.m_159775_();
        BlockPos origin = context.m_159777_();
        BlockPos pos = new BlockPos(origin.m_123341_(), 0, origin.m_123343_());
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(region.m_7328_()));
        ChunkPos center = region.m_143488_();
        long seed = random.m_64690_(region.m_7328_(), center.f_45578_ * 16, center.f_45579_ * 16);
        int stageNum = stage.ordinal() * 10000;
        if (generators.containsKey(stage)) {
            SortedSet<WeightedGenerator> set = generators.get(stage);
            for (WeightedGenerator wgen : set) {
                Generator gen = wgen.generator();
                if (!wgen.module().enabled || !gen.canGenerate((ServerLevelAccessor)region)) continue;
                if (ZetaGeneralConfig.enableWorldgenWatchdog) {
                    int finalStageNum = stageNum;
                    stageNum = WorldGenHandler.watchdogRun(gen, () -> gen.generate(finalStageNum, seed, stage, region, generator, random, pos), 1, TimeUnit.MINUTES);
                    continue;
                }
                stageNum = gen.generate(stageNum, seed, stage, region, generator, random, pos);
            }
        }
    }

    private static int watchdogRun(Generator gen, Callable<Integer> run, int time, TimeUnit unit) {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        Future<Integer> future = exec.submit(run);
        exec.shutdown();
        try {
            return future.get(time, unit);
        }
        catch (Exception e) {
            throw new RuntimeException("Error generating " + gen, e);
        }
    }
}

