/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import de.maxhenkel.car.blocks.tileentity.TileEntitySplitTank;
import de.maxhenkel.car.corelib.inventory.ScreenBase;
import de.maxhenkel.car.gui.ContainerSplitTank;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;

public class GuiSplitTank
extends ScreenBase<ContainerSplitTank> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("car", "textures/gui/gui_split_tank.png");
    private Inventory playerInv;
    private TileEntitySplitTank tile;

    public GuiSplitTank(ContainerSplitTank containerSplitTank, Inventory playerInv, Component title) {
        super(GUI_TEXTURE, containerSplitTank, playerInv, title);
        this.playerInv = playerInv;
        this.tile = containerSplitTank.getSplitTank();
        this.f_97726_ = 176;
        this.f_97727_ = 166;
    }

    @Override
    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<FormattedCharSequence> list;
        super.m_280003_(guiGraphics, mouseX, mouseY);
        guiGraphics.m_280649_(this.f_96547_, this.playerInv.m_5446_().m_7532_(), 8, this.f_97727_ - 96 + 2, 0x404040, false);
        if (mouseX >= this.f_97735_ + 50 && mouseX <= this.f_97735_ + 16 + 50 && mouseY >= this.f_97736_ + 8 && mouseY <= this.f_97736_ + 57 + 8) {
            list = new ArrayList<FormattedCharSequence>();
            list.add(Component.m_237110_((String)"tooltip.mix", (Object[])new Object[]{this.tile.getCurrentMix()}).m_7532_());
            guiGraphics.m_280245_(this.f_96547_, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (mouseX >= this.f_97735_ + 120 && mouseX <= this.f_97735_ + 16 + 120 && mouseY >= this.f_97736_ + 8 && mouseY <= this.f_97736_ + 57 + 8) {
            list = new ArrayList();
            list.add(Component.m_237110_((String)"tooltip.glycerin", (Object[])new Object[]{this.tile.getCurrentGlycerin()}).m_7532_());
            guiGraphics.m_280245_(this.f_96547_, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (mouseX >= this.f_97735_ + 141 && mouseX <= this.f_97735_ + 16 + 141 && mouseY >= this.f_97736_ + 8 && mouseY <= this.f_97736_ + 57 + 8) {
            list = new ArrayList();
            list.add(Component.m_237110_((String)"tooltip.bio_diesel", (Object[])new Object[]{this.tile.getCurrentBioDiesel()}).m_7532_());
            guiGraphics.m_280245_(this.f_96547_, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        if (mouseX >= this.f_97735_ + 79 && mouseX <= this.f_97735_ + 24 + 79 && mouseY >= this.f_97736_ + 34 && mouseY <= this.f_97736_ + 17 + 34) {
            list = new ArrayList();
            list.add(Component.m_237110_((String)"tooltip.progress", (Object[])new Object[]{(int)(this.getProgress() * 100.0f)}).m_7532_());
            guiGraphics.m_280245_(this.f_96547_, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
        this.drawProgress(guiGraphics);
        this.drawMix(guiGraphics);
        this.drawBioDiesel(guiGraphics);
        this.drawGlycerin(guiGraphics);
    }

    public void drawGlycerin(GuiGraphics guiGraphics) {
        float perc = this.getGlycerin();
        int texX = 192;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 120;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.f_97735_;
        int j = this.f_97736_;
        guiGraphics.m_280218_(this.texture, i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawBioDiesel(GuiGraphics guiGraphics) {
        float perc = this.getBioDiesel();
        int texX = 208;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 141;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.f_97735_;
        int j = this.f_97736_;
        guiGraphics.m_280218_(this.texture, i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawMix(GuiGraphics guiGraphics) {
        float perc = this.getMix();
        int texX = 176;
        int texY = 17;
        int texW = 16;
        int texH = 57;
        int targetX = 50;
        int targetY = 8;
        int scHeight = (int)((float)texH * (1.0f - perc));
        int i = this.f_97735_;
        int j = this.f_97736_;
        guiGraphics.m_280218_(this.texture, i + targetX, j + targetY + scHeight, texX, texY + scHeight, texW, texH - scHeight);
    }

    public void drawProgress(GuiGraphics guiGraphics) {
        float perc = this.getProgress();
        int texX = 176;
        int texY = 0;
        int texW = 24;
        int texH = 17;
        int targetX = 79;
        int targetY = 34;
        int scWidth = (int)((float)texW * perc);
        int i = this.f_97735_;
        int j = this.f_97736_;
        guiGraphics.m_280218_(this.texture, i + targetX, j + targetY, texX, texY, scWidth, texH);
    }

    public float getMix() {
        return (float)this.tile.getCurrentMix() / (float)this.tile.maxMix;
    }

    public float getBioDiesel() {
        return (float)this.tile.getCurrentBioDiesel() / (float)this.tile.maxBioDiesel;
    }

    public float getGlycerin() {
        return (float)this.tile.getCurrentGlycerin() / (float)this.tile.maxGlycerin;
    }

    public float getProgress() {
        if (this.tile.getTimeToGenerate() == 0) {
            return 0.0f;
        }
        int time = this.tile.generatingTime - this.tile.getTimeToGenerate();
        return (float)time / (float)this.tile.generatingTime;
    }
}

