/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.game.ships;

import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.properties.ShipInertiaData;
import org.valkyrienskies.core.impl.game.ships.PhysInertia;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\b\u0018\u0000 B2\u00020\u0001:\u0001BB\u001f\u0012\u0006\u0010\u0012\u001a\u00020\n\u0012\u0006\u0010\u0013\u001a\u00020\u0002\u0012\u0006\u0010\u0014\u001a\u00020\u000f\u00a2\u0006\u0004\b@\u0010AJ/\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000b\u001a\u00020\nH\u00c2\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0002H\u00c2\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u000fH\u00c2\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J.\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0012\u001a\u00020\n2\b\b\u0002\u0010\u0013\u001a\u00020\u00022\b\b\u0002\u0010\u0014\u001a\u00020\u000fH\u00c6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0019\u001a\u00020\u00182\b\b\u0002\u0010\u0017\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001a\u0010\u001e\u001a\u00020\u001d2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0010\u0010!\u001a\u00020 H\u00d6\u0001\u00a2\u0006\u0004\b!\u0010\"J5\u0010(\u001a\u00020\u00072\u0006\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u0002\u00a2\u0006\u0004\b(\u0010)J5\u0010*\u001a\u00020\u00072\u0006\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u0002\u00a2\u0006\u0004\b*\u0010)J\u0010\u0010,\u001a\u00020+H\u00d6\u0001\u00a2\u0006\u0004\b,\u0010-J\u000f\u0010.\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b.\u0010/R\u0014\u0010\u0012\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u00100R\u0016\u0010\u0013\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u00101R\u0014\u0010\u0014\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u00102R\u0014\u00106\u001a\u0002038WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0014\u00108\u001a\u00020\u00028WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u000eR\u0016\u00109\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u00102R\u0014\u0010=\u001a\u00020:8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0014\u0010?\u001a\u00020:8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010<"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/ShipInertiaDataImpl;", "Lorg/valkyrienskies/core/api/ships/properties/ShipInertiaData;", "", "x", "y", "z", "addedMass", "", "addMassAt", "(DDDD)V", "Lorg/joml/Vector3d;", "component1", "()Lorg/joml/Vector3d;", "component2", "()D", "Lorg/joml/Matrix3d;", "component3", "()Lorg/joml/Matrix3d;", "_centerOfMassInShip", "_mass", "_momentOfInertiaTensor", "copy", "(Lorg/joml/Vector3d;DLorg/joml/Matrix3d;)Lorg/valkyrienskies/core/impl/game/ships/ShipInertiaDataImpl;", "scaling", "Lorg/valkyrienskies/core/impl/game/ships/PhysInertia;", "copyToPhyInertia", "(D)Lorg/valkyrienskies/core/impl/game/ships/PhysInertia;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "posX", "posY", "posZ", "oldBlockMass", "newBlockMass", "onSetBlock", "(IIIDD)V", "onSetBlockUseSphereMOI", "", "toString", "()Ljava/lang/String;", "updateSphericalMOI", "()V", "Lorg/joml/Vector3d;", "D", "Lorg/joml/Matrix3d;", "Lorg/joml/Vector3dc;", "getCenterOfMassInShip", "()Lorg/joml/Vector3dc;", "centerOfMassInShip", "getMass", "mass", "momentOfInertiaSpherical", "Lorg/joml/Matrix3dc;", "getMomentOfInertiaTensor", "()Lorg/joml/Matrix3dc;", "momentOfInertiaTensor", "getMomentOfInertiaTensorToSave", "momentOfInertiaTensorToSave", "<init>", "(Lorg/joml/Vector3d;DLorg/joml/Matrix3d;)V", "Companion"})
public final class ShipInertiaDataImpl
implements ShipInertiaData {
    public static final Companion Companion = new Companion(null);
    private final Vector3d _centerOfMassInShip;
    private double _mass;
    private final Matrix3d _momentOfInertiaTensor;
    private Matrix3d momentOfInertiaSpherical;
    private static final double EPSILON = 1.0E-6;
    private static final double INERTIA_OFFSET = 0.4;

    public ShipInertiaDataImpl(Vector3d _centerOfMassInShip, double _mass, Matrix3d _momentOfInertiaTensor) {
        Intrinsics.checkNotNullParameter((Object)_centerOfMassInShip, (String)"");
        Intrinsics.checkNotNullParameter((Object)_momentOfInertiaTensor, (String)"");
        this._centerOfMassInShip = _centerOfMassInShip;
        this._mass = _mass;
        this._momentOfInertiaTensor = _momentOfInertiaTensor;
        this.momentOfInertiaSpherical = new Matrix3d((Matrix3dc)this._momentOfInertiaTensor);
        this.updateSphericalMOI();
    }

    @JvmName(name="getMomentOfInertiaTensor")
    public Matrix3dc getMomentOfInertiaTensor() {
        return (Matrix3dc)this.momentOfInertiaSpherical;
    }

    @JvmName(name="getMomentOfInertiaTensorToSave")
    public Matrix3dc getMomentOfInertiaTensorToSave() {
        return (Matrix3dc)this._momentOfInertiaTensor;
    }

    @JvmName(name="getCenterOfMassInShip")
    public Vector3dc getCenterOfMassInShip() {
        return (Vector3dc)this._centerOfMassInShip;
    }

    @JvmName(name="getMass")
    public double getMass() {
        return this._mass;
    }

    public final void onSetBlock(int posX, int posY, int posZ, double oldBlockMass, double newBlockMass) {
        double d2 = newBlockMass - oldBlockMass;
        if (Math.abs(d2) < 1.0E-6) {
            return;
        }
        double d3 = d2 / 8.0;
        this.addMassAt((double)posX + 0.4, (double)posY + 0.4, (double)posZ + 0.4, d3);
        this.addMassAt((double)posX + 0.4, (double)posY + 0.4, (double)posZ - 0.4, d3);
        this.addMassAt((double)posX + 0.4, (double)posY - 0.4, (double)posZ + 0.4, d3);
        this.addMassAt((double)posX + 0.4, (double)posY - 0.4, (double)posZ - 0.4, d3);
        this.addMassAt((double)posX - 0.4, (double)posY + 0.4, (double)posZ + 0.4, d3);
        this.addMassAt((double)posX - 0.4, (double)posY + 0.4, (double)posZ - 0.4, d3);
        this.addMassAt((double)posX - 0.4, (double)posY - 0.4, (double)posZ + 0.4, d3);
        this.addMassAt((double)posX - 0.4, (double)posY - 0.4, (double)posZ - 0.4, d3);
    }

    public final void onSetBlockUseSphereMOI(int posX, int posY, int posZ, double oldBlockMass, double newBlockMass) {
        this.onSetBlock(posX, posY, posZ, oldBlockMass, newBlockMass);
        this.updateSphericalMOI();
    }

    private final void updateSphericalMOI() {
        double d2 = this._momentOfInertiaTensor.transform(new Vector3d(1.0, 0.0, 0.0)).length();
        double d3 = this._momentOfInertiaTensor.transform(new Vector3d(0.0, 1.0, 0.0)).length();
        double d4 = this._momentOfInertiaTensor.transform(new Vector3d(0.0, 0.0, 1.0)).length();
        double d5 = (d2 + d3 + d4) / 3.0;
        this.momentOfInertiaSpherical.identity().scale(d5);
    }

    private final void addMassAt(double x2, double y2, double z2, double addedMass) {
        double[] dArray = new double[9];
        Matrix3d matrix3d = this._momentOfInertiaTensor.transpose(new Matrix3d());
        Intrinsics.checkNotNullExpressionValue((Object)matrix3d, (String)"");
        Matrix3d matrix3d2 = matrix3d;
        matrix3d2.get(dArray);
        double d2 = this.getMass();
        Vector3d vector3d = new Vector3d(this.getCenterOfMassInShip());
        if (d2 + addedMass > 1.0E-6) {
            Vector3d vector3d2 = this.getCenterOfMassInShip().mul(d2, new Vector3d());
            Intrinsics.checkNotNullExpressionValue((Object)vector3d2, (String)"");
            Vector3d vector3d3 = vector3d2;
            vector3d3.add(x2 * addedMass, y2 * addedMass, z2 * addedMass);
            vector3d3.mul(1.0 / (d2 + addedMass));
            this._centerOfMassInShip.set((Vector3dc)vector3d3);
            double d3 = vector3d.x - this.getCenterOfMassInShip().x();
            double d4 = vector3d.y - this.getCenterOfMassInShip().y();
            double d5 = vector3d.z - this.getCenterOfMassInShip().z();
            double d6 = x2 - this.getCenterOfMassInShip().x();
            double d7 = y2 - this.getCenterOfMassInShip().y();
            double d8 = z2 - this.getCenterOfMassInShip().z();
            dArray[0] = dArray[0] + (d4 * d4 + d5 * d5) * d2 + (d7 * d7 + d8 * d8) * addedMass;
            dArray[1] = dArray[1] - d3 * d4 * d2 - d6 * d7 * addedMass;
            dArray[2] = dArray[2] - d3 * d5 * d2 - d6 * d8 * addedMass;
            dArray[3] = dArray[1];
            dArray[4] = dArray[4] + (d3 * d3 + d5 * d5) * d2 + (d6 * d6 + d8 * d8) * addedMass;
            dArray[5] = dArray[5] - d4 * d5 * d2 - d7 * d8 * addedMass;
            dArray[6] = dArray[2];
            dArray[7] = dArray[5];
            dArray[8] = dArray[8] + (d3 * d3 + d4 * d4) * d2 + (d6 * d6 + d7 * d7) * addedMass;
            this._momentOfInertiaTensor.set(dArray).transpose();
            this._mass += addedMass;
        } else {
            this._centerOfMassInShip.set(x2, y2, z2);
            this._momentOfInertiaTensor.zero();
            this._mass = 0.0;
        }
    }

    public final PhysInertia copyToPhyInertia(double scaling) {
        double d2 = this.getMass() * scaling * scaling * scaling;
        Matrix3d matrix3d = new Matrix3d((Matrix3dc)this.momentOfInertiaSpherical).scale(scaling * scaling * scaling * scaling * scaling);
        Intrinsics.checkNotNullExpressionValue((Object)matrix3d, (String)"");
        return new PhysInertia(d2, (Matrix3dc)matrix3d);
    }

    public static /* synthetic */ PhysInertia copyToPhyInertia$default(ShipInertiaDataImpl shipInertiaDataImpl, double d2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            d2 = 1.0;
        }
        return shipInertiaDataImpl.copyToPhyInertia(d2);
    }

    private final Vector3d component1() {
        return this._centerOfMassInShip;
    }

    private final double component2() {
        return this._mass;
    }

    private final Matrix3d component3() {
        return this._momentOfInertiaTensor;
    }

    public final ShipInertiaDataImpl copy(Vector3d _centerOfMassInShip, double _mass, Matrix3d _momentOfInertiaTensor) {
        Intrinsics.checkNotNullParameter((Object)_centerOfMassInShip, (String)"");
        Intrinsics.checkNotNullParameter((Object)_momentOfInertiaTensor, (String)"");
        return new ShipInertiaDataImpl(_centerOfMassInShip, _mass, _momentOfInertiaTensor);
    }

    public static /* synthetic */ ShipInertiaDataImpl copy$default(ShipInertiaDataImpl shipInertiaDataImpl, Vector3d vector3d, double d2, Matrix3d matrix3d, int n2, Object object) {
        if ((n2 & 1) != 0) {
            vector3d = shipInertiaDataImpl._centerOfMassInShip;
        }
        if ((n2 & 2) != 0) {
            d2 = shipInertiaDataImpl._mass;
        }
        if ((n2 & 4) != 0) {
            matrix3d = shipInertiaDataImpl._momentOfInertiaTensor;
        }
        return shipInertiaDataImpl.copy(vector3d, d2, matrix3d);
    }

    public String toString() {
        return "ShipInertiaDataImpl(_centerOfMassInShip=" + this._centerOfMassInShip + ", _mass=" + this._mass + ", _momentOfInertiaTensor=" + this._momentOfInertiaTensor + ')';
    }

    public int hashCode() {
        int n2 = this._centerOfMassInShip.hashCode();
        n2 = n2 * 31 + Double.hashCode(this._mass);
        n2 = n2 * 31 + this._momentOfInertiaTensor.hashCode();
        return n2;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ShipInertiaDataImpl)) {
            return false;
        }
        ShipInertiaDataImpl shipInertiaDataImpl = (ShipInertiaDataImpl)other;
        if (!Intrinsics.areEqual((Object)this._centerOfMassInShip, (Object)shipInertiaDataImpl._centerOfMassInShip)) {
            return false;
        }
        if (Double.compare(this._mass, shipInertiaDataImpl._mass) != 0) {
            return false;
        }
        return Intrinsics.areEqual((Object)this._momentOfInertiaTensor, (Object)shipInertiaDataImpl._momentOfInertiaTensor);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0007"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/ShipInertiaDataImpl$Companion;", "", "Lorg/valkyrienskies/core/impl/game/ships/ShipInertiaDataImpl;", "newEmptyShipInertiaData", "()Lorg/valkyrienskies/core/impl/game/ships/ShipInertiaDataImpl;", "", "EPSILON", "D", "INERTIA_OFFSET", "<init>", "()V"})
    public static final class Companion {
        private Companion() {
        }

        public final ShipInertiaDataImpl newEmptyShipInertiaData() {
            return new ShipInertiaDataImpl(new Vector3d(), 0.0, new Matrix3d());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

