/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.networking;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.apache.logging.log4j.Logger;
import org.valkyrienskies.core.apigame.world.IPlayer;
import org.valkyrienskies.core.impl.game.ships.ShipObjectServerWorld;
import org.valkyrienskies.core.impl.hooks.CoreHooksImplKt;
import org.valkyrienskies.core.impl.networking.ClientHandler;
import org.valkyrienskies.core.impl.networking.Packet;
import org.valkyrienskies.core.impl.networking.PacketType;
import org.valkyrienskies.core.impl.networking.RegisteredHandler;
import org.valkyrienskies.core.impl.networking.ServerHandler;
import org.valkyrienskies.core.impl.util.ClassLogger;
import org.valkyrienskies.core.impl.util.LoggingKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 U2\u00020\u0001:\u0001UB\u0007\u00a2\u0006\u0004\bT\u0010\tJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0004\b\r\u0010\tJ\u0015\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010 \u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001f\u00a2\u0006\u0004\b \u0010!J\u0015\u0010$\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b$\u0010%J\u001d\u0010&\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001f\u00a2\u0006\u0004\b&\u0010'J\u0015\u0010(\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0004\b(\u0010\fJ\u001d\u0010)\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b)\u0010*J)\u0010-\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00042\u0012\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100+\"\u00020\u0010\u00a2\u0006\u0004\b-\u0010.J\u0015\u0010/\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0004\b/\u0010\fJ\r\u00100\u001a\u00020\u0007\u00a2\u0006\u0004\b0\u0010\tJ\u001f\u00101\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b1\u0010*R \u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001803028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105R$\u00108\u001a\u0012\u0012\u0004\u0012\u00020\u000406j\b\u0012\u0004\u0012\u00020\u0004`78\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u00109R\u0016\u0010;\u001a\u00020:8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b;\u0010<R$\u0010?\u001a\u0012\u0012\u0004\u0012\u00020\u00180=j\b\u0012\u0004\u0012\u00020\u0018`>8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b?\u0010@R$\u0010A\u001a\u0012\u0012\u0004\u0012\u00020\u001f0=j\b\u0012\u0004\u0012\u00020\u001f`>8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bA\u0010@R$\u0010B\u001a\u0012\u0012\u0004\u0012\u00020\u001606j\b\u0012\u0004\u0012\u00020\u0016`78\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bB\u00109RV\u0010E\u001a6\u0012\u0015\u0012\u0013\u0018\u00010\u0002\u00a2\u0006\f\bD\u0012\b\b#\u0012\u0004\b\b(\u0003\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\bD\u0012\b\b#\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00070C8\u0007@\u0007X\u0086.\u00a2\u0006\u0012\n\u0004\bE\u0010F\u001a\u0004\bG\u0010H\"\u0004\bI\u0010JR?\u0010L\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0002\u00a2\u0006\f\bD\u0012\b\b#\u0012\u0004\b\b(\u0003\u0012\u0004\u0012\u00020\u00070K8\u0007@\u0007X\u0086.\u00a2\u0006\u0012\n\u0004\bL\u0010M\u001a\u0004\bN\u0010O\"\u0004\bP\u0010QR \u0010R\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f03028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bR\u00105R\u0016\u0010S\u001a\u00020:8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bS\u0010<"}, d2={"Lorg/valkyrienskies/core/impl/networking/NetworkChannel;", "", "Lio/netty/buffer/ByteBuf;", "data", "Lorg/valkyrienskies/core/impl/networking/Packet;", "bytesToPacket", "(Lio/netty/buffer/ByteBuf;)Lorg/valkyrienskies/core/impl/networking/Packet;", "", "clientIsReady", "()V", "packet", "clientReceive", "(Lorg/valkyrienskies/core/impl/networking/Packet;)V", "disable", "onReceiveClient", "(Lio/netty/buffer/ByteBuf;)V", "Lorg/valkyrienskies/core/apigame/world/IPlayer;", "player", "onReceiveServer", "(Lio/netty/buffer/ByteBuf;Lorg/valkyrienskies/core/apigame/world/IPlayer;)V", "packetToBytes", "(Lorg/valkyrienskies/core/impl/networking/Packet;)Lio/netty/buffer/ByteBuf;", "Lorg/valkyrienskies/core/impl/networking/PacketType;", "packetType", "Lorg/valkyrienskies/core/impl/networking/ClientHandler;", "handler", "Lorg/valkyrienskies/core/impl/networking/RegisteredHandler;", "registerClientHandler", "(Lorg/valkyrienskies/core/impl/networking/PacketType;Lorg/valkyrienskies/core/impl/networking/ClientHandler;)Lorg/valkyrienskies/core/impl/networking/RegisteredHandler;", "registerGlobalClientHandler", "(Lorg/valkyrienskies/core/impl/networking/ClientHandler;)Lorg/valkyrienskies/core/impl/networking/RegisteredHandler;", "Lorg/valkyrienskies/core/impl/networking/ServerHandler;", "registerGlobalServerHandler", "(Lorg/valkyrienskies/core/impl/networking/ServerHandler;)Lorg/valkyrienskies/core/impl/networking/RegisteredHandler;", "", "name", "registerPacket", "(Ljava/lang/String;)Lorg/valkyrienskies/core/impl/networking/PacketType;", "registerServerHandler", "(Lorg/valkyrienskies/core/impl/networking/PacketType;Lorg/valkyrienskies/core/impl/networking/ServerHandler;)Lorg/valkyrienskies/core/impl/networking/RegisteredHandler;", "sendToAllClients", "sendToClient", "(Lorg/valkyrienskies/core/impl/networking/Packet;Lorg/valkyrienskies/core/apigame/world/IPlayer;)V", "", "players", "sendToClients", "(Lorg/valkyrienskies/core/impl/networking/Packet;[Lorg/valkyrienskies/core/apigame/world/IPlayer;)V", "sendToServer", "serverIsReady", "serverReceive", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "", "clientHandlers", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "Ljava/util/ArrayList;", "Lkotlin/collections/a;", "clientQueue", "Ljava/util/ArrayList;", "", "clientReady", "Z", "Ljava/util/HashSet;", "Lkotlin/collections/c;", "globalClientHandlers", "Ljava/util/HashSet;", "globalServerHandlers", "packetTypes", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "rawSendToClient", "Lkotlin/jvm/functions/Function2;", "getRawSendToClient", "()Lkotlin/jvm/functions/Function2;", "setRawSendToClient", "(Lkotlin/jvm/functions/Function2;)V", "Lkotlin/Function1;", "rawSendToServer", "Lkotlin/jvm/functions/Function1;", "getRawSendToServer", "()Lkotlin/jvm/functions/Function1;", "setRawSendToServer", "(Lkotlin/jvm/functions/Function1;)V", "serverHandlers", "serverReady", "<init>", "Companion"})
public final class NetworkChannel {
    public static final Companion Companion = new Companion(null);
    private final ArrayList<PacketType> packetTypes = new ArrayList();
    private final Int2ObjectOpenHashMap<Set<ServerHandler>> serverHandlers = new Int2ObjectOpenHashMap();
    private final Int2ObjectOpenHashMap<Set<ClientHandler>> clientHandlers = new Int2ObjectOpenHashMap();
    private final HashSet<ServerHandler> globalServerHandlers = new HashSet();
    private final HashSet<ClientHandler> globalClientHandlers = new HashSet();
    private boolean clientReady;
    private boolean serverReady;
    private final ArrayList<Packet> clientQueue = new ArrayList();
    public Function1<? super ByteBuf, Unit> rawSendToServer;
    public Function2<? super ByteBuf, ? super IPlayer, Unit> rawSendToClient;
    private static final Logger logger$delegate = LoggingKt.logger().provideDelegate-4Hzib3M(Companion, org.valkyrienskies.core.impl.networking.NetworkChannel$Companion.$$delegatedProperties[0]);

    public final PacketType registerPacket(String name) {
        PacketType packetType;
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        PacketType packetType2 = packetType = new PacketType(this, this.packetTypes.size(), name);
        boolean bl2 = false;
        this.packetTypes.add(packetType2);
        return packetType;
    }

    public final RegisteredHandler registerGlobalServerHandler(ServerHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"");
        this.globalServerHandlers.add(handler);
        return () -> NetworkChannel.registerGlobalServerHandler$lambda$1(this, handler);
    }

    public final RegisteredHandler registerGlobalClientHandler(ClientHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"");
        this.globalClientHandlers.add(handler);
        return () -> NetworkChannel.registerGlobalClientHandler$lambda$2(this, handler);
    }

    public final RegisteredHandler registerServerHandler(PacketType packetType, ServerHandler handler) {
        Intrinsics.checkNotNullParameter((Object)packetType, (String)"");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"");
        ((Set)this.serverHandlers.computeIfAbsent(packetType.getId(), NetworkChannel::registerServerHandler$lambda$3)).add(handler);
        return () -> NetworkChannel.registerServerHandler$lambda$4(this, packetType, handler);
    }

    public final RegisteredHandler registerClientHandler(PacketType packetType, ClientHandler handler) {
        Intrinsics.checkNotNullParameter((Object)packetType, (String)"");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"");
        ((Set)this.clientHandlers.computeIfAbsent(packetType.getId(), NetworkChannel::registerClientHandler$lambda$5)).add(handler);
        return () -> NetworkChannel.registerClientHandler$lambda$6(this, packetType, handler);
    }

    public final void onReceiveClient(ByteBuf data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"");
        Packet packet = this.bytesToPacket(data);
        if (this.clientReady) {
            this.clientReceive(packet);
        } else {
            Packet packet2;
            Packet packet3 = packet2 = packet;
            ArrayList<Packet> arrayList = this.clientQueue;
            boolean bl2 = false;
            packet.getData().retain();
            arrayList.add(packet2);
        }
    }

    private final void clientReceive(Packet packet) {
        boolean bl2;
        ClientHandler clientHandler;
        Set set = (Set)this.clientHandlers.get(packet.getType().getId());
        Companion.getLogger().debug("Client received packet of type: " + packet.getType());
        Iterable iterable = this.globalClientHandlers;
        boolean bl3 = false;
        for (Object t2 : iterable) {
            clientHandler = (ClientHandler)t2;
            bl2 = false;
            clientHandler.handlePacket(packet);
        }
        Set set2 = set;
        if (set2 != null) {
            iterable = set2;
            bl3 = false;
            for (Object t2 : iterable) {
                clientHandler = (ClientHandler)t2;
                bl2 = false;
                clientHandler.handlePacket(packet);
            }
        }
        if (this.globalClientHandlers.isEmpty() && (set == null || set.isEmpty())) {
            Companion.getLogger().warn("Received a packet " + packet.getType().getName() + " on the client, but no handlers were registered");
        }
    }

    public final void onReceiveServer(ByteBuf data, IPlayer player) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"");
        Intrinsics.checkNotNullParameter((Object)player, (String)"");
        Packet packet = this.bytesToPacket(data);
        if (this.serverReady) {
            this.serverReceive(packet, player);
        }
    }

    private final void serverReceive(Packet packet, IPlayer player) {
        boolean bl2;
        ServerHandler serverHandler;
        Set set = (Set)this.serverHandlers.get(packet.getType().getId());
        Companion.getLogger().debug("Server received packet of type: " + packet.getType());
        Iterable iterable = this.globalServerHandlers;
        boolean bl3 = false;
        for (Object t2 : iterable) {
            serverHandler = (ServerHandler)t2;
            bl2 = false;
            serverHandler.handlePacket(packet, player);
        }
        Set set2 = set;
        if (set2 != null) {
            iterable = set2;
            bl3 = false;
            for (Object t2 : iterable) {
                serverHandler = (ServerHandler)t2;
                bl2 = false;
                serverHandler.handlePacket(packet, player);
            }
        }
        if (this.globalServerHandlers.isEmpty() && (set == null || set.isEmpty())) {
            Companion.getLogger().warn("Received a packet " + packet.getType().getName() + " on the server, but no handlers were registered");
        }
    }

    private final Packet bytesToPacket(ByteBuf data) {
        int n2 = data.readInt();
        PacketType packetType = this.packetTypes.get(n2);
        Intrinsics.checkNotNullExpressionValue((Object)packetType, (String)"");
        PacketType packetType2 = packetType;
        return new Packet(packetType2, data);
    }

    private final ByteBuf packetToBytes(Packet packet) {
        ByteBuf[] byteBufArray;
        CompositeByteBuf compositeByteBuf = Unpooled.compositeBuffer((int)2);
        ByteBuf[] byteBufArray2 = byteBufArray = Unpooled.buffer((int)4);
        boolean bl2 = false;
        byteBufArray2.writeInt(packet.getType().getId());
        ByteBuf[] byteBufArray3 = byteBufArray;
        byteBufArray2 = new ByteBuf[]{byteBufArray3, packet.getData()};
        CompositeByteBuf compositeByteBuf2 = compositeByteBuf.addComponents(true, byteBufArray2);
        Intrinsics.checkNotNullExpressionValue((Object)compositeByteBuf2, (String)"");
        return (ByteBuf)compositeByteBuf2;
    }

    public final void sendToServer(Packet packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"");
        this.getRawSendToServer().invoke((Object)this.packetToBytes(packet));
    }

    public final void sendToClient(Packet packet, IPlayer player) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"");
        Intrinsics.checkNotNullParameter((Object)player, (String)"");
        this.getRawSendToClient().invoke((Object)this.packetToBytes(packet), (Object)player);
    }

    public final void sendToClients(Packet packet, IPlayer ... players) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"");
        Intrinsics.checkNotNullParameter((Object)players, (String)"");
        IPlayer[] iPlayerArray = players;
        boolean bl2 = false;
        int n2 = iPlayerArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            IPlayer iPlayer;
            IPlayer iPlayer2 = iPlayer = iPlayerArray[i2];
            boolean bl3 = false;
            this.sendToClient(packet, iPlayer2);
        }
    }

    public final void sendToAllClients(Packet packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"");
        ShipObjectServerWorld shipObjectServerWorld = (ShipObjectServerWorld)CoreHooksImplKt.getCoreHooks().getCurrentShipServerWorld();
        if (shipObjectServerWorld == null) {
            boolean bl2 = false;
            String string = "Tried to send a packet of type " + packet.getType() + " to all clients, but there is no server currently running!";
            throw new IllegalArgumentException(string.toString());
        }
        ShipObjectServerWorld shipObjectServerWorld2 = shipObjectServerWorld;
        Iterable iterable = shipObjectServerWorld2.getPlayers();
        boolean bl3 = false;
        for (Object t2 : iterable) {
            IPlayer iPlayer = (IPlayer)t2;
            boolean bl4 = false;
            this.sendToClient(packet, iPlayer);
        }
    }

    @JvmName(name="getRawSendToServer")
    public final Function1<ByteBuf, Unit> getRawSendToServer() {
        Function1<? super ByteBuf, Unit> function1 = this.rawSendToServer;
        if (function1 != null) {
            return function1;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"");
        return null;
    }

    @JvmName(name="setRawSendToServer")
    public final void setRawSendToServer(Function1<? super ByteBuf, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"");
        this.rawSendToServer = function1;
    }

    @JvmName(name="getRawSendToClient")
    public final Function2<ByteBuf, IPlayer, Unit> getRawSendToClient() {
        Function2<? super ByteBuf, ? super IPlayer, Unit> function2 = this.rawSendToClient;
        if (function2 != null) {
            return function2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"");
        return null;
    }

    @JvmName(name="setRawSendToClient")
    public final void setRawSendToClient(Function2<? super ByteBuf, ? super IPlayer, Unit> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"");
        this.rawSendToClient = function2;
    }

    public final void serverIsReady() {
        this.serverReady = true;
    }

    public final void clientIsReady() {
        this.clientReady = true;
        Iterable iterable = this.clientQueue;
        boolean bl2 = false;
        for (Object t2 : iterable) {
            Packet packet = (Packet)t2;
            boolean bl3 = false;
            this.clientReceive(packet);
            packet.getData().release();
        }
        this.clientQueue.clear();
    }

    public final void disable() {
        this.serverReady = false;
        this.clientReady = false;
    }

    private static final void registerGlobalServerHandler$lambda$1(NetworkChannel this$0, ServerHandler $handler) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"");
        Intrinsics.checkNotNullParameter((Object)$handler, (String)"");
        this$0.globalServerHandlers.remove($handler);
    }

    private static final void registerGlobalClientHandler$lambda$2(NetworkChannel this$0, ClientHandler $handler) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"");
        Intrinsics.checkNotNullParameter((Object)$handler, (String)"");
        this$0.globalClientHandlers.remove($handler);
    }

    private static final HashSet registerServerHandler$lambda$3(int it2) {
        return new HashSet();
    }

    private static final void registerServerHandler$lambda$4(NetworkChannel this$0, PacketType $packetType, ServerHandler $handler) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"");
            Intrinsics.checkNotNullParameter((Object)$packetType, (String)"");
            Intrinsics.checkNotNullParameter((Object)$handler, (String)"");
            Set set = (Set)this$0.serverHandlers.get($packetType.getId());
            if (set == null) break block0;
            set.remove($handler);
        }
    }

    private static final HashSet registerClientHandler$lambda$5(int it2) {
        return new HashSet();
    }

    private static final void registerClientHandler$lambda$6(NetworkChannel this$0, PacketType $packetType, ClientHandler $handler) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"");
            Intrinsics.checkNotNullParameter((Object)$packetType, (String)"");
            Intrinsics.checkNotNullParameter((Object)$handler, (String)"");
            Set set = (Set)this$0.clientHandlers.get($packetType.getId());
            if (set == null) break block0;
            set.remove($handler);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\b\u0010\tR\u001b\u0010\u0007\u001a\u00020\u00028GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006"}, d2={"Lorg/valkyrienskies/core/impl/networking/NetworkChannel$Companion;", "", "Lorg/apache/logging/log4j/Logger;", "logger$delegate", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "logger", "<init>", "()V"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @JvmName(name="getLogger")
        public final Logger getLogger() {
            return ClassLogger.getValue-impl(logger$delegate, this, $$delegatedProperties[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "logger", "getLogger()Lorg/apache/logging/log4j/Logger;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

