/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.item;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.util.datastructures.DenseBlockPosSet;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.assembly.ShipAssemblyKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/valkyrienskies/mod/common/item/ShipAssemblerItem;", "Lnet/minecraft/world/item/Item;", "Lnet/minecraft/world/item/context/UseOnContext;", "ctx", "Lnet/minecraft/world/InteractionResult;", "useOn", "(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/world/item/Item$Properties;", "properties", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "valkyrienskies-120"})
public final class ShipAssemblerItem
extends Item {
    public ShipAssemblerItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Level level = ctx.m_43725_();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            InteractionResult interactionResult = super.m_6225_(ctx);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useOn(...)");
            return interactionResult;
        }
        ServerLevel level2 = serverLevel;
        BlockPos pos = ctx.m_8083_();
        BlockState blockState = level2.m_8055_(pos);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
        BlockState blockState2 = blockState;
        if (!level2.f_46443_) {
            Level level3 = ctx.m_43725_();
            Intrinsics.checkNotNullExpressionValue((Object)level3, (String)"getLevel(...)");
            if (VSGameUtilsKt.isChunkInShipyard(level3, pos.m_123341_() >> 4, pos.m_123343_() >> 4)) {
                Player player = ctx.m_43723_();
                if (player != null) {
                    player.m_213846_((Component)Component.m_237113_((String)"That chunk is already part of a ship!"));
                }
            } else if (!blockState2.m_60795_()) {
                DenseBlockPosSet set = new DenseBlockPosSet();
                for (int x2 = -3; x2 < 4; ++x2) {
                    for (int z2 = -3; z2 < 4; ++z2) {
                        set.add(pos.m_123341_() + x2, pos.m_123342_(), pos.m_123343_() + z2);
                    }
                }
                Intrinsics.checkNotNull((Object)pos);
                ServerShip shipData = ShipAssemblyKt.createNewShipWithBlocks(pos, set, level2);
                Player player = ctx.m_43723_();
                if (player != null) {
                    player.m_213846_((Component)Component.m_237113_((String)"SHIPIFIED!"));
                }
            }
        }
        InteractionResult interactionResult = super.m_6225_(ctx);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useOn(...)");
        return interactionResult;
    }
}

