/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin;

import com.llamalad7.mixinextras.MixinExtrasBootstrap;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.Mixins;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.valkyrienskies.mod.compat.VSRenderer;

public class ValkyrienCommonMixinConfigPlugin
implements IMixinConfigPlugin {
    private static final boolean PATH_FINDING_DEBUG = "true".equals(System.getProperty("org.valkyrienskies.render_pathfinding"));
    private static VSRenderer vsRenderer = null;

    public static VSRenderer getVSRenderer() {
        if (vsRenderer == null) {
            vsRenderer = ValkyrienCommonMixinConfigPlugin.getVSRendererHelper();
        }
        return vsRenderer;
    }

    private static VSRenderer getVSRendererHelper() {
        if (ValkyrienCommonMixinConfigPlugin.classExists("optifine.OptiFineTransformationService")) {
            return VSRenderer.OPTIFINE;
        }
        if (ValkyrienCommonMixinConfigPlugin.classExists("me.jellysquid.mods.sodium.client.SodiumClientMod")) {
            return VSRenderer.SODIUM;
        }
        return VSRenderer.VANILLA;
    }

    private static boolean classExists(String className) {
        try {
            Class.forName(className, false, ValkyrienCommonMixinConfigPlugin.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException ex2) {
            return false;
        }
    }

    public void onLoad(String s2) {
        MixinExtrasBootstrap.init();
        Mixins.registerErrorHandlerClass((String)"org.valkyrienskies.mod.mixin.ValkyrienMixinErrorHandler");
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String s2, String mixinClassName) {
        VSRenderer renderer = ValkyrienCommonMixinConfigPlugin.getVSRenderer();
        if (mixinClassName.contains("org.valkyrienskies.mod.mixin.mod_compat.sodium")) {
            return renderer == VSRenderer.SODIUM;
        }
        if (mixinClassName.contains("org.valkyrienskies.mod.mixin.mod_compat.optifine_vanilla")) {
            return renderer == VSRenderer.VANILLA || renderer == VSRenderer.OPTIFINE;
        }
        if (mixinClassName.contains("org.valkyrienskies.mod.mixin.mod_compat.vanilla_renderer")) {
            return renderer == VSRenderer.VANILLA;
        }
        if (mixinClassName.contains("org.valkyrienskies.mod.mixin.mod_compat.optifine")) {
            return renderer == VSRenderer.OPTIFINE;
        }
        if (mixinClassName.contains("org.valkyrienskies.mod.mixin.feature.render_pathfinding")) {
            return PATH_FINDING_DEBUG;
        }
        return true;
    }

    public void acceptTargets(Set<String> set, Set<String> set1) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String s2, ClassNode classNode, String s1, IMixinInfo iMixinInfo) {
    }

    public void postApply(String s2, ClassNode classNode, String s1, IMixinInfo iMixinInfo) {
    }
}

