/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.mod_compat.create;

import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.fan.IAirCurrentSource;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.common.world.RaycastUtilsKt;
import org.valkyrienskies.mod.mixinducks.mod_compat.create.IExtendedAirCurrentSource;

@Mixin(value={AirCurrent.class})
public abstract class MixinAirCurrent {
    @Unique
    private final float maxAcceleration = 5.0f;
    @Shadow
    @Final
    public IAirCurrentSource source;
    @Unique
    private Vec3 transformedFlow = Vec3.f_82478_;
    @Unique
    private float acceleration;

    @Unique
    private Ship getShip() {
        IAirCurrentSource iAirCurrentSource = this.source;
        if (iAirCurrentSource instanceof IExtendedAirCurrentSource) {
            IExtendedAirCurrentSource se2 = (IExtendedAirCurrentSource)iAirCurrentSource;
            return se2.getShip();
        }
        if (this.source.getAirCurrentWorld() != null) {
            return VSGameUtilsKt.getShipManagingPos(this.source.getAirCurrentWorld(), this.source.getAirCurrentPos());
        }
        return null;
    }

    @Inject(method={"getFlowLimit"}, at={@At(value="HEAD")}, cancellable=true)
    private static void clipFlowLimit(Level level, BlockPos start, float max, Direction facing, CallbackInfoReturnable<Float> cir) {
        Ship ship = VSGameUtilsKt.getShipManagingPos(level, start);
        if (ship != null) {
            Vector3d startVec = ship.getTransform().getShipToWorld().transformPosition(new Vector3d((double)start.m_123341_() + 0.5, (double)start.m_123342_() + 0.5, (double)start.m_123343_() + 0.5));
            Vector3d direction = ship.getTransform().getShipToWorld().transformDirection(VectorConversionsMCKt.toJOMLD(facing.m_122436_()));
            startVec.add(direction.x, direction.y, direction.z);
            direction.mul((double)max);
            Vec3 mcStart = VectorConversionsMCKt.toMinecraft((Vector3dc)startVec);
            BlockHitResult result = RaycastUtilsKt.clipIncludeShips(level, new ClipContext(mcStart, VectorConversionsMCKt.toMinecraft((Vector3dc)startVec.add(direction.x, direction.y, direction.z)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, null));
            cir.setReturnValue((Object)Float.valueOf((float)result.m_82450_().m_82554_(mcStart)));
        } else {
            BlockPos end = start.m_5484_(facing, (int)max);
            if (VSGameUtilsKt.getShipsIntersecting(level, new AABB((double)start.m_123341_(), (double)start.m_123342_(), (double)start.m_123343_(), (double)end.m_123341_() + 1.0, (double)end.m_123342_() + 1.0, (double)end.m_123343_() + 1.0)).iterator().hasNext()) {
                Vec3 centerStart = Vec3.m_82512_((Vec3i)start);
                BlockHitResult result = RaycastUtilsKt.clipIncludeShips(level, new ClipContext(centerStart.m_82520_((double)facing.m_122429_(), (double)facing.m_122430_(), (double)facing.m_122431_()), Vec3.m_82512_((Vec3i)end), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, null));
                cir.setReturnValue((Object)Float.valueOf((float)result.m_82450_().m_82554_(centerStart)));
            }
        }
    }

    @Redirect(method={"tickAffectedEntities"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;intersects(Lnet/minecraft/world/phys/AABB;)Z"), require=0)
    private boolean redirectIntersects(AABB instance, AABB other) {
        Ship ship = this.getShip();
        if (ship != null) {
            AABBd thisAABB = VectorConversionsMCKt.toJOML(instance);
            thisAABB.transform(ship.getWorldToShip());
            return other.m_82314_(thisAABB.minX, thisAABB.minY, thisAABB.minZ, thisAABB.maxX, thisAABB.maxY, thisAABB.maxZ);
        }
        return instance.m_82381_(other);
    }

    @Inject(method={"tickAffectedEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getDeltaMovement()Lnet/minecraft/world/phys/Vec3;")}, locals=LocalCapture.CAPTURE_FAILSOFT, require=0)
    private void harvester(Level world, Direction facing, CallbackInfo ci2, Iterator<Entity> iterator2, Entity entity, Vec3 center, Vec3i flow, float sneakModifier, float speed, double entityDistance, float acceleration) {
        Ship ship = this.getShip();
        if (ship != null) {
            Vector3d tempVec = new Vector3d();
            ship.getTransform().getShipToWorld().transformDirection((double)flow.m_123341_(), (double)flow.m_123342_(), (double)flow.m_123343_(), tempVec);
            this.transformedFlow = VectorConversionsMCKt.toMinecraft((Vector3dc)tempVec);
        }
        this.acceleration = acceleration;
    }

    @Redirect(method={"tickAffectedEntities"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V"), require=0)
    private void redirectSetDeltaMovement(Entity instance, Vec3 motion) {
        Ship ship = this.getShip();
        if (ship != null) {
            Vec3 previousMotion = instance.m_20184_();
            double xIn = Mth.m_14008_((double)(this.transformedFlow.f_82479_ * (double)this.acceleration - previousMotion.f_82479_), (double)-5.0, (double)5.0);
            double yIn = Mth.m_14008_((double)(this.transformedFlow.f_82480_ * (double)this.acceleration - previousMotion.f_82480_), (double)-5.0, (double)5.0);
            double zIn = Mth.m_14008_((double)(this.transformedFlow.f_82481_ * (double)this.acceleration - previousMotion.f_82481_), (double)-5.0, (double)5.0);
            instance.m_20256_(previousMotion.m_82549_(new Vec3(xIn, yIn, zIn).m_82490_(0.125)));
        } else {
            instance.m_20256_(motion);
        }
    }

    @Redirect(method={"tickAffectedEntities"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/foundation/utility/VecHelper;getCenterOf(Lnet/minecraft/core/Vec3i;)Lnet/minecraft/world/phys/Vec3;"), allow=1, require=0)
    private Vec3 redirectGetCenterOf(Vec3i pos) {
        Ship ship = this.getShip();
        Vec3 result = VecHelper.getCenterOf((Vec3i)pos);
        if (ship != null && this.source.getAirCurrentWorld() != null) {
            Vector3d tempVec = new Vector3d();
            ship.getTransform().getShipToWorld().transformPosition(result.f_82479_, result.f_82480_, result.f_82481_, tempVec);
            result = VectorConversionsMCKt.toMinecraft((Vector3dc)tempVec);
        }
        return result;
    }
}

