/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.mod_compat.create.blockentity;

import com.simibubi.create.content.kinetics.crusher.CrushingWheelControllerBlock;
import com.simibubi.create.content.kinetics.crusher.CrushingWheelControllerBlockEntity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Mixin(value={CrushingWheelControllerBlockEntity.class})
public abstract class MixinCrushingWheelControllerTileEntity {
    @Shadow
    public float crushingspeed;

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getEntities(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;)Ljava/util/List;"))
    private List<Entity> redirectBounds(Level instance, Entity entity, AABB area, Predicate<Entity> predicate) {
        if (instance != null) {
            area = VSGameUtilsKt.transformAabbToWorld(instance, area);
            return instance.m_6249_(entity, area, predicate);
        }
        return new ArrayList<Entity>();
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;intersects(Lnet/minecraft/world/phys/AABB;)Z"))
    private boolean redirectIntersects(AABB instance, AABB other) {
        Iterator<Ship> ships;
        Level level = ((CrushingWheelControllerBlockEntity)this).m_58904_();
        if (level != null && (ships = VSGameUtilsKt.getShipsIntersecting(level, instance).iterator()).hasNext()) {
            AABBd result = new AABBd();
            VectorConversionsMCKt.toJOML(instance).transform(ships.next().getTransform().getWorldToShip(), result);
            instance = VectorConversionsMCKt.toMinecraft((AABBdc)result);
        }
        return instance.m_82381_(other);
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V"))
    private void redirectSetDeltaMovement(Entity instance, Vec3 motion) {
        BlockPos worldPosition = ((CrushingWheelControllerBlockEntity)this).m_58899_();
        Direction facing = (Direction)((CrushingWheelControllerBlockEntity)this).m_58900_().m_61143_((Property)CrushingWheelControllerBlock.f_52588_);
        Vec3 transformedPos = this.getTransformedPosition(instance);
        double xMotion = ((double)worldPosition.m_123341_() + 0.5 - transformedPos.f_82479_) / 2.0;
        double zMotion = ((double)worldPosition.m_123343_() + 0.5 - transformedPos.f_82481_) / 2.0;
        if (instance.m_6144_()) {
            zMotion = 0.0;
            xMotion = 0.0;
        }
        double movement = Math.max(-(this.crushingspeed * 4.0f) / 4.0f, -0.5f) * (float)(-facing.m_122421_().m_122540_());
        Vec3 transformedDirection = this.directionShip2World(instance, new Vec3(facing.m_122434_() == Direction.Axis.X ? movement : xMotion, facing.m_122434_() == Direction.Axis.Y ? movement : 0.0, facing.m_122434_() == Direction.Axis.Z ? movement : zMotion));
        instance.m_20256_(transformedDirection);
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getX()D"))
    private double redirectEntityGetX(Entity instance) {
        return this.getTransformedPosition((Entity)instance).f_82479_;
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getY()D"))
    private double redirectEntityGetY(Entity instance) {
        return this.getTransformedPosition((Entity)instance).f_82480_;
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getZ()D"))
    private double redirectEntityGetZ(Entity instance) {
        return this.getTransformedPosition((Entity)instance).f_82481_;
    }

    private Vec3 getTransformedPosition(Entity instance) {
        Vec3 result = instance.m_20182_();
        Ship ship = VSGameUtilsKt.getShipManagingPos(instance.m_9236_(), ((CrushingWheelControllerBlockEntity)this).m_58899_());
        if (ship != null) {
            Vector3d tempVec = new Vector3d();
            ship.getTransform().getWorldToShip().transformPosition(result.f_82479_, result.f_82480_, result.f_82481_, tempVec);
            result = VectorConversionsMCKt.toMinecraft((Vector3dc)tempVec);
        }
        return result;
    }

    private Vec3 directionShip2World(Entity instance, Vec3 direction) {
        Vec3 result = direction;
        Ship ship = VSGameUtilsKt.getShipManagingPos(instance.m_9236_(), ((CrushingWheelControllerBlockEntity)this).m_58899_());
        if (ship != null) {
            Vector3d tempVec = new Vector3d();
            ship.getTransform().getShipToWorld().transformDirection(result.f_82479_, result.f_82480_, result.f_82481_, tempVec);
            result = VectorConversionsMCKt.toMinecraft((Vector3dc)tempVec);
        }
        return result;
    }
}

