/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.item;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class KnifeItem
extends DiggerItem {
    public static final Set<ToolAction> KNIFE_ACTIONS = Set.of(ToolActions.SHEARS_CARVE);

    public KnifeItem(Tier tier, float attackDamage, float attackSpeed, Item.Properties properties) {
        super(attackDamage, attackSpeed, tier, ModTags.MINEABLE_WITH_KNIFE, properties);
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(1, attacker, user -> user.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return KNIFE_ACTIONS.contains(toolAction);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        HashSet ALLOWED_ENCHANTMENTS = Sets.newHashSet((Object[])new Enchantment[]{Enchantments.f_44977_, Enchantments.f_44978_, Enchantments.f_44979_, Enchantments.f_44980_, Enchantments.f_44981_, Enchantments.f_44982_});
        if (ALLOWED_ENCHANTMENTS.contains(enchantment)) {
            return true;
        }
        HashSet DENIED_ENCHANTMENTS = Sets.newHashSet((Object[])new Enchantment[]{Enchantments.f_44987_});
        if (DENIED_ENCHANTMENTS.contains(enchantment)) {
            return false;
        }
        return enchantment.f_44672_.m_7454_(stack.m_41720_());
    }

    @Mod.EventBusSubscriber(modid="farmersdelight", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class KnifeEvents {
        @SubscribeEvent
        public static void onKnifeKnockback(LivingKnockBackEvent event) {
            ItemStack toolStack;
            LivingEntity attacker = event.getEntity().m_21232_();
            ItemStack itemStack = toolStack = attacker != null ? attacker.m_21120_(InteractionHand.MAIN_HAND) : ItemStack.f_41583_;
            if (toolStack.m_41720_() instanceof KnifeItem) {
                event.setStrength(event.getOriginalStrength() - 0.1f);
            }
        }

        @SubscribeEvent
        public static void onCakeInteraction(PlayerInteractEvent.RightClickBlock event) {
            ItemStack toolStack = event.getEntity().m_21120_(event.getHand());
            if (!toolStack.m_204117_(ModTags.KNIVES)) {
                return;
            }
            Level level = event.getLevel();
            BlockPos pos = event.getPos();
            BlockState state = event.getLevel().m_8055_(pos);
            Block block = state.m_60734_();
            if (state.m_204336_(ModTags.DROPS_CAKE_SLICE)) {
                level.m_7731_(pos, (BlockState)Blocks.f_50145_.m_49966_().m_61124_((Property)CakeBlock.f_51180_, (Comparable)Integer.valueOf(1)), 3);
                Block.m_49950_((BlockState)state, (Level)level, (BlockPos)pos);
                ItemUtils.spawnItemEntity(level, new ItemStack((ItemLike)ModItems.CAKE_SLICE.get()), pos.m_123341_(), (double)pos.m_123342_() + 0.2, (double)pos.m_123343_() + 0.5, -0.05, 0.0, 0.0);
                level.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 0.8f, 0.8f);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
            if (block == Blocks.f_50145_) {
                int bites = (Integer)state.m_61143_((Property)CakeBlock.f_51180_);
                if (bites < 6) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)CakeBlock.f_51180_, (Comparable)Integer.valueOf(bites + 1)), 3);
                } else {
                    level.m_7471_(pos, false);
                }
                ItemUtils.spawnItemEntity(level, new ItemStack((ItemLike)ModItems.CAKE_SLICE.get()), (double)pos.m_123341_() + (double)bites * 0.1, (double)pos.m_123342_() + 0.2, (double)pos.m_123343_() + 0.5, -0.05, 0.0, 0.0);
                level.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 0.8f, 0.8f);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }
}

