/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.data;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.common.block.BasketBlock;
import vectorwing.farmersdelight.common.block.BuddingTomatoBlock;
import vectorwing.farmersdelight.common.block.CabbageBlock;
import vectorwing.farmersdelight.common.block.CabinetBlock;
import vectorwing.farmersdelight.common.block.FeastBlock;
import vectorwing.farmersdelight.common.block.MushroomColonyBlock;
import vectorwing.farmersdelight.common.block.OnionBlock;
import vectorwing.farmersdelight.common.block.PieBlock;
import vectorwing.farmersdelight.common.block.RicePaniclesBlock;
import vectorwing.farmersdelight.common.block.StoveBlock;
import vectorwing.farmersdelight.common.registry.ModBlocks;

public class BlockStates
extends BlockStateProvider {
    private static final int DEFAULT_ANGLE_OFFSET = 180;

    public BlockStates(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "farmersdelight", existingFileHelper);
    }

    private String blockName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }

    public ResourceLocation resourceBlock(String path) {
        return new ResourceLocation("farmersdelight", "block/" + path);
    }

    public ModelFile existingModel(Block block) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(this.blockName(block)), this.models().existingFileHelper);
    }

    public ModelFile existingModel(String path) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(path), this.models().existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleBlock((Block)ModBlocks.RICH_SOIL.get(), this.cubeRandomRotation((Block)ModBlocks.RICH_SOIL.get(), ""));
        this.simpleBlock((Block)ModBlocks.SAFETY_NET.get(), this.existingModel((Block)ModBlocks.SAFETY_NET.get()));
        HashSet canvasSigns = Sets.newHashSet((Object[])new Block[]{(Block)ModBlocks.CANVAS_SIGN.get(), (Block)ModBlocks.HANGING_CANVAS_SIGN.get(), (Block)ModBlocks.WHITE_CANVAS_SIGN.get(), (Block)ModBlocks.WHITE_HANGING_CANVAS_SIGN.get(), (Block)ModBlocks.ORANGE_CANVAS_SIGN.get(), (Block)ModBlocks.ORANGE_HANGING_CANVAS_SIGN.get(), (Block)ModBlocks.MAGENTA_CANVAS_SIGN.get(), (Block)ModBlocks.MAGENTA_HANGING_CANVAS_SIGN.get(), (Block)ModBlocks.LIGHT_BLUE_CANVAS_SIGN.get(), (Block)ModBlocks.LIGHT_BLUE_HANGING_CANVAS_SIGN.get(), (Block)ModBlocks.YELLOW_CANVAS_SIGN.get(), (Block)ModBlocks.YELLOW_HANGING_CANVAS_SIGN.get(), (Block)ModBlocks.LIME_CANVAS_SIGN.get(), (Block)ModBlocks.LIME_HANGING_CANVAS_SIGN.get(), (Block)ModBlocks.PINK_CANVAS_SIGN.get(), (Block)ModBlocks.PINK_HANGING_CANVAS_SIGN.get(), (Block)ModBlocks.GRAY_CANVAS_SIGN.get(), (Block)ModBlocks.GRAY_HANGING_CANVAS_SIGN.get(), (Block)ModBlocks.LIGHT_GRAY_CANVAS_SIGN.get(), (Block)ModBlocks.LIGHT_GRAY_HANGING_CANVAS_SIGN.get(), (Block)ModBlocks.CYAN_CANVAS_SIGN.get(), (Block)ModBlocks.CYAN_HANGING_CANVAS_SIGN.get(), (Block)ModBlocks.PURPLE_CANVAS_SIGN.get(), (Block)ModBlocks.PURPLE_HANGING_CANVAS_SIGN.get(), (Block)ModBlocks.BLUE_CANVAS_SIGN.get(), (Block)ModBlocks.BLUE_HANGING_CANVAS_SIGN.get(), (Block)ModBlocks.BROWN_CANVAS_SIGN.get(), (Block)ModBlocks.BROWN_HANGING_CANVAS_SIGN.get(), (Block)ModBlocks.GREEN_CANVAS_SIGN.get(), (Block)ModBlocks.GREEN_HANGING_CANVAS_SIGN.get(), (Block)ModBlocks.RED_CANVAS_SIGN.get(), (Block)ModBlocks.RED_HANGING_CANVAS_SIGN.get(), (Block)ModBlocks.BLACK_CANVAS_SIGN.get(), (Block)ModBlocks.BLACK_HANGING_CANVAS_SIGN.get(), (Block)ModBlocks.CANVAS_WALL_SIGN.get(), (Block)ModBlocks.HANGING_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.WHITE_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.WHITE_HANGING_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.ORANGE_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.ORANGE_HANGING_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.MAGENTA_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.MAGENTA_HANGING_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.LIGHT_BLUE_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.LIGHT_BLUE_HANGING_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.YELLOW_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.YELLOW_HANGING_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.LIME_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.LIME_HANGING_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.PINK_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.PINK_HANGING_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.GRAY_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.GRAY_HANGING_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.LIGHT_GRAY_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.LIGHT_GRAY_HANGING_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.CYAN_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.CYAN_HANGING_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.PURPLE_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.PURPLE_HANGING_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.BLUE_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.BLUE_HANGING_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.BROWN_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.BROWN_HANGING_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.GREEN_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.GREEN_HANGING_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.RED_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.RED_HANGING_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.BLACK_CANVAS_WALL_SIGN.get(), (Block)ModBlocks.BLACK_HANGING_CANVAS_WALL_SIGN.get()});
        for (Block sign : canvasSigns) {
            this.simpleBlock(sign, this.existingModel((Block)ModBlocks.CANVAS_SIGN.get()));
        }
        String riceBag = this.blockName((Block)ModBlocks.RICE_BAG.get());
        this.simpleBlock((Block)ModBlocks.RICE_BAG.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(riceBag, "cube")).texture("particle", this.resourceBlock(riceBag + "_top"))).texture("down", this.resourceBlock(riceBag + "_bottom"))).texture("up", this.resourceBlock(riceBag + "_top"))).texture("north", this.resourceBlock(riceBag + "_side_tied"))).texture("south", this.resourceBlock(riceBag + "_side_tied"))).texture("east", this.resourceBlock(riceBag + "_side"))).texture("west", this.resourceBlock(riceBag + "_side")));
        this.customDirectionalBlock((Block)ModBlocks.BASKET.get(), $ -> this.existingModel((Block)ModBlocks.BASKET.get()), new Property[]{BasketBlock.ENABLED, BasketBlock.WATERLOGGED});
        this.customDirectionalBlock((Block)ModBlocks.RICE_BALE.get(), $ -> this.existingModel((Block)ModBlocks.RICE_BALE.get()), new Property[0]);
        this.customHorizontalBlock((Block)ModBlocks.CUTTING_BOARD.get(), $ -> this.existingModel((Block)ModBlocks.CUTTING_BOARD.get()), new Property[]{BasketBlock.WATERLOGGED});
        this.horizontalBlock((Block)ModBlocks.HALF_TATAMI_MAT.get(), this.existingModel("tatami_mat_half"));
        this.horizontalBlock((Block)ModBlocks.STOVE.get(), state -> {
            String name = this.blockName((Block)ModBlocks.STOVE.get());
            String suffix = (Boolean)state.m_61143_((Property)StoveBlock.LIT) != false ? "_on" : "";
            return this.models().orientableWithBottom(name + suffix, this.resourceBlock(name + "_side"), this.resourceBlock(name + "_front" + suffix), this.resourceBlock(name + "_bottom"), this.resourceBlock(name + "_top" + suffix));
        });
        this.stageBlock((Block)ModBlocks.BROWN_MUSHROOM_COLONY.get(), MushroomColonyBlock.COLONY_AGE, new Property[0]);
        this.stageBlock((Block)ModBlocks.RED_MUSHROOM_COLONY.get(), MushroomColonyBlock.COLONY_AGE, new Property[0]);
        this.stageBlock((Block)ModBlocks.RICE_CROP_PANICLES.get(), RicePaniclesBlock.RICE_AGE, new Property[0]);
        this.customStageBlock((Block)ModBlocks.CABBAGE_CROP.get(), this.resourceBlock("crop_cross"), "cross", CabbageBlock.f_52244_, new ArrayList<Integer>(), new Property[0]);
        this.customStageBlock((Block)ModBlocks.ONION_CROP.get(), this.mcLoc("crop"), "crop", OnionBlock.f_52244_, Arrays.asList(0, 0, 1, 1, 2, 2, 2, 3), new Property[0]);
        this.customStageBlock((Block)ModBlocks.BUDDING_TOMATO_CROP.get(), this.resourceBlock("crop_cross"), "cross", BuddingTomatoBlock.AGE, Arrays.asList(0, 1, 2, 3, 3), new Property[0]);
        this.crateBlock((Block)ModBlocks.CARROT_CRATE.get(), "carrot");
        this.crateBlock((Block)ModBlocks.POTATO_CRATE.get(), "potato");
        this.crateBlock((Block)ModBlocks.BEETROOT_CRATE.get(), "beetroot");
        this.crateBlock((Block)ModBlocks.CABBAGE_CRATE.get(), "cabbage");
        this.crateBlock((Block)ModBlocks.TOMATO_CRATE.get(), "tomato");
        this.crateBlock((Block)ModBlocks.ONION_CRATE.get(), "onion");
        this.axisBlock((RotatedPillarBlock)ModBlocks.STRAW_BALE.get());
        this.cabinetBlock((Block)ModBlocks.OAK_CABINET.get(), "oak");
        this.cabinetBlock((Block)ModBlocks.BIRCH_CABINET.get(), "birch");
        this.cabinetBlock((Block)ModBlocks.SPRUCE_CABINET.get(), "spruce");
        this.cabinetBlock((Block)ModBlocks.JUNGLE_CABINET.get(), "jungle");
        this.cabinetBlock((Block)ModBlocks.ACACIA_CABINET.get(), "acacia");
        this.cabinetBlock((Block)ModBlocks.DARK_OAK_CABINET.get(), "dark_oak");
        this.cabinetBlock((Block)ModBlocks.MANGROVE_CABINET.get(), "mangrove");
        this.cabinetBlock((Block)ModBlocks.CHERRY_CABINET.get(), "cherry");
        this.cabinetBlock((Block)ModBlocks.BAMBOO_CABINET.get(), "bamboo");
        this.cabinetBlock((Block)ModBlocks.CRIMSON_CABINET.get(), "crimson");
        this.cabinetBlock((Block)ModBlocks.WARPED_CABINET.get(), "warped");
        this.pieBlock((Block)ModBlocks.APPLE_PIE.get());
        this.pieBlock((Block)ModBlocks.CHOCOLATE_PIE.get());
        this.pieBlock((Block)ModBlocks.SWEET_BERRY_CHEESECAKE.get());
        this.feastBlock((FeastBlock)((Object)ModBlocks.STUFFED_PUMPKIN_BLOCK.get()));
        this.feastBlock((FeastBlock)((Object)ModBlocks.ROAST_CHICKEN_BLOCK.get()));
        this.feastBlock((FeastBlock)((Object)ModBlocks.HONEY_GLAZED_HAM_BLOCK.get()));
        this.feastBlock((FeastBlock)((Object)ModBlocks.SHEPHERDS_PIE_BLOCK.get()));
        this.feastBlock((FeastBlock)((Object)ModBlocks.RICE_ROLL_MEDLEY_BLOCK.get()));
        this.wildCropBlock((Block)ModBlocks.SANDY_SHRUB.get());
        this.wildCropBlock((Block)ModBlocks.WILD_BEETROOTS.get());
        this.wildCropBlock((Block)ModBlocks.WILD_CABBAGES.get());
        this.wildCropBlock((Block)ModBlocks.WILD_POTATOES.get());
        this.wildCropBlock((Block)ModBlocks.WILD_TOMATOES.get());
        this.wildCropBlock((Block)ModBlocks.WILD_CARROTS.get());
        this.wildCropBlock((Block)ModBlocks.WILD_ONIONS.get());
        this.doublePlantBlock((Block)ModBlocks.WILD_RICE.get());
    }

    public ConfiguredModel[] cubeRandomRotation(Block block, String suffix) {
        String formattedName = this.blockName(block) + (String)(suffix.isEmpty() ? "" : "_" + suffix);
        return ConfiguredModel.allYRotations((ModelFile)this.models().cubeAll(formattedName, this.resourceBlock(formattedName)), (int)0, (boolean)false);
    }

    public void customDirectionalBlock(Block block, Function<BlockState, ModelFile> modelFunc, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(dir == Direction.DOWN ? 180 : (dir.m_122434_().m_122479_() ? 90 : 0)).rotationY(dir.m_122434_().m_122478_() ? 0 : ((int)dir.m_122435_() + 180) % 360).build();
        }, ignored);
    }

    public void customHorizontalBlock(Block block, Function<BlockState, ModelFile> modelFunc, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build(), ignored);
    }

    public void stageBlock(Block block, IntegerProperty ageProperty, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int ageSuffix = (Integer)state.m_61143_((Property)ageProperty);
            String stageName = this.blockName(block) + "_stage" + ageSuffix;
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cross(stageName, this.resourceBlock(stageName))).renderType("cutout")).build();
        }, ignored);
    }

    public void customStageBlock(Block block, @Nullable ResourceLocation parent, String textureKey, IntegerProperty ageProperty, List<Integer> suffixes, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int ageSuffix = (Integer)state.m_61143_((Property)ageProperty);
            String stageName = this.blockName(block) + "_stage";
            stageName = stageName + (suffixes.isEmpty() ? ageSuffix : (Integer)suffixes.get(Math.min(suffixes.size(), ageSuffix)));
            if (parent == null) {
                return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cross(stageName, this.resourceBlock(stageName))).renderType("cutout")).build();
            }
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().singleTexture(stageName, parent, textureKey, this.resourceBlock(stageName))).renderType("cutout")).build();
        }, ignored);
    }

    public void wildCropBlock(Block block) {
        this.wildCropBlock(block, false);
    }

    public void wildCropBlock(Block block, boolean isBushCrop) {
        if (isBushCrop) {
            this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().singleTexture(this.blockName(block), this.resourceBlock("bush_crop"), "crop", this.resourceBlock(this.blockName(block)))).renderType("cutout"));
        } else {
            this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cross(this.blockName(block), this.resourceBlock(this.blockName(block)))).renderType("cutout"));
        }
    }

    public void crateBlock(Block block, String cropName) {
        this.simpleBlock(block, (ModelFile)this.models().cubeBottomTop(this.blockName(block), this.resourceBlock(cropName + "_crate_side"), this.resourceBlock("crate_bottom"), this.resourceBlock(cropName + "_crate_top")));
    }

    public void cabinetBlock(Block block, String woodType) {
        this.horizontalBlock(block, state -> {
            String suffix = (Boolean)state.m_61143_((Property)CabinetBlock.OPEN) != false ? "_open" : "";
            return this.models().orientable(this.blockName(block) + suffix, this.resourceBlock(woodType + "_cabinet_side"), this.resourceBlock(woodType + "_cabinet_front" + suffix), this.resourceBlock(woodType + "_cabinet_top"));
        });
    }

    public void feastBlock(FeastBlock block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            IntegerProperty servingsProperty = block.getServingsProperty();
            int servings = (Integer)state.m_61143_((Property)servingsProperty);
            Object suffix = "_stage" + (block.getMaxServings() - servings);
            if (servings == 0) {
                suffix = block.hasLeftovers ? "_leftover" : "_stage" + (servingsProperty.m_6908_().toArray().length - 2);
            }
            return ConfiguredModel.builder().modelFile(this.existingModel(this.blockName(block) + (String)suffix)).rotationY(((int)((Direction)state.m_61143_((Property)FeastBlock.FACING)).m_122435_() + 180) % 360).build();
        });
    }

    public void doublePlantBlock(Block block) {
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER).modelForState().modelFile((ModelFile)((BlockModelBuilder)this.models().cross(this.blockName(block) + "_bottom", this.resourceBlock(this.blockName(block) + "_bottom"))).renderType("cutout")).addModel()).partialState().with((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER).modelForState().modelFile((ModelFile)((BlockModelBuilder)this.models().cross(this.blockName(block) + "_top", this.resourceBlock(this.blockName(block) + "_top"))).renderType("cutout")).addModel();
    }

    public void pieBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int bites = (Integer)state.m_61143_((Property)PieBlock.BITES);
            Object suffix = bites > 0 ? "_slice" + bites : "";
            return ConfiguredModel.builder().modelFile(this.existingModel(this.blockName(block) + (String)suffix)).rotationY(((int)((Direction)state.m_61143_((Property)PieBlock.FACING)).m_122435_() + 180) % 360).build();
        });
    }
}

