/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.waterframes.common.item;

import java.util.List;
import me.srrapero720.waterframes.DisplaysConfig;
import me.srrapero720.waterframes.WaterFrames;
import me.srrapero720.waterframes.common.block.entity.DisplayTile;
import me.srrapero720.waterframes.common.screens.RemoteControlScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.Nullable;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.creator.GuiCreator;
import team.creative.creativecore.common.gui.creator.ItemGuiCreator;

public class RemoteControl
extends Item
implements ItemGuiCreator {
    private static final String POSITION = "position";
    private static final String DIMENSION = "dimension";
    private static final Marker IT = MarkerManager.getMarker((String)RemoteControl.class.getSimpleName());

    public RemoteControl(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (!DisplaysConfig.canInteractRemote(player)) {
            this.sendFatal(player, Component.m_237115_((String)"waterframes.common.access.denied"));
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128456_()) {
            this.sendFailed(player, Component.m_237115_((String)"waterframes.remote.bound.failed"));
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (player.m_6047_() && !tag.m_128456_()) {
            stack.m_41751_(null);
            this.sendSuccess(player, Component.m_237115_((String)"waterframes.remote.unbound.success"));
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        int[] pos = this.getPosition(tag);
        String dim = this.getDimension(tag);
        if (pos.length < 3 || dim.isEmpty()) {
            this.sendFailed(player, Component.m_237115_((String)"waterframes.remote.code.failed"));
            WaterFrames.LOGGER.error(IT, "NBT data is invalid, ensure your set pos as a long-int and the dimension as a resource location");
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        BlockPos blockPos = new BlockPos(pos[0], pos[1], pos[2]);
        ResourceLocation dimension = new ResourceLocation(dim);
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof DisplayTile) {
            DisplayTile tile = (DisplayTile)blockEntity;
            double distance = WaterFrames.getDistance(tile, (Position)player.m_20182_());
            if (level.m_46472_().m_135782_().equals((Object)dimension) && distance < (double)DisplaysConfig.maxRcDis()) {
                GuiCreator.ITEM_OPENER.open(player.m_21120_(hand).m_41784_(), player, hand);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            this.sendFailed(player, Component.m_237115_((String)"waterframes.remote.distance.failed"));
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        player.m_21120_(hand).m_41751_(null);
        this.sendFailed(player, Component.m_237115_((String)"waterframes.remote.display.failed"));
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        if (player == null || context.m_43724_() == InteractionHand.OFF_HAND || !context.m_43722_().m_41784_().m_128456_() || !player.m_6047_()) {
            return InteractionResult.PASS;
        }
        if (!DisplaysConfig.canBindRemote(player)) {
            this.sendFatal(player, Component.m_237115_((String)"waterframes.common.access.denied"));
            return InteractionResult.FAIL;
        }
        if (level.m_7702_(pos) instanceof DisplayTile) {
            ItemStack item = context.m_43722_();
            CompoundTag tag = item.m_41784_();
            this.setPosition(tag, pos);
            this.setDimension(tag, level);
            this.sendSuccess(player, Component.m_237115_((String)"waterframes.remote.bound.success"));
            return InteractionResult.SUCCESS;
        }
        this.sendFailed(player, Component.m_237115_((String)"waterframes.remote.display.invalid"));
        return InteractionResult.FAIL;
    }

    private void sendSuccess(Player player, MutableComponent component) {
        if (player.f_19853_.f_46443_) {
            player.m_5661_((Component)component.m_130940_(ChatFormatting.AQUA), true);
            player.m_5496_((SoundEvent)NoteBlockInstrument.BELL.m_263188_().get(), 1.0f, 1.25f);
        }
    }

    private void sendFailed(Player player, MutableComponent component) {
        if (player.f_19853_.f_46443_) {
            player.m_5661_((Component)component.m_130940_(ChatFormatting.RED), true);
            player.m_5496_((SoundEvent)NoteBlockInstrument.HARP.m_263188_().get(), 1.0f, 0.75f);
        }
    }

    private void sendFatal(Player player, MutableComponent component) {
        if (player.f_19853_.f_46443_) {
            player.m_5661_((Component)component.m_130940_(ChatFormatting.DARK_RED), true);
            player.m_5496_((SoundEvent)NoteBlockInstrument.HARP.m_263188_().get(), 1.0f, 0.5f);
        }
    }

    public boolean hasPosition(CompoundTag tag) {
        return tag.m_128441_(POSITION);
    }

    public boolean hasDimension(CompoundTag tag) {
        return tag.m_128441_(DIMENSION);
    }

    public int[] getPosition(CompoundTag tag) {
        return tag.m_128465_(POSITION);
    }

    public String getDimension(CompoundTag tag) {
        return tag.m_128461_(DIMENSION);
    }

    public void setPosition(CompoundTag tag, BlockPos pos) {
        tag.m_128385_(POSITION, new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
    }

    public void setDimension(CompoundTag tag, Level level) {
        tag.m_128359_(DIMENSION, level.m_46472_().m_135782_().toString());
    }

    public GuiLayer create(CompoundTag tag, Player player) {
        int[] pos = this.getPosition(tag);
        BlockPos blockPos = new BlockPos(pos[0], pos[1], pos[2]);
        return new RemoteControlScreen(player, (DisplayTile)player.f_19853_.m_7702_(blockPos), tag, this);
    }

    public Component getHighlightTip(ItemStack item, Component displayName) {
        return Component.m_237113_((String)displayName.getString()).m_130940_(ChatFormatting.AQUA);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag isAdvanced) {
        Options opts = Minecraft.m_91087_().f_91066_;
        pTooltipComponents.add((Component)Component.m_237110_((String)"waterframes.remote.description.1", (Object[])new Object[]{opts.f_92090_.getKey().m_84875_(), opts.f_92095_.getKey().m_84875_()}));
    }

    public boolean m_5812_(ItemStack pStack) {
        CompoundTag tag = pStack.m_41783_();
        return tag != null && !tag.m_128456_() && (tag.m_128441_(POSITION) || tag.m_128441_("pos")) && tag.m_128441_(DIMENSION);
    }

    public boolean m_6777_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        return false;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }
}

