/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic.methods;

import dan200.computercraft.api.detail.VanillaDetailRegistries;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.util.ArgumentHelpers;
import dan200.computercraft.shared.peripheral.generic.GenericPeripheral;
import dan200.computercraft.shared.peripheral.generic.methods.AbstractInventoryMethods;
import dan200.computercraft.shared.platform.ForgeContainerTransfer;
import dan200.computercraft.shared.util.CapabilityUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public final class InventoryMethods
extends AbstractInventoryMethods<IItemHandler> {
    @Override
    @LuaFunction(mainThread=true)
    public int size(IItemHandler inventory) {
        return inventory.getSlots();
    }

    @Override
    @LuaFunction(mainThread=true)
    public Map<Integer, Map<String, ?>> list(IItemHandler inventory) {
        HashMap result = new HashMap();
        int size = inventory.getSlots();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            result.put(i + 1, VanillaDetailRegistries.ITEM_STACK.getBasicDetails(stack));
        }
        return result;
    }

    @Override
    @Nullable
    @LuaFunction(mainThread=true)
    public Map<String, ?> getItemDetail(IItemHandler inventory, int slot) throws LuaException {
        ArgumentHelpers.assertBetween(slot, 1, inventory.getSlots(), "Slot out of range (%s)");
        ItemStack stack = inventory.getStackInSlot(slot - 1);
        return stack.m_41619_() ? null : VanillaDetailRegistries.ITEM_STACK.getDetails(stack);
    }

    @Override
    @LuaFunction(mainThread=true)
    public long getItemLimit(IItemHandler inventory, int slot) throws LuaException {
        ArgumentHelpers.assertBetween(slot, 1, inventory.getSlots(), "Slot out of range (%s)");
        return inventory.getSlotLimit(slot - 1);
    }

    @Override
    @LuaFunction(mainThread=true)
    public int pushItems(IItemHandler from, IComputerAccess computer, String toName, int fromSlot, Optional<Integer> limit, Optional<Integer> toSlot) throws LuaException {
        IPeripheral location = computer.getAvailablePeripheral(toName);
        if (location == null) {
            throw new LuaException("Target '" + toName + "' does not exist");
        }
        IItemHandler to = InventoryMethods.extractHandler(location);
        if (to == null) {
            throw new LuaException("Target '" + toName + "' is not an inventory");
        }
        int actualLimit = limit.orElse(Integer.MAX_VALUE);
        ArgumentHelpers.assertBetween(fromSlot, 1, from.getSlots(), "From slot out of range (%s)");
        if (toSlot.isPresent()) {
            ArgumentHelpers.assertBetween(toSlot.get(), 1, to.getSlots(), "To slot out of range (%s)");
        }
        if (actualLimit <= 0) {
            return 0;
        }
        return InventoryMethods.moveItem(from, fromSlot - 1, to, toSlot.orElse(0) - 1, actualLimit);
    }

    @Override
    @LuaFunction(mainThread=true)
    public int pullItems(IItemHandler to, IComputerAccess computer, String fromName, int fromSlot, Optional<Integer> limit, Optional<Integer> toSlot) throws LuaException {
        IPeripheral location = computer.getAvailablePeripheral(fromName);
        if (location == null) {
            throw new LuaException("Source '" + fromName + "' does not exist");
        }
        IItemHandler from = InventoryMethods.extractHandler(location);
        if (from == null) {
            throw new LuaException("Source '" + fromName + "' is not an inventory");
        }
        int actualLimit = limit.orElse(Integer.MAX_VALUE);
        ArgumentHelpers.assertBetween(fromSlot, 1, from.getSlots(), "From slot out of range (%s)");
        if (toSlot.isPresent()) {
            ArgumentHelpers.assertBetween(toSlot.get(), 1, to.getSlots(), "To slot out of range (%s)");
        }
        if (actualLimit <= 0) {
            return 0;
        }
        return InventoryMethods.moveItem(from, fromSlot - 1, to, toSlot.orElse(0) - 1, actualLimit);
    }

    @Nullable
    private static IItemHandler extractHandler(IPeripheral peripheral) {
        ICapabilityProvider provider;
        LazyOptional cap;
        BlockEntity blockEntity;
        Direction direction;
        Object object = peripheral.getTarget();
        if (peripheral instanceof GenericPeripheral) {
            GenericPeripheral sided = (GenericPeripheral)peripheral;
            v0 = sided.side();
        } else {
            v0 = direction = null;
        }
        if (object instanceof BlockEntity && (blockEntity = (BlockEntity)object).m_58901_()) {
            return null;
        }
        if (object instanceof ICapabilityProvider && (cap = CapabilityUtil.getCapability(provider = (ICapabilityProvider)object, ForgeCapabilities.ITEM_HANDLER, direction)).isPresent()) {
            return (IItemHandler)cap.orElseThrow(NullPointerException::new);
        }
        if (object instanceof IItemHandler) {
            IItemHandler handler = (IItemHandler)object;
            return handler;
        }
        if (object instanceof Container) {
            Container container = (Container)object;
            return new InvWrapper(container);
        }
        return null;
    }

    private static int moveItem(IItemHandler from, int fromSlot, IItemHandler to, int toSlot, int limit) {
        ForgeContainerTransfer fromWrapper = new ForgeContainerTransfer(from).singleSlot(fromSlot);
        ForgeContainerTransfer toWrapper = new ForgeContainerTransfer(to);
        if (toSlot >= 0) {
            toWrapper = toWrapper.singleSlot(toSlot);
        }
        return Math.max(0, fromWrapper.moveTo(toWrapper, limit));
    }
}

