/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.items;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import edn.stratodonut.trackwork.TrackSounds;
import edn.stratodonut.trackwork.items.TrackToolkitRenderer;
import edn.stratodonut.trackwork.tracks.blocks.SuspensionTrackBlockEntity;
import edn.stratodonut.trackwork.tracks.blocks.TrackBaseBlock;
import edn.stratodonut.trackwork.tracks.blocks.WheelBlock;
import edn.stratodonut.trackwork.tracks.blocks.WheelBlockEntity;
import edn.stratodonut.trackwork.tracks.forces.PhysicsTrackController;
import edn.stratodonut.trackwork.tracks.forces.SimpleWheelController;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public class TrackToolkit
extends Item {
    public TrackToolkit(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult onItemUseFirst(ItemStack stack, @NotNull UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null || !player.m_36326_()) {
            return InteractionResult.PASS;
        }
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128441_("Tool")) {
            TOOL type = TOOL.from(nbt.m_128451_("Tool"));
            switch (type) {
                case OFFSET: {
                    BlockEntity be = level.m_7702_(pos);
                    AllSoundEvents.WRENCH_ROTATE.playOnServer(player.m_9236_(), (Vec3i)pos, 1.0f, player.m_217043_().m_188501_() + 0.5f);
                    if (be instanceof SuspensionTrackBlockEntity) {
                        SuspensionTrackBlockEntity se = (SuspensionTrackBlockEntity)be;
                        LoadedShip ship = VSGameUtilsKt.getShipObjectManagingPos((Level)level, (Vec3i)context.m_8083_());
                        if (ship == null) {
                            return InteractionResult.FAIL;
                        }
                        se.setHorizontalOffset((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)context.m_43720_().m_82546_(Vec3.m_82512_((Vec3i)context.m_8083_()))));
                        return InteractionResult.SUCCESS;
                    }
                    if (!(be instanceof WheelBlockEntity)) break;
                    WheelBlockEntity wbe = (WheelBlockEntity)be;
                    LoadedShip ship = VSGameUtilsKt.getShipObjectManagingPos((Level)level, (Vec3i)context.m_8083_());
                    if (ship == null) {
                        return InteractionResult.FAIL;
                    }
                    wbe.setOffset((Vector3dc)VectorConversionsMCKt.toJOML((Vec3)context.m_43720_().m_82546_(Vec3.m_82512_((Vec3i)context.m_8083_()))), context.m_43719_());
                    return InteractionResult.SUCCESS;
                }
                case STIFFNESS: {
                    Block hitBlock = level.m_8055_(pos).m_60734_();
                    player.m_5496_((SoundEvent)TrackSounds.SPRING_TOOL.get(), 1.0f, 0.8f + 0.4f * player.m_217043_().m_188501_());
                    boolean isSneaking = player.m_6144_();
                    if (hitBlock instanceof TrackBaseBlock) {
                        LoadedShip ship = VSGameUtilsKt.getShipObjectManagingPos((Level)level, (Vec3i)context.m_8083_());
                        if (ship == null) {
                            return InteractionResult.FAIL;
                        }
                        if (!level.f_46443_) {
                            PhysicsTrackController controller = PhysicsTrackController.getOrCreate((ServerShip)ship);
                            float result = controller.setDamperCoefficient(isSneaking ? -1.0f : 1.0f);
                            MutableComponent chatMessage = Lang.text((String)"Adjusted suspension stiffness to ").add(Components.literal((String)String.format("%.2fx", Float.valueOf(result)))).component();
                            player.m_5661_((Component)chatMessage, true);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    if (!(hitBlock instanceof WheelBlock)) break;
                    LoadedShip ship = VSGameUtilsKt.getShipObjectManagingPos((Level)level, (Vec3i)context.m_8083_());
                    if (ship == null) {
                        return InteractionResult.FAIL;
                    }
                    if (!level.f_46443_) {
                        SimpleWheelController controller = SimpleWheelController.getOrCreate((ServerShip)ship);
                        float result = controller.setDamperCoefficient(isSneaking ? -1.0f : 1.0f);
                        MutableComponent chatMessage = Lang.text((String)"Adjusted suspension stiffness to ").add(Components.literal((String)String.format("%.2fx", Float.valueOf(result)))).component();
                        player.m_5661_((Component)chatMessage, true);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return this.m_7203_(level, player, context.m_43724_()).m_19089_();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!player.m_6144_()) {
            if (!level.f_46443_) {
                this.nextMode(stack);
            }
            player.m_36335_().m_41524_((Item)this, 2);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private void nextMode(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (!nbt.m_128441_("Tool")) {
            nbt.m_128405_("Tool", 0);
        } else {
            nbt.m_128405_("Tool", TOOL.next(nbt.m_128451_("Tool")));
        }
        stack.m_41751_(nbt);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new TrackToolkitRenderer()));
    }

    public static enum TOOL implements StringRepresentable
    {
        STIFFNESS,
        OFFSET;

        private static final TOOL[] vals;

        public static TOOL from(int i) {
            return vals[i];
        }

        public static int next(int i) {
            return (i + 1) % vals.length;
        }

        @NotNull
        public String m_7912_() {
            return Lang.asId((String)this.name());
        }

        static {
            vals = TOOL.values();
        }
    }
}

