/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.tracks.forces;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.mojang.datafixers.util.Pair;
import edn.stratodonut.trackwork.tracks.data.SimpleWheelData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.jvm.functions.Function1;
import net.minecraft.core.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ShipForcesInducer;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;
import org.valkyrienskies.physics_api.PoseVel;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class SimpleWheelController
implements ShipForcesInducer {
    @JsonIgnore
    public static final double RPM_TO_RADS = 0.10471975512;
    @JsonIgnore
    public static final double MAXIMUM_SLIP = 10.0;
    @JsonIgnore
    public static final double MAXIMUM_SLIP_LATERAL = 15.0;
    @JsonIgnore
    public static final double MAXIMUM_G = 490.5;
    public static final Vector3dc UP = new Vector3d(0.0, 1.0, 0.0);
    private final HashMap<Long, SimpleWheelData> trackData = new HashMap();
    @JsonIgnore
    private final ConcurrentLinkedQueue<Pair<Long, SimpleWheelData.SimpleWheelCreateData>> createdTrackData = new ConcurrentLinkedQueue();
    @JsonIgnore
    private final ConcurrentHashMap<Long, SimpleWheelData.SimpleWheelUpdateData> trackUpdateData = new ConcurrentHashMap();
    private final ConcurrentLinkedQueue<Long> removedTracks = new ConcurrentLinkedQueue();
    private int nextBearingID = 0;
    private volatile Vector3dc suspensionAdjust = new Vector3d(0.0, 1.0, 0.0);
    private volatile float suspensionStiffness = 1.0f;
    private float debugTick = 0.0f;

    public static SimpleWheelController getOrCreate(ServerShip ship) {
        if (ship.getAttachment(SimpleWheelController.class) == null) {
            ship.saveAttachment(SimpleWheelController.class, (Object)new SimpleWheelController());
        }
        return (SimpleWheelController)ship.getAttachment(SimpleWheelController.class);
    }

    public void applyForcesAndLookupPhysShips(@NotNull PhysShip physShip, @NotNull Function1<? super Long, ? extends PhysShip> lookupPhysShip) {
        while (!this.createdTrackData.isEmpty()) {
            Pair createData = (Pair)this.createdTrackData.remove();
            this.trackData.put((Long)createData.getFirst(), SimpleWheelData.from((SimpleWheelData.SimpleWheelCreateData)createData.getSecond()));
        }
        this.trackUpdateData.forEach((id, data) -> {
            SimpleWheelData old = this.trackData.get(id);
            if (old != null) {
                this.trackData.put((Long)id, old.updateWith((SimpleWheelData.SimpleWheelUpdateData)data));
            }
        });
        this.trackUpdateData.clear();
        while (!this.removedTracks.isEmpty()) {
            Long removeId = (Long)this.removedTracks.remove();
            this.trackData.remove(removeId);
        }
        if (this.trackData.isEmpty()) {
            return;
        }
        Vector3d netLinearForce = new Vector3d(0.0);
        Vector3d netTorque = new Vector3d(0.0);
        double coefficientOfPower = Math.min((double)2.0, (double)(3.0 / (double)this.trackData.size()));
        this.trackData.forEach((id, data) -> {
            Pair<Vector3dc, Vector3dc> forces = this.computeForce((SimpleWheelData)data, (PhysShipImpl)physShip, coefficientOfPower, lookupPhysShip);
            if (((Vector3dc)forces.getFirst()).isFinite()) {
                netLinearForce.add((Vector3dc)forces.getFirst());
                netTorque.add((Vector3dc)forces.getSecond());
            }
        });
        if (netLinearForce.isFinite() && netLinearForce.length() / ((PhysShipImpl)physShip).getInertia().getShipMass() < 490.5) {
            physShip.applyInvariantForce((Vector3dc)netLinearForce);
            if (netTorque.isFinite()) {
                physShip.applyInvariantTorque((Vector3dc)netTorque);
            }
        }
    }

    public void applyForces(@NotNull PhysShip physShip) {
    }

    private Pair<Vector3dc, Vector3dc> computeForce(SimpleWheelData data, PhysShipImpl ship, double coefficientOfPower, @NotNull Function1<? super Long, ? extends PhysShip> lookupPhysShip) {
        PoseVel pose = ship.getPoseVel();
        ShipTransform shipTransform = ship.getTransform();
        double m = ship.getInertia().getShipMass();
        double gravity_factor = Math.max((double)0.0, (double)shipTransform.getShipToWorldRotation().transform(UP, new Vector3d()).dot(UP));
        Vector3d trackRelPosShip = data.wheelOriginPosition.sub(shipTransform.getPositionInShip(), new Vector3d());
        Vector3d tForce = new Vector3d();
        Vector3d trackNormal = data.wheelNormal.normalize(new Vector3d());
        Vector3d trackSurface = data.driveForceVector.mul((double)data.wheelRPM * 0.10471975512 * 0.5, new Vector3d());
        Vector3dc velocityAtPosition = SimpleWheelController.accumulatedVelocity(shipTransform, pose, data.wheelContactPosition);
        if (data.isWheelGrounded && data.groundShipId != null) {
            PhysShipImpl ground = (PhysShipImpl)lookupPhysShip.invoke((Object)data.groundShipId);
            Vector3dc groundShipVelocity = SimpleWheelController.accumulatedVelocity(ground.getTransform(), ground.getPoseVel(), data.wheelContactPosition);
            velocityAtPosition = velocityAtPosition.sub(groundShipVelocity, new Vector3d());
        }
        if (data.isWheelGrounded) {
            double suspensionDelta = velocityAtPosition.dot((Vector3dc)trackNormal) + data.getSuspensionCompressionDelta().length();
            double tilt = 1.0 + this.tilt((Vector3dc)trackRelPosShip);
            tForce.add((Vector3dc)data.suspensionCompression.mul(m * 4.0 * coefficientOfPower * (double)this.suspensionStiffness * tilt, new Vector3d()));
            tForce.add((Vector3dc)trackNormal.mul(m * 1.2 * -suspensionDelta * coefficientOfPower * (double)this.suspensionStiffness, new Vector3d()));
            if (data.wheelRPM == 0.0f) {
                tForce = new Vector3d(0.0, tForce.y(), 0.0);
            }
        }
        if (data.isWheelGrounded || trackSurface.lengthSquared() > 0.0) {
            Vector3d surfaceVelocity = velocityAtPosition.sub((Vector3dc)trackNormal.mul(velocityAtPosition.dot((Vector3dc)trackNormal), new Vector3d()), new Vector3d());
            Vector3d slipVelocity = trackSurface.sub((Vector3dc)surfaceVelocity, new Vector3d());
            Vector3d driveDir = data.driveForceVector.normalize(new Vector3d());
            Vector3d driveSlip = driveDir.mul(driveDir.dot((Vector3dc)slipVelocity), new Vector3d());
            Vector3d lateralSlip = slipVelocity.sub((Vector3dc)driveSlip, new Vector3d());
            if (data.isWheelGrounded) {
                slipVelocity = data.isFreespin ? lateralSlip.normalize(Math.min((double)lateralSlip.length(), (double)15.0), new Vector3d()) : driveSlip.normalize(Math.min((double)driveSlip.length(), (double)10.0), new Vector3d()).add((Vector3dc)lateralSlip.normalize(Math.min((double)lateralSlip.length(), (double)15.0), new Vector3d()), new Vector3d());
                tForce.add((Vector3dc)slipVelocity.mul(1.0 * m * coefficientOfPower * gravity_factor, new Vector3d()));
            } else if (!data.isFreespin && data.driveForceVector.length() != 0.0) {
                slipVelocity = driveSlip.normalize(Math.min((double)driveSlip.length(), (double)10.0), new Vector3d());
                tForce.add((Vector3dc)slipVelocity.mul(1.0 * m * coefficientOfPower * gravity_factor, new Vector3d()));
            }
        }
        Vector3d trackRelPos = shipTransform.getShipToWorldRotation().transform((Vector3dc)trackRelPosShip, new Vector3d());
        Vector3d torque = trackRelPos.cross((Vector3dc)tForce, new Vector3d());
        return new Pair((Object)tForce, (Object)torque);
    }

    public static Vector3dc accumulatedVelocity(ShipTransform t, PoseVel pose, Vector3dc worldPosition) {
        return pose.getVel().add((Vector3dc)pose.getOmega().cross((Vector3dc)worldPosition.sub(t.getPositionInWorld(), new Vector3d()), new Vector3d()), new Vector3d());
    }

    public final void addTrackBlock(BlockPos pos, SimpleWheelData.SimpleWheelCreateData data) {
        this.createdTrackData.add((Pair<Long, SimpleWheelData.SimpleWheelCreateData>)new Pair((Object)pos.m_121878_(), (Object)data));
    }

    public final double updateTrackBlock(BlockPos pos, SimpleWheelData.SimpleWheelUpdateData data) {
        this.trackUpdateData.put(pos.m_121878_(), data);
        return (double)Math.round((double)(this.suspensionAdjust.y() * 16.0)) / 16.0 * (double)((9.0f + 1.0f / (this.suspensionStiffness * 2.0f - 1.0f)) / 10.0f);
    }

    public final void removeTrackBlock(BlockPos pos) {
        this.removedTracks.add(pos.m_121878_());
    }

    public final float setDamperCoefficient(float delta) {
        this.suspensionStiffness = Math.clamp((float)1.0f, (float)4.0f, (float)(this.suspensionStiffness + delta));
        return this.suspensionStiffness;
    }

    public final void adjustSuspension(Vector3f delta) {
        Vector3dc old = this.suspensionAdjust;
        this.suspensionAdjust = new Vector3d(Math.clamp((double)-0.5, (double)0.5, (double)(old.x() + (double)(delta.x() * 5.0f))), Math.clamp((double)0.1, (double)1.0, (double)(old.y() + (double)delta.y())), Math.clamp((double)-0.5, (double)0.5, (double)(old.z() + (double)(delta.z() * 5.0f))));
    }

    public final void resetSuspension() {
        double y = this.suspensionAdjust.y();
        this.suspensionAdjust = new Vector3d(0.0, y, 0.0);
    }

    private double tilt(Vector3dc relPos) {
        return Math.signum((double)relPos.x()) * this.suspensionAdjust.z() + Math.signum((double)relPos.z()) * this.suspensionAdjust.x();
    }

    public static <T> boolean areQueuesEqual(Queue<T> left, Queue<T> right) {
        return Arrays.equals(left.toArray(), right.toArray());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimpleWheelController)) {
            return false;
        }
        SimpleWheelController otherController = (SimpleWheelController)other;
        return Objects.equals(this.trackData, otherController.trackData) && Objects.equals(this.trackUpdateData, otherController.trackUpdateData) && SimpleWheelController.areQueuesEqual(this.createdTrackData, otherController.createdTrackData) && SimpleWheelController.areQueuesEqual(this.removedTracks, otherController.removedTracks) && this.nextBearingID == otherController.nextBearingID;
    }
}

