/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.tracks.render;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.base.ShaftInstance;
import edn.stratodonut.trackwork.client.TrackworkPartialModels;
import edn.stratodonut.trackwork.tracks.blocks.PhysEntityTrackBlockEntity;
import edn.stratodonut.trackwork.tracks.blocks.SuspensionTrackBlock;
import edn.stratodonut.trackwork.tracks.render.SuspensionRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.Property;

public class PhysEntityTrackInstance
extends ShaftInstance<PhysEntityTrackBlockEntity>
implements DynamicInstance {
    private final ModelData gantryCogs;
    final Direction.Axis axis;
    final Direction.Axis rotationAxis;
    final float rotationMult;
    final BlockPos visualPos;
    private float lastAngle = Float.NaN;

    public PhysEntityTrackInstance(MaterialManager materialManager, PhysEntityTrackBlockEntity blockEntity) {
        super(materialManager, (KineticBlockEntity)blockEntity);
        this.gantryCogs = (ModelData)this.getTransformMaterial().getModel(TrackworkPartialModels.COGS, this.blockState).createInstance();
        this.axis = (Direction.Axis)this.blockState.m_61143_((Property)SuspensionTrackBlock.AXIS);
        this.rotationAxis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)blockEntity);
        this.rotationMult = this.axis == Direction.Axis.X ? -1.0f : 1.0f;
        this.visualPos = blockEntity.m_58899_();
        this.animateCogs(this.getCogAngle());
    }

    public void beginFrame() {
        float cogAngle = this.getCogAngle();
        if (Mth.m_14033_((float)cogAngle, (float)this.lastAngle)) {
            return;
        }
        this.animateCogs(cogAngle);
    }

    private float getCogAngle() {
        return SuspensionRenderer.getAngleForBE((KineticBlockEntity)this.blockEntity, this.visualPos, this.rotationAxis) * this.rotationMult;
    }

    private void animateCogs(float cogAngle) {
        ((ModelData)((ModelData)((ModelData)((ModelData)this.gantryCogs.loadIdentity().translate((Vec3i)this.getInstancePosition())).centre()).rotateY(this.axis == Direction.Axis.X ? 0.0 : 90.0)).rotateX((double)(-cogAngle * this.rotationMult))).translate(0.0, 0.5625, 0.0).unCentre();
    }

    public void updateLight() {
        this.relight(this.pos, new FlatLit[]{this.gantryCogs, this.rotatingModel});
    }

    public void remove() {
        super.remove();
        this.gantryCogs.delete();
    }
}

