/*
 * Decompiled with CFR 0.152.
 */
package edn.stratodonut.trackwork.tracks.render;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.base.SingleRotatingInstance;
import edn.stratodonut.trackwork.client.TrackworkPartialModels;
import edn.stratodonut.trackwork.tracks.blocks.SuspensionTrackBlock;
import edn.stratodonut.trackwork.tracks.blocks.SuspensionTrackBlockEntity;
import edn.stratodonut.trackwork.tracks.render.SuspensionRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.Property;

public class SuspensionInstance
extends SingleRotatingInstance<SuspensionTrackBlockEntity>
implements DynamicInstance {
    private final ModelData wheels;
    final Direction.Axis axis;
    final Direction.Axis rotationAxis;
    final float rotationMult;
    final BlockPos visualPos;
    private float lastAngle = Float.NaN;

    public SuspensionInstance(MaterialManager materialManager, SuspensionTrackBlockEntity blockEntity) {
        super(materialManager, (KineticBlockEntity)blockEntity);
        this.wheels = (ModelData)this.getTransformMaterial().getModel(TrackworkPartialModels.SUSPENSION_WHEEL, this.blockState).createInstance();
        this.axis = (Direction.Axis)this.blockState.m_61143_((Property)SuspensionTrackBlock.AXIS);
        this.rotationAxis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)blockEntity);
        this.rotationMult = this.axis == Direction.Axis.X ? -1.0f : 1.0f;
        this.visualPos = blockEntity.m_58899_();
        this.animateWheels(this.getCogAngle());
    }

    public void beginFrame() {
        float wheelAngle = this.getCogAngle();
        if (Mth.m_14033_((float)wheelAngle, (float)this.lastAngle)) {
            return;
        }
        this.animateWheels(wheelAngle);
    }

    private float getCogAngle() {
        return SuspensionRenderer.getAngleForBE((KineticBlockEntity)this.blockEntity, this.visualPos, this.rotationAxis) * this.rotationMult;
    }

    private void animateWheels(float wheelAngle) {
        ((ModelData)((ModelData)((ModelData)((ModelData)this.wheels.loadIdentity().translate((Vec3i)this.getInstancePosition())).centre()).rotateY(this.axis == Direction.Axis.X ? 0.0 : 90.0)).translate(0.0, (double)(-((SuspensionTrackBlockEntity)this.blockEntity).getWheelTravel()), 0.0).rotateX((double)(-wheelAngle * this.rotationMult))).translate(0.0, 0.5625, 0.0).unCentre();
    }

    public void updateLight() {
        this.relight(this.pos, new FlatLit[]{this.wheels, this.rotatingModel});
    }

    public void remove() {
        this.rotatingModel.delete();
        this.wheels.delete();
    }
}

