/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.simpleRelays;

import com.jozufozu.flywheel.backend.Backend;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.SimpleKineticBlockEntity;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class BracketedKineticBlockEntityRenderer
extends KineticBlockEntityRenderer<BracketedKineticBlockEntity> {
    public BracketedKineticBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void renderSafe(BracketedKineticBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (Backend.canUseInstancing((Level)be.m_58904_())) {
            return;
        }
        if (!AllBlocks.LARGE_COGWHEEL.has(be.m_58900_())) {
            super.renderSafe(be, partialTicks, ms, buffer, light, overlay);
            return;
        }
        Direction.Axis axis = BracketedKineticBlockEntityRenderer.getRotationAxisOf(be);
        Direction facing = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        BracketedKineticBlockEntityRenderer.renderRotatingBuffer(be, CachedBufferer.partialFacingVertical(AllPartialModels.SHAFTLESS_LARGE_COGWHEEL, be.m_58900_(), facing), ms, buffer.m_6299_(RenderType.m_110451_()), light);
        float angle = BracketedKineticBlockEntityRenderer.getAngleForLargeCogShaft(be, axis);
        SuperByteBuffer shaft = CachedBufferer.partialFacingVertical(AllPartialModels.COGWHEEL_SHAFT, be.m_58900_(), facing);
        BracketedKineticBlockEntityRenderer.kineticRotationTransform(shaft, be, axis, angle, light);
        shaft.renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
    }

    public static float getAngleForLargeCogShaft(SimpleKineticBlockEntity be, Direction.Axis axis) {
        BlockPos pos = be.m_58899_();
        float offset = BracketedKineticBlockEntityRenderer.getShaftAngleOffset(axis, pos);
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.m_58904_());
        float angle = (time * be.getSpeed() * 3.0f / 10.0f + offset) % 360.0f / 180.0f * (float)Math.PI;
        return angle;
    }

    public static float getShaftAngleOffset(Direction.Axis axis, BlockPos pos) {
        float offset = 0.0f;
        double d = ((axis == Direction.Axis.X ? 0 : pos.m_123341_()) + (axis == Direction.Axis.Y ? 0 : pos.m_123342_()) + (axis == Direction.Axis.Z ? 0 : pos.m_123343_())) % 2;
        if (d == 0.0) {
            offset = 22.5f;
        }
        return offset;
    }
}

