/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.sk89q.worldedit.forge.ForgeAdapter;
import com.sk89q.worldedit.forge.ForgeBlockMaterial;
import com.sk89q.worldedit.forge.internal.ForgeTransmogrifier;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.registry.BlockMaterial;
import com.sk89q.worldedit.world.registry.BundledBlockRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalInt;
import java.util.TreeMap;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ForgeBlockRegistry
extends BundledBlockRegistry {
    private final Map<BlockState, ForgeBlockMaterial> materialMap = new HashMap<BlockState, ForgeBlockMaterial>();

    @Override
    public Component getRichName(BlockType blockType) {
        return TranslatableComponent.of(ForgeAdapter.adapt(blockType).m_7705_());
    }

    @Override
    public BlockMaterial getMaterial(BlockType blockType) {
        Block block = ForgeAdapter.adapt(blockType);
        if (block == null) {
            return super.getMaterial(blockType);
        }
        return this.materialMap.computeIfAbsent(block.m_49966_(), s -> new ForgeBlockMaterial((BlockState)s, super.getMaterial(blockType)));
    }

    @Override
    public Map<String, ? extends Property<?>> getProperties(BlockType blockType) {
        Block block = ForgeAdapter.adapt(blockType);
        TreeMap map = new TreeMap();
        Collection propertyKeys = block.m_49966_().m_61147_();
        for (net.minecraft.world.level.block.state.properties.Property key : propertyKeys) {
            map.put(key.m_61708_(), ForgeTransmogrifier.transmogToWorldEditProperty(key));
        }
        return map;
    }

    @Override
    public OptionalInt getInternalBlockStateId(com.sk89q.worldedit.world.block.BlockState state) {
        BlockState equivalent = ForgeAdapter.adapt(state);
        return OptionalInt.of(Block.m_49956_((BlockState)equivalent));
    }
}

