/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.module;

import java.util.List;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.tools.client.tooltip.SeedPouchClientTooltipComponent;
import org.violetmoon.quark.content.tools.item.SeedPouchItem;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.client.event.load.ZTooltipComponents;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.entity.ZEntityItemPickup;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;

@ZetaLoadModule(category="tools")
public class SeedPouchModule
extends ZetaModule {
    @Hint
    public static Item seed_pouch;
    public static final TagKey<Item> seedPouchHoldableTag;
    public static final TagKey<Item> seedPouchFertilizersTag;
    @Config
    public static int maxItems;
    @Config
    public static boolean showAllVariantsInCreative;
    @Config
    public static int shiftRange;
    @Config(description="Allow putting bone meal into the Seed Pouch (or anything else in the tag 'quark:seed_pouch_fertilizers')")
    public static boolean allowFertilizer;
    @Config
    public static int fertilizerShiftRange;

    @LoadEvent
    public final void register(ZRegister event) {
        seed_pouch = new SeedPouchItem(this);
    }

    @PlayEvent
    public void onItemPickup(ZEntityItemPickup event) {
        Player player = event.getPlayer();
        ItemStack toPickup = event.getItem().m_32055_();
        for (ItemStack pouch : List.of(player.m_21205_(), player.m_21206_())) {
            if (pouch.m_41720_() != seed_pouch || pouch.m_41613_() != 1 || !SeedPouchItem.mutateContents(pouch, contents -> !contents.isEmpty() && contents.absorb(toPickup)).booleanValue()) continue;
            Level level = player.m_9236_();
            if (!(level instanceof ServerLevel)) break;
            ServerLevel slevel = (ServerLevel)level;
            slevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_184215_, SoundSource.PLAYERS, 0.2f, (slevel.f_46441_.m_188501_() - slevel.f_46441_.m_188501_()) * 1.4f + 2.0f);
            break;
        }
    }

    static {
        seedPouchHoldableTag = ItemTags.create((ResourceLocation)Quark.asResource("seed_pouch_holdable"));
        seedPouchFertilizersTag = ItemTags.create((ResourceLocation)Quark.asResource("seed_pouch_fertilizers"));
        maxItems = 640;
        showAllVariantsInCreative = true;
        shiftRange = 3;
        allowFertilizer = true;
        fertilizerShiftRange = 3;
    }

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends SeedPouchModule {
        @LoadEvent
        public void clientSetup(ZClientSetup e) {
            e.enqueueWork(() -> ItemProperties.register((Item)seed_pouch, (ResourceLocation)new ResourceLocation("pouch_items"), (ItemPropertyFunction)((ClampedItemPropertyFunction)(pouch, level, entityIn, pSeed) -> {
                int count;
                SeedPouchItem.PouchContents contents = SeedPouchItem.getContents(pouch);
                if (entityIn instanceof Player) {
                    Player player = (Player)entityIn;
                    if (contents.canFit(player.f_36096_.m_142621_())) {
                        return 0.0f;
                    }
                }
                return (count = contents.getCount()) == 0 ? 0.0f : (float)count / (float)maxItems;
            })));
        }

        @LoadEvent
        public void registerClientTooltipComponentFactories(ZTooltipComponents event) {
            event.register(SeedPouchItem.Tooltip.class, t -> new SeedPouchClientTooltipComponent(t.stack()));
        }
    }
}

