/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.registry;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.satisfy.vinery.core.effect.ArmorEffect;
import net.satisfy.vinery.core.effect.ClimbingEffect;
import net.satisfy.vinery.core.effect.CreeperEffect;
import net.satisfy.vinery.core.effect.ExpandableEffect;
import net.satisfy.vinery.core.effect.FrostyArmorEffect;
import net.satisfy.vinery.core.effect.ImprovedHealthEffect;
import net.satisfy.vinery.core.effect.JellieEffect;
import net.satisfy.vinery.core.effect.LavaWalkerEffect;
import net.satisfy.vinery.core.effect.LuckEffect;
import net.satisfy.vinery.core.effect.MagnetEffect;
import net.satisfy.vinery.core.effect.ResistanceEffect;
import net.satisfy.vinery.core.effect.TeleportEffect;
import net.satisfy.vinery.core.effect.WaterWalkerEffect;
import net.satisfy.vinery.core.util.VineryIdentifier;

public class MobEffectRegistry {
    private static final DeferredRegister<MobEffect> MOB_EFFECTS = DeferredRegister.create((String)"vinery", (ResourceKey)Registries.f_256929_);
    private static final Registrar<MobEffect> MOB_EFFECTS_REGISTRAR = MOB_EFFECTS.getRegistrar();
    public static final RegistrySupplier<MobEffect> JELLIE;
    public static final RegistrySupplier<MobEffect> MAGNET;
    public static final RegistrySupplier<MobEffect> TELEPORT;
    public static final RegistrySupplier<MobEffect> IMPROVED_JUMP_BOOST;
    public static final RegistrySupplier<MobEffect> WATER_WALKER;
    public static final RegistrySupplier<MobEffect> CREEPER_EFFECT;
    public static final RegistrySupplier<MobEffect> EXPERIENCE_EFFECT;
    public static final RegistrySupplier<MobEffect> LAVA_WALKER;
    public static final RegistrySupplier<MobEffect> FROSTY_ARMOR_EFFECT;
    public static final RegistrySupplier<MobEffect> PARTY_EFFECT;
    public static final RegistrySupplier<MobEffect> CLIMBING_EFFECT;
    public static final RegistrySupplier<MobEffect> LUCK_EFFECT;
    public static final RegistrySupplier<MobEffect> HEALTH_EFFECT;
    public static final RegistrySupplier<MobEffect> RESISTANCE_EFFECT;
    public static final RegistrySupplier<MobEffect> ARMOR_EFFECT;

    private static RegistrySupplier<MobEffect> registerEffect(String name, Supplier<MobEffect> effect) {
        if (Platform.isForge()) {
            return MOB_EFFECTS.register(name, effect);
        }
        return MOB_EFFECTS_REGISTRAR.register((ResourceLocation)new VineryIdentifier(name), effect);
    }

    public static void init() {
        MOB_EFFECTS.register();
    }

    static {
        ARMOR_EFFECT = MobEffectRegistry.registerEffect("armor_effect", ArmorEffect::new);
        HEALTH_EFFECT = MobEffectRegistry.registerEffect("health_effect", ImprovedHealthEffect::new);
        LUCK_EFFECT = MobEffectRegistry.registerEffect("luck_effect", LuckEffect::new);
        RESISTANCE_EFFECT = MobEffectRegistry.registerEffect("resistance_effect", ResistanceEffect::new);
        EXPERIENCE_EFFECT = MobEffectRegistry.registerEffect("experience_effect", () -> new ExpandableEffect(MobEffectCategory.BENEFICIAL, 65280));
        IMPROVED_JUMP_BOOST = MobEffectRegistry.registerEffect("double_jump", () -> new ExpandableEffect(MobEffectCategory.BENEFICIAL, 65280));
        PARTY_EFFECT = MobEffectRegistry.registerEffect("party_effect", () -> new ExpandableEffect(MobEffectCategory.BENEFICIAL, 0xFF0000));
        TELEPORT = MobEffectRegistry.registerEffect("teleport", TeleportEffect::new);
        CREEPER_EFFECT = MobEffectRegistry.registerEffect("creeper_effect", CreeperEffect::new);
        CLIMBING_EFFECT = MobEffectRegistry.registerEffect("climbing_effect", ClimbingEffect::new);
        FROSTY_ARMOR_EFFECT = MobEffectRegistry.registerEffect("frosty_armor", FrostyArmorEffect::new);
        JELLIE = MobEffectRegistry.registerEffect("jellie", JellieEffect::new);
        LAVA_WALKER = MobEffectRegistry.registerEffect("lava_walker", LavaWalkerEffect::new);
        MAGNET = MobEffectRegistry.registerEffect("magnet", MagnetEffect::new);
        WATER_WALKER = MobEffectRegistry.registerEffect("water_walker", WaterWalkerEffect::new);
    }
}

