/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.util.assertions.stages.constraints;

import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.valkyrienskies.core.impl.util.assertions.stages.constraints.StageConstraint;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B\u001d\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012J'\u0010\b\u001a\u0004\u0018\u00010\u00072\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u001c\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010"}, d2={"Lorg/valkyrienskies/core/impl/util/assertions/stages/constraints/RequireThread;", "S", "Lorg/valkyrienskies/core/impl/util/assertions/stages/constraints/StageConstraint;", "", "stagesSinceReset", "", "isReset", "", "check", "(Ljava/util/List;Z)Ljava/lang/String;", "Ljava/util/function/Predicate;", "Ljava/lang/Thread;", "checkThread", "Ljava/util/function/Predicate;", "", "stages", "[Ljava/lang/Object;", "<init>", "(Ljava/util/function/Predicate;[Ljava/lang/Object;)V"})
public final class RequireThread<S>
implements StageConstraint<S> {
    private final Predicate<Thread> checkThread;
    private final S[] stages;

    public RequireThread(Predicate<Thread> checkThread, S ... stages) {
        Intrinsics.checkNotNullParameter(checkThread, (String)"");
        Intrinsics.checkNotNullParameter(stages, (String)"");
        this.checkThread = checkThread;
        this.stages = stages;
        if (!(!(this.stages.length == 0))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public String check(List<? extends S> stagesSinceReset, boolean isReset) {
        Intrinsics.checkNotNullParameter(stagesSinceReset, (String)"");
        if (ArraysKt.contains((Object[])this.stages, (Object)CollectionsKt.last(stagesSinceReset)) && !this.checkThread.test(Thread.currentThread())) {
            return "Stages " + this.stages + " require a different thread. Current thread: " + Thread.currentThread();
        }
        return null;
    }
}

