/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.entity.handling;

import com.mojang.blaze3d.vertex.PoseStack;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.util.VectorConversionsKt;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.entity.handling.VSEntityHandler;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b-\u0010.J7\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJw\u0010\u001b\u001a\u00020\u000b\"\b\b\u0000\u0010\u000e*\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00028\u00002\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001f\u0010 \u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b \u0010\u001fJ\u001f\u0010#\u001a\u00020!2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b#\u0010$J\u001d\u0010%\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u001d\u00a2\u0006\u0004\b%\u0010\u001fJ5\u0010%\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u0012\u00a2\u0006\u0004\b%\u0010)J7\u0010+\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b+\u0010,\u00a8\u0006/"}, d2={"Lorg/valkyrienskies/mod/common/entity/handling/WorldEntityHandler;", "Lorg/valkyrienskies/mod/common/entity/handling/VSEntityHandler;", "Lorg/valkyrienskies/core/api/ships/ClientShip;", "ship", "Lnet/minecraft/world/entity/Entity;", "self", "passenger", "", "partialTicks", "Lcom/mojang/blaze3d/vertex/PoseStack;", "matrixStack", "", "applyRenderOnMountedEntity", "(Lorg/valkyrienskies/core/api/ships/ClientShip;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/Entity;FLcom/mojang/blaze3d/vertex/PoseStack;)V", "T", "entity", "Lnet/minecraft/client/renderer/entity/EntityRenderer;", "entityRenderer", "", "x", "y", "z", "rotationYaw", "Lnet/minecraft/client/renderer/MultiBufferSource;", "buffer", "", "packedLight", "applyRenderTransform", "(Lorg/valkyrienskies/core/api/ships/ClientShip;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/client/renderer/entity/EntityRenderer;DDDFFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V", "Lorg/valkyrienskies/core/api/ships/Ship;", "entityRemovedFromShipyard", "(Lnet/minecraft/world/entity/Entity;Lorg/valkyrienskies/core/api/ships/Ship;)V", "freshEntityInShipyard", "Lorg/joml/Vector3d;", "pos", "getTeleportPos", "(Lnet/minecraft/world/entity/Entity;Lorg/joml/Vector3d;)Lorg/joml/Vector3d;", "moveEntityFromShipyardToWorld", "entityX", "entityY", "entityZ", "(Lnet/minecraft/world/entity/Entity;Lorg/valkyrienskies/core/api/ships/Ship;DDD)V", "vehicle", "positionSetFromVehicle", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/Entity;DDD)V", "<init>", "()V", "valkyrienskies-120"})
public final class WorldEntityHandler
implements VSEntityHandler {
    @NotNull
    public static final WorldEntityHandler INSTANCE = new WorldEntityHandler();

    private WorldEntityHandler() {
    }

    @Override
    public void freshEntityInShipyard(@NotNull Entity entity, @NotNull Ship ship) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        this.moveEntityFromShipyardToWorld(entity, ship);
    }

    @Override
    public void entityRemovedFromShipyard(@NotNull Entity entity, @NotNull Ship ship) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
    }

    @Override
    public <T extends Entity> void applyRenderTransform(@NotNull ClientShip ship, @NotNull T entity, @NotNull EntityRenderer<T> entityRenderer, double x2, double y2, double z2, float rotationYaw, float partialTicks, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource buffer, int packedLight) {
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        Intrinsics.checkNotNullParameter(entityRenderer, (String)"entityRenderer");
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Vec3 offset = entityRenderer.m_7860_(entity, partialTicks);
        matrixStack.m_85837_(x2 + offset.f_82479_, y2 + offset.f_82480_, z2 + offset.f_82481_);
    }

    @Override
    public void positionSetFromVehicle(@NotNull Entity self, @NotNull Entity vehicle, double x2, double y2, double z2) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Vector3d vector3d = VSGameUtilsKt.toWorldCoordinates$default(self.m_9236_(), x2, y2, z2, null, 8, null);
        double wx2 = VectorConversionsKt.component1((Vector3dc)((Vector3dc)vector3d));
        double wy2 = VectorConversionsKt.component2((Vector3dc)((Vector3dc)vector3d));
        double wz2 = VectorConversionsKt.component3((Vector3dc)((Vector3dc)vector3d));
        self.m_6034_(wx2, wy2, wz2);
    }

    @Override
    @NotNull
    public Vector3d getTeleportPos(@NotNull Entity self, @NotNull Vector3d pos) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return VSGameUtilsKt.toWorldCoordinates(self.m_9236_(), pos);
    }

    @Override
    public void applyRenderOnMountedEntity(@NotNull ClientShip ship, @NotNull Entity self, @NotNull Entity passenger, float partialTicks, @NotNull PoseStack matrixStack) {
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)passenger, (String)"passenger");
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
    }

    public final void moveEntityFromShipyardToWorld(@NotNull Entity entity, @NotNull Ship ship) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        this.moveEntityFromShipyardToWorld(entity, ship, entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
    }

    public final void moveEntityFromShipyardToWorld(@NotNull Entity entity, @NotNull Ship ship, double entityX, double entityY, double entityZ) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        Vector3d newPos = ship.getShipToWorld().transformPosition(new Vector3d(entityX, entityY, entityZ));
        entity.m_6034_(newPos.x, newPos.y, newPos.z);
        entity.f_19854_ = entity.m_20185_();
        entity.f_19855_ = entity.m_20186_();
        entity.f_19856_ = entity.m_20189_();
        Vector3d newPosInShipLocal = new Vector3d((Vector3dc)newPos).sub(ship.getTransform().getPositionInWorld());
        Vector3d shipVelocity = new Vector3d(ship.getVelocity()).add((Vector3dc)new Vector3d(ship.getOmega()).cross((Vector3dc)newPosInShipLocal)).mul(0.05);
        Quaterniondc quaterniondc = ship.getTransform().getShipToWorldRotation();
        Vec3 vec3 = entity.m_20184_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getDeltaMovement(...)");
        Vector3d entityVelocity = quaterniondc.transform(VectorConversionsMCKt.toJOML(vec3));
        Vector3d vector3d = new Vector3d((Vector3dc)entityVelocity).add((Vector3dc)shipVelocity);
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"add(...)");
        entity.m_20256_(VectorConversionsMCKt.toMinecraft((Vector3dc)vector3d));
        Quaterniondc quaterniondc2 = ship.getTransform().getShipToWorldRotation();
        Vec3 vec32 = entity.m_20154_();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getLookAngle(...)");
        Vector3d direction = quaterniondc2.transform(VectorConversionsMCKt.toJOML(vec32));
        double yaw = -Math.atan2(direction.x, direction.z);
        double pitch = -Math.atan2(direction.y, Math.sqrt(direction.x * direction.x + direction.z * direction.z));
        entity.m_146922_((float)(yaw * 57.29577951308232));
        entity.m_146926_((float)(pitch * 57.29577951308232));
        entity.f_19859_ = entity.m_146908_();
        entity.f_19860_ = entity.m_146909_();
        if (entity instanceof AbstractHurtingProjectile) {
            Vector3d power = new Vector3d(((AbstractHurtingProjectile)entity).f_36813_, ((AbstractHurtingProjectile)entity).f_36814_, ((AbstractHurtingProjectile)entity).f_36815_);
            ship.getTransform().getShipToWorldRotation().transform(power);
            ((AbstractHurtingProjectile)entity).f_36813_ = power.x;
            ((AbstractHurtingProjectile)entity).f_36814_ = power.y;
            ((AbstractHurtingProjectile)entity).f_36815_ = power.z;
        }
    }
}

