/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.feature.get_entities;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.util.RateLimiter;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.util.BugFixUtil;

@Mixin(value={Level.class})
public class MixinLevel {
    @Unique
    private static final Logger LOGGER = LogManager.getLogger((String)"VS2 Get Entities Mixin");
    @Unique
    private static final RateLimiter LIMITER = new RateLimiter(Duration.ofSeconds(5L));

    @ModifyVariable(method={"getEntities(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;)Ljava/util/List;"}, at=@At(value="HEAD"), argsOnly=true)
    private AABB moveAABB1(AABB aabb) {
        return VSGameUtilsKt.transformAabbToWorld((Level)Level.class.cast(this), aabb);
    }

    @ModifyVariable(method={"getEntities(Lnet/minecraft/world/level/entity/EntityTypeTest;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;)Ljava/util/List;"}, at=@At(value="HEAD"), argsOnly=true)
    private AABB moveAABB2(AABB aabb) {
        return VSGameUtilsKt.transformAabbToWorld((Level)Level.class.cast(this), aabb);
    }

    @Inject(method={"getEntities(Lnet/minecraft/world/level/entity/EntityTypeTest;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;)Ljava/util/List;"}, at={@At(value="HEAD")}, cancellable=true)
    private <T extends Entity> void check1(EntityTypeTest<Entity, T> entityTypeTest, AABB area, Predicate<? super T> predicate, CallbackInfoReturnable<List<T>> cir) {
        if (BugFixUtil.INSTANCE.isCollisionBoxToBig(area)) {
            LIMITER.maybeRun(() -> LOGGER.error((Object)new Exception("Collision box is too big! " + String.valueOf(area) + " returning empty list! this might break things")));
            cir.setReturnValue(Collections.emptyList());
            cir.cancel();
        }
    }

    @Inject(method={"getEntities(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;)Ljava/util/List;"}, at={@At(value="HEAD")}, cancellable=true)
    private <T extends Entity> void check2(@Nullable Entity entity, AABB area, Predicate<? super Entity> predicate, CallbackInfoReturnable<List<Entity>> cir) {
        if (BugFixUtil.INSTANCE.isCollisionBoxToBig(area)) {
            LIMITER.maybeRun(() -> LOGGER.error((Object)new Exception("Collision box is too big! " + String.valueOf(area) + " returning empty list! this might break things")));
            cir.setReturnValue(Collections.emptyList());
            cir.cancel();
        }
    }
}

