/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.feature.render_ship_debug_bb;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.world.phys.AABB;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBdc;
import org.joml.primitives.AABBic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.apigame.world.ClientShipWorldCore;
import org.valkyrienskies.mod.common.VSClientGameUtils;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Mixin(value={DebugRenderer.class})
public class MixinDebugRenderer {
    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void postRender(PoseStack matrices, MultiBufferSource.BufferSource vertexConsumersIgnore, double cameraX, double cameraY, double cameraZ, CallbackInfo ci2) {
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        ClientShipWorldCore shipObjectClientWorld = VSGameUtilsKt.getShipObjectWorld(world);
        if (Minecraft.m_91087_().m_91290_().m_114377_()) {
            for (ClientShip shipObjectClient : shipObjectClientWorld.getLoadedShips()) {
                ShipTransform shipRenderTransform = shipObjectClient.getRenderTransform();
                Vector3dc shipRenderPosition = shipRenderTransform.getShipPositionInWorldCoordinates();
                double renderRadius = 0.25;
                AABB shipCenterOfMassBox = new AABB(shipRenderPosition.x() - 0.25, shipRenderPosition.y() - 0.25, shipRenderPosition.z() - 0.25, shipRenderPosition.x() + 0.25, shipRenderPosition.y() + 0.25, shipRenderPosition.z() + 0.25).m_82386_(-cameraX, -cameraY, -cameraZ);
                LevelRenderer.m_109646_((PoseStack)matrices, (VertexConsumer)bufferSource.m_6299_(RenderType.m_110504_()), (AABB)shipCenterOfMassBox, (float)0.98039216f, (float)0.7607843f, (float)0.07450981f, (float)1.0f);
                AABBic shipVoxelAABBic = shipObjectClient.getShipAABB();
                if (shipVoxelAABBic != null) {
                    matrices.m_85836_();
                    Vector3d centerOfAABB = shipVoxelAABBic.center(new Vector3d());
                    AABB shipVoxelAABBAfterOffset = new AABB((double)shipVoxelAABBic.minX() - centerOfAABB.x(), (double)shipVoxelAABBic.minY() - centerOfAABB.y(), (double)shipVoxelAABBic.minZ() - centerOfAABB.z(), (double)shipVoxelAABBic.maxX() - centerOfAABB.x(), (double)shipVoxelAABBic.maxY() - centerOfAABB.y(), (double)shipVoxelAABBic.maxZ() - centerOfAABB.z());
                    VSClientGameUtils.transformRenderWithShip(shipRenderTransform, matrices, centerOfAABB.x(), centerOfAABB.y(), centerOfAABB.z(), cameraX, cameraY, cameraZ);
                    LevelRenderer.m_109646_((PoseStack)matrices, (VertexConsumer)bufferSource.m_6299_(RenderType.m_110504_()), (AABB)shipVoxelAABBAfterOffset, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    matrices.m_85849_();
                }
                AABBdc shipRenderAABBdc = shipObjectClient.getRenderAABB();
                AABB shipRenderAABB = VectorConversionsMCKt.toMinecraft(shipRenderAABBdc);
                LevelRenderer.m_109646_((PoseStack)matrices, (VertexConsumer)bufferSource.m_6299_(RenderType.m_110504_()), (AABB)shipRenderAABB.m_82386_(-cameraX, -cameraY, -cameraZ), (float)0.91764706f, (float)0.0f, (float)0.8509804f, (float)1.0f);
            }
        }
        bufferSource.m_109911_();
    }
}

