/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.feature.teleport_reconnected_player_to_ship;

import com.mojang.authlib.GameProfile;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.config.VSGameConfig;
import org.valkyrienskies.mod.common.util.EntityDraggingInformation;
import org.valkyrienskies.mod.common.util.IEntityDraggingInformationProvider;

@Mixin(value={ServerPlayer.class})
public abstract class MixinServerPlayer
extends Player {
    @Shadow
    public abstract ServerLevel m_284548_();

    public MixinServerPlayer(Level level, BlockPos blockPos, float f2, GameProfile gameProfile) {
        super(level, blockPos, f2, gameProfile);
        throw new IllegalStateException("Unreachable");
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    void teleportToShip(CompoundTag compoundTag, CallbackInfo ci2) {
        if (!VSGameConfig.SERVER.getTeleportReconnectedPlayers()) {
            return;
        }
        if (!compoundTag.m_128441_("LastShipId")) {
            return;
        }
        long lastShipId = compoundTag.m_128454_("LastShipId");
        Ship ship = VSGameUtilsKt.getShipObjectWorld(this.m_284548_()).getAllShips().getById(lastShipId);
        if (ship == null) {
            return;
        }
        double x2 = compoundTag.m_128459_("RelativeShipX");
        double y2 = compoundTag.m_128459_("RelativeShipY");
        double z2 = compoundTag.m_128459_("RelativeShipZ");
        Vector3d playerShipPosition = new Vector3d(x2, y2, z2);
        Vector3d playerWorldPosition = ship.getShipToWorld().transformPosition(playerShipPosition);
        this.m_6034_(playerWorldPosition.x, playerWorldPosition.y, playerWorldPosition.z);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    void rememberLastShip(CompoundTag compoundTag, CallbackInfo ci2) {
        EntityDraggingInformation draggingInformation = ((IEntityDraggingInformationProvider)((Object)this)).getDraggingInformation();
        if (draggingInformation.getTicksSinceStoodOnShip() > VSGameConfig.SERVER.getMaxAirborneTicksForReconnectedPlayerTeleport()) {
            return;
        }
        Long lastShipId = draggingInformation.getLastShipStoodOn();
        if (lastShipId == null) {
            return;
        }
        Ship ship = VSGameUtilsKt.getShipObjectWorld(this.m_284548_()).getAllShips().getById(lastShipId.longValue());
        if (ship == null) {
            return;
        }
        compoundTag.m_128356_("LastShipId", lastShipId.longValue());
        Vector3d playerWorldPosition = new Vector3d(this.m_20185_(), this.m_20186_(), this.m_20189_());
        Vector3d playerShipPosition = ship.getWorldToShip().transformPosition(playerWorldPosition);
        compoundTag.m_128347_("RelativeShipX", playerShipPosition.x);
        compoundTag.m_128347_("RelativeShipY", playerShipPosition.y);
        compoundTag.m_128347_("RelativeShipZ", playerShipPosition.z);
    }
}

